/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        List<PackageFragmentDescriptor> packageFragments2 = this.packageFragmentProvider.getPackageFragments(fqName2);
        for (PackageFragmentDescriptor fragment : packageFragments2) {
            ClassDataWithSource classDataWithSource;
            if (!(fragment instanceof DeserializedPackageFragment)) continue;
            ClassDataWithSource classDataWithSource2 = ((DeserializedPackageFragment)fragment).getClassDataFinder().findClassData(classId);
            if (classDataWithSource2 == null) continue;
            ClassDataWithSource it = classDataWithSource = classDataWithSource2;
            return it;
        }
        return null;
    }

    public DeserializedClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        this.packageFragmentProvider = packageFragmentProvider;
    }
}

