/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0014J\b\u0010\u0011\u001a\u00020\tH\u0014J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/branch/GitCreateBranchOperation;", "Lgit4idea/branch/GitBranchOperation;", "project", "Lcom/intellij/openapi/project/Project;", "git", "Lgit4idea/commands/Git;", "uiHandler", "Lgit4idea/branch/GitBranchUiHandler;", "branchName", "", "startPoints", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Lgit4idea/branch/GitBranchUiHandler;Ljava/lang/String;Ljava/util/Map;)V", "execute", "", "getOperationName", "getRollbackProposal", "getSuccessMessage", "rollback", "git4idea"})
public final class GitCreateBranchOperation
extends GitBranchOperation {
    private final String branchName;
    private final Map<GitRepository, String> startPoints;

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitCommandResult result2;
            GitRepository repository = this.next();
            String string = this.startPoints.get(repository);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((result2 = this.myGit.branchCreate(repository, this.branchName, string)).success()) {
                repository.update();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError("Couldn't create new branch " + this.branchName, result2.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.updateRecentBranch(this.branchName);
        }
    }

    @Override
    protected void rollback() {
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            deleteResult.append(repository, this.myGit.branchDelete(repository, this.branchName, false, new GitLineHandlerListener[0]));
            repository.update();
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        if (deleteResult.totalSuccess()) {
            vcsNotifier.notifySuccess("Rollback successful", "Deleted " + this.branchName);
        } else {
            vcsNotifier.notifyError("Error during rollback", deleteResult.getErrorOutputWithReposIndication());
        }
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return "Branch <b><code>" + this.branchName + "</code></b> was created";
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return StringsKt.trimIndent((String)("\n    However the branch was created in the following " + this.repositories() + ":<br/>\n    " + this.successfulRepositoriesJoined() + "<br/>\n    You may rollback (delete " + this.branchName + ") not to let branches diverge."));
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "create branch";
    }

    public GitCreateBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String branchName, @NotNull Map<GitRepository, String> startPoints) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        Intrinsics.checkParameterIsNotNull(startPoints, (String)"startPoints");
        super(project, git, uiHandler, (Collection<GitRepository>)startPoints.keySet());
        this.branchName = branchName;
        this.startPoints = startPoints;
    }
}

