/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.connections.pserver.PServerCvsSettings;
import com.intellij.cvsSupport2.cvsIgnore.IgnoreFileFilterBasedOnCvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.common.ReceivedFileProcessor;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesListener;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesTranslator;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnCache;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminWriterOnCache;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.javacvsImpl.FileReadOnlyHandler;
import com.intellij.cvsSupport2.javacvsImpl.ProjectContentInfoProvider;
import com.intellij.cvsSupport2.javacvsImpl.io.LocalFileReaderBasedOnVFS;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.javacvsImpl.io.ReceiveTextFilePreprocessor;
import com.intellij.cvsSupport2.javacvsImpl.io.SendTextFilePreprocessor;
import com.intellij.cvsSupport2.javacvsImpl.io.StoringLineSeparatorsLocalFileWriter;
import com.intellij.cvsSupport2.javacvsImpl.io.StreamLogger;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.ClientEnvironment;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.RequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.IGlobalOptions;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.update.UpdateFileInfo;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.event.IFileInfoListener;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.event.IModuleExpansionListener;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;
import org.netbeans.lib.cvsclient.io.IStreamLogger;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public abstract class CvsCommandOperation
extends CvsOperation
implements IFileInfoListener,
IMessageListener,
IEntryListener,
IModuleExpansionListener,
ProjectContentInfoProvider {
    private static final IAdminReader DEFAULT_ADMIN_READER = new AdminReaderOnCache();
    protected final IAdminReader myAdminReader;
    protected final IAdminWriter myAdminWriter;
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.common.CvsCommandOperation");
    private String myLastProcessedCvsRoot;
    private final UpdatedFilesManager myUpdatedFilesManager = new UpdatedFilesManager();

    protected CvsCommandOperation() {
        this(DEFAULT_ADMIN_READER);
    }

    protected CvsCommandOperation(IAdminReader adminReader, IAdminWriter adminWriter) {
        this.myAdminReader = adminReader;
        this.myAdminWriter = adminWriter;
    }

    protected CvsCommandOperation(IAdminReader adminReader) {
        this.myAdminReader = adminReader;
        this.myAdminWriter = new AdminWriterOnCache(this.myUpdatedFilesManager, this);
    }

    protected abstract Command createCommand(CvsRootProvider var1, CvsExecutionEnvironment var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CvsExecutionEnvironment executionEnvironment, boolean underReadAction) throws VcsException, CommandAbortedException {
        if (this.runInExclusiveLock()) {
            Class<CvsOperation> clazz = CvsOperation.class;
            synchronized (CvsOperation.class) {
                this.doExecute(executionEnvironment, underReadAction);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.doExecute(executionEnvironment, underReadAction);
        }
    }

    @Override
    public void appendSelfCvsRootProvider(@NotNull Collection<CvsEnvironment> roots) throws CannotFindCvsRootException {
        if (roots == null) {
            CvsCommandOperation.$$$reportNull$$$0(0);
        }
        roots.addAll(this.getAllCvsRoots());
    }

    private void doExecute(CvsExecutionEnvironment executionEnvironment, boolean underReadAction) throws VcsException {
        VcsException[] exc = new VcsException[1];
        Runnable action = () -> {
            try {
                Collection<CvsRootProvider> allCvsRoots;
                ReadWriteStatistics statistics = executionEnvironment.getReadWriteStatistics();
                try {
                    allCvsRoots = this.getAllCvsRoots();
                }
                catch (CannotFindCvsRootException e) {
                    throw CvsCommandOperation.createVcsExceptionOn(e, null);
                }
                IProgressViewer progressViewer = new IProgressViewer(){

                    public void setProgress(double value) {
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            progressIndicator.setFraction(value);
                        }
                    }
                };
                int count = 0;
                double step = 1.0 / (double)allCvsRoots.size();
                for (CvsRootProvider cvsRootProvider : allCvsRoots) {
                    try {
                        double lowerBound = step * (double)count;
                        RangeProgressViewer partialProgress = new RangeProgressViewer(progressViewer, lowerBound, lowerBound + step);
                        this.myLastProcessedCvsRoot = cvsRootProvider.getCvsRootAsString();
                        this.execute(cvsRootProvider, executionEnvironment, statistics, (IProgressViewer)partialProgress);
                        ++count;
                    }
                    catch (IOCommandException e) {
                        LOG.info((Throwable)e);
                        throw CvsCommandOperation.createVcsExceptionOn(e.getIOException(), cvsRootProvider.getCvsRootAsString());
                    }
                    catch (CommandException e) {
                        LOG.info((Throwable)e);
                        Exception underlyingException = e.getUnderlyingException();
                        if (underlyingException == null) throw CvsCommandOperation.createVcsExceptionOn((Exception)(underlyingException == null ? e : underlyingException), cvsRootProvider.getCvsRootAsString());
                        LOG.info((Throwable)underlyingException);
                        throw CvsCommandOperation.createVcsExceptionOn((Exception)(underlyingException == null ? e : underlyingException), cvsRootProvider.getCvsRootAsString());
                        return;
                    }
                }
            }
            catch (VcsException e) {
                exc[0] = e;
            }
        };
        if (underReadAction) {
            ApplicationManager.getApplication().runReadAction(action);
        } else {
            action.run();
        }
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    private static VcsException createVcsExceptionOn(Exception e, String cvsRoot) {
        LOG.debug((Throwable)e);
        String message = CvsCommandOperation.getMessageFrom(null, e);
        if (message == null) {
            return new CvsException(CvsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0]), e, cvsRoot);
        }
        return new CvsException(message, e, cvsRoot);
    }

    private static String getMessageFrom(String initialMessage, Throwable e) {
        if (e == null) {
            return initialMessage;
        }
        String result = initialMessage;
        if (result != null && !result.isEmpty()) {
            return result;
        }
        result = e.getLocalizedMessage();
        if (result == null || result.isEmpty()) {
            result = e.getMessage();
        }
        return CvsCommandOperation.getMessageFrom(result, e.getCause());
    }

    protected abstract Collection<CvsRootProvider> getAllCvsRoots() throws CannotFindCvsRootException;

    protected void execute(CvsRootProvider root, CvsExecutionEnvironment executionEnvironment, ReadWriteStatistics statistics, IProgressViewer progressViewer) throws CommandException, VcsException {
        IConnection connection = root.createConnection(statistics);
        this.execute(root, executionEnvironment, connection, progressViewer);
    }

    public void execute(CvsRootProvider root, CvsExecutionEnvironment executionEnvironment, IConnection connection, IProgressViewer progressViewer) throws CommandException {
        Command command = this.createCommand(root, executionEnvironment);
        if (command == null) {
            return;
        }
        LOG.assertTrue(connection != null, (Object)root.getCvsRootAsString());
        CvsMessagesListener cvsMessagesListener = executionEnvironment.getCvsMessagesListener();
        long start = System.currentTimeMillis();
        try {
            IClientEnvironment clientEnvironment = this.createEnvironment(connection, root, this.myUpdatedFilesManager, executionEnvironment);
            this.myUpdatedFilesManager.setCvsFileSystem(clientEnvironment.getCvsFileSystem());
            EventManager eventManager = new EventManager(CvsApplicationLevelConfiguration.getCharset());
            GlobalOptions globalOptions = command.getGlobalOptions();
            RequestProcessor requestProcessor = new RequestProcessor(clientEnvironment, (IGlobalOptions)globalOptions, (IEventSender)eventManager, (IStreamLogger)new StreamLogger(), executionEnvironment.getCvsCommandStopper(), (long)PServerCvsSettings.getTimeoutMillis());
            eventManager.addFileInfoListener((IFileInfoListener)this);
            eventManager.addEntryListener((IEntryListener)this);
            eventManager.addMessageListener((IMessageListener)this);
            eventManager.addModuleExpansionListener((IModuleExpansionListener)this);
            CvsMessagesTranslator cvsMessagesTranslator = new CvsMessagesTranslator(cvsMessagesListener, clientEnvironment.getCvsFileSystem(), this.myUpdatedFilesManager, root.getCvsRootAsString());
            cvsMessagesTranslator.registerTo(eventManager);
            CvsEntriesManager cvsEntriesManager = CvsEntriesManager.getInstance();
            if (this.shouldMakeChangesOnTheLocalFileSystem()) {
                eventManager.addEntryListener((IEntryListener)new MergeSupportingEntryListener(clientEnvironment, cvsEntriesManager, this.myUpdatedFilesManager));
                eventManager.addMessageListener((IMessageListener)this.myUpdatedFilesManager);
            }
            this.modifyOptions(command.getGlobalOptions());
            String commandString = CvsCommandOperation.composeCommandString(root, command);
            cvsMessagesListener.commandStarted(commandString);
            CvsCommandOperation.setProgressText(CvsBundle.message((String)"progress.text.command.running.for.file", (Object[])new Object[]{this.getOperationName(), root.getCvsRootAsString()}));
            try {
                command.execute((IRequestProcessor)requestProcessor, (IEventSender)eventManager, (ICvsListenerRegistry)eventManager, clientEnvironment, progressViewer);
            }
            catch (AuthenticationException e) {
                throw root.processException(new CommandException((Exception)((Object)e), "Authentication problem"));
            }
            cvsMessagesTranslator.operationCompleted();
        }
        catch (CommandException t) {
            throw root.processException(t);
        }
        finally {
            cvsMessagesListener.commandFinished(CvsCommandOperation.composeCommandString(root, command), System.currentTimeMillis() - start);
            this.executeFinishActions();
        }
    }

    @NonNls
    protected abstract String getOperationName();

    private static String composeCommandString(CvsRootProvider root, Command command) {
        StringBuilder result = new StringBuilder();
        result.append(root.getLocalRoot());
        result.append(" cvs ");
        GlobalOptions globalOptions = command.getGlobalOptions();
        if (globalOptions.isCheckedOutFilesReadOnly()) {
            result.append("-r ");
        }
        if (globalOptions.isDoNoChanges()) {
            result.append("-n ");
        }
        if (globalOptions.isNoHistoryLogging()) {
            result.append("-l ");
        }
        if (globalOptions.isSomeQuiet()) {
            result.append("-q ");
        }
        result.append(command.getCvsCommandLine());
        return result.toString();
    }

    protected boolean shouldMakeChangesOnTheLocalFileSystem() {
        return true;
    }

    protected boolean runInExclusiveLock() {
        return true;
    }

    private static void setProgressText(String text) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(text);
        }
    }

    private IClientEnvironment createEnvironment(IConnection connection, CvsRootProvider root, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnv) {
        File localRoot = this.getLocalRootFor(root);
        File adminRoot = this.getAdminRootFor(root);
        LOG.assertTrue(localRoot != null, (Object)this.getClass().getName());
        LOG.assertTrue(adminRoot != null, (Object)this.getClass().getName());
        return new ClientEnvironment(connection, localRoot, adminRoot, root.getCvsRoot(), this.createLocalFileReader(), this.createLocalFileWriter(root.getCvsRootAsString(), mergedFilesCollector, cvsExecutionEnv), this.myAdminReader, this.myAdminWriter, this.getIgnoreFileFilter(), (IFileReadOnlyHandler)new FileReadOnlyHandler(), CvsApplicationLevelConfiguration.getCharset());
    }

    protected ILocalFileWriter createLocalFileWriter(String cvsRoot, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnvironment) {
        return new StoringLineSeparatorsLocalFileWriter(new ReceiveTextFilePreprocessor(this.createReceivedFileProcessor(mergedFilesCollector, cvsExecutionEnvironment.getPostCvsActivity())), cvsExecutionEnvironment.getErrorProcessor(), this.myUpdatedFilesManager, cvsRoot, this);
    }

    protected ReceivedFileProcessor createReceivedFileProcessor(UpdatedFilesManager mergedFilesCollector, PostCvsActivity postCvsActivity) {
        return ReceivedFileProcessor.DEFAULT;
    }

    protected ILocalFileReader createLocalFileReader() {
        return new LocalFileReaderBasedOnVFS(new SendTextFilePreprocessor(), this);
    }

    protected IIgnoreFileFilter getIgnoreFileFilter() {
        return new IgnoreFileFilterBasedOnCvsEntriesManager();
    }

    protected File getAdminRootFor(CvsRootProvider root) {
        return root.getAdminRoot();
    }

    protected File getLocalRootFor(CvsRootProvider root) {
        return root.getLocalRoot();
    }

    public void fileInfoGenerated(Object info) {
        UpdateFileInfo updateFileInfo;
        if (info instanceof UpdateFileInfo && "C".equals((updateFileInfo = (UpdateFileInfo)info).getType())) {
            CvsUtil.addConflict(updateFileInfo.getFile());
        }
    }

    public void gotEntry(FileObject fileObject, Entry entry) {
    }

    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
    }

    public void moduleExpanded(String module) {
    }

    @Override
    public boolean fileIsUnderProject(VirtualFile file) {
        return true;
    }

    @Override
    public boolean fileIsUnderProject(File file) {
        return true;
    }

    @Override
    public String getLastProcessedCvsRoot() {
        return this.myLastProcessedCvsRoot;
    }

    public void binaryMessageSent(byte[] bytes) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/cvsSupport2/cvsoperations/common/CvsCommandOperation", "appendSelfCvsRootProvider"));
    }

    private static class MergeSupportingEntryListener
    implements IEntryListener {
        private final IClientEnvironment myClientEnvironment;
        private final CvsEntriesManager myCvsEntriesManager;
        private final UpdatedFilesManager myUpdatedFilesManager;
        private final Map<File, Entry> myFileToPreviousEntryMap = new HashMap<File, Entry>();

        public MergeSupportingEntryListener(IClientEnvironment clientEnvironment, CvsEntriesManager cvsEntriesManager, UpdatedFilesManager mergedFilesCollector) {
            this.myClientEnvironment = clientEnvironment;
            this.myCvsEntriesManager = cvsEntriesManager;
            this.myUpdatedFilesManager = mergedFilesCollector;
        }

        public void gotEntry(FileObject fileObject, Entry entry) {
            IFileSystem localFileSystem = this.myClientEnvironment.getCvsFileSystem().getLocalFileSystem();
            File file = localFileSystem.getFile((AbstractFileObject)fileObject);
            if (this.myUpdatedFilesManager.fileIsNotUpdated(file)) {
                return;
            }
            File parent = file.getParentFile();
            VirtualFile virtualParent = CvsVfsUtil.findFileByIoFile(parent);
            if (entry != null) {
                Entry previousEntry;
                Entry entry2 = previousEntry = this.myFileToPreviousEntryMap.containsKey(file) ? this.myFileToPreviousEntryMap.get(file) : CvsEntriesManager.getInstance().getCachedEntry(virtualParent, entry.getFileName());
                if (previousEntry != null) {
                    this.myFileToPreviousEntryMap.put(file, previousEntry);
                    if (entry.isResultOfMerge()) {
                        UpdatedFilesManager.CurrentMergedFileInfo info = this.myUpdatedFilesManager.getInfo(file);
                        info.registerNewRevision(previousEntry);
                        CvsUtil.saveRevisionForMergedFile(virtualParent, info.getOriginalEntry(), info.getRevisions());
                    }
                }
            } else {
                this.myCvsEntriesManager.removeEntryForFile(parent, fileObject.getName());
            }
            if (entry != null) {
                this.myCvsEntriesManager.setEntryForFile(virtualParent, entry);
            }
            if (entry == null || !entry.isResultOfMerge()) {
                CvsUtil.removeConflict(file);
            }
        }
    }
}

