/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui.AbstractAddOptionsDialog;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui.AddedFileCellRenderer;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ComboBoxTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class AddMultipleFilesOptionsDialog
extends AbstractAddOptionsDialog {
    private final Collection<AddedFileInfo> myRoots;
    private static final JCheckBox CHECKBOX = new JCheckBox();
    private final ColumnInfo INCLUDED = new ColumnInfo(""){

        public Object valueOf(Object object) {
            return ((AddedFileInfo)object).included();
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public boolean isCellEditable(Object o) {
            return true;
        }

        public void setValue(Object o, Object aValue) {
            AddedFileInfo node = (AddedFileInfo)o;
            node.setIncluded((Boolean)aValue);
            AddMultipleFilesOptionsDialog.this.myModel.nodeChanged((TreeNode)node);
        }

        public int getWidth(JTable table) {
            return CHECKBOX.getPreferredSize().width + 4;
        }
    };
    private static final ColumnInfo<AddedFileInfo, AddedFileInfo> FILE = new ColumnInfo<AddedFileInfo, AddedFileInfo>(CvsBundle.message((String)"add.multiple.files.file.column.name", (Object[])new Object[0])){

        public AddedFileInfo valueOf(AddedFileInfo object) {
            return object;
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }

        public boolean isCellEditable(AddedFileInfo o) {
            return true;
        }
    };
    private static final ColumnInfo KEYWORD_SUBSTITUTION = new ColumnInfo(CvsBundle.message((String)"add.multiple.files.keyword.substitution.column.name", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((AddedFileInfo)object).getKeywordSubstitutionsWithSelection();
        }

        public boolean isCellEditable(Object o) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)o;
            if (addedFileInfo.getFile().isDirectory()) {
                return false;
            }
            return addedFileInfo.included();
        }

        public void setValue(Object o, Object aValue) {
            AddedFileInfo fileInfo = (AddedFileInfo)o;
            KeywordSubstitutionWrapper substitutionWrapper = (KeywordSubstitutionWrapper)aValue;
            KeywordSubstitution substitution = substitutionWrapper.getSubstitution();
            fileInfo.setKeywordSubstitution(substitution);
        }

        public TableCellRenderer getRenderer(Object o) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)o;
            if (addedFileInfo.getFile().isDirectory()) {
                return TABLE_CELL_RENDERER;
            }
            return ComboBoxTableCellRenderer.INSTANCE;
        }

        public TableCellEditor getEditor(Object item) {
            return ComboBoxTableCellEditor.INSTANCE;
        }

        public int getWidth(JTable table) {
            return table.getFontMetrics(table.getFont()).stringWidth(this.getName()) + 10;
        }
    };
    private final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.INCLUDED, FILE, KEYWORD_SUBSTITUTION};
    private TreeTable myTreeTable;
    private ListTreeTableModelOnColumns myModel;
    private static final JPanel J_PANEL = new JPanel();
    private static final TableCellRenderer TABLE_CELL_RENDERER = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            J_PANEL.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return J_PANEL;
        }
    };
    private final Observer myObserver;

    public AddMultipleFilesOptionsDialog(Project project, Collection<AddedFileInfo> roots, Options options) {
        super(project, options);
        this.myRoots = roots;
        this.myObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AddMultipleFilesOptionsDialog.this.setOKButtonEnabling();
            }
        };
        for (AddedFileInfo myRoot : this.myRoots) {
            myRoot.addIncludedObserver(this.myObserver);
        }
        this.setTitle(CvsBundle.message((String)"dialog.title.add.files.to.cvs", (Object[])new Object[0]));
        this.createTree();
        this.expandAll();
        this.init();
        this.setOKButtonEnabling();
    }

    private void setOKButtonEnabling() {
        this.setOKActionEnabled(this.hasIncludedNodes());
    }

    private boolean hasIncludedNodes() {
        for (AddedFileInfo addedFileInfo : this.myRoots) {
            if (!addedFileInfo.hasIncludedNodes()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        for (AddedFileInfo myRoot : this.myRoots) {
            myRoot.removeIncludedObserver(this.myObserver);
        }
    }

    private void expandAll() {
        TreeTableTree tree = this.myTreeTable.getTree();
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    private void createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (AddedFileInfo myRoot : this.myRoots) {
            root.add(myRoot);
        }
        this.myModel = new ListTreeTableModelOnColumns((TreeNode)root, this.COLUMNS);
        this.myTreeTable = new TreeTableView(this.myModel);
        int comboHeight = new JComboBox<E>().getPreferredSize().height;
        int checkBoxHeight = new JCheckBox().getPreferredSize().height;
        this.myTreeTable.setMinRowHeight(Math.max(comboHeight, checkBoxHeight) + 2);
        this.myTreeTable.setRootVisible(false);
        JTableHeader tableHeader = this.myTreeTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(false);
        TreeTableTree tree = this.myTreeTable.getTree();
        this.myTreeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 32) {
                    int selectedColumn = AddMultipleFilesOptionsDialog.this.myTreeTable.getSelectedColumn();
                    if (selectedColumn == 0) {
                        return;
                    }
                    int[] selectedRows = AddMultipleFilesOptionsDialog.this.myTreeTable.getSelectedRows();
                    if (selectedRows.length == 0) {
                        return;
                    }
                    boolean included = !((AddedFileInfo)AddMultipleFilesOptionsDialog.this.myTreeTable.getValueAt(selectedRows[0], 1)).included();
                    for (int selectedRow : selectedRows) {
                        AddedFileInfo addedFileInfo = (AddedFileInfo)AddMultipleFilesOptionsDialog.this.myTreeTable.getValueAt(selectedRow, 1);
                        addedFileInfo.setIncluded(included);
                        AddMultipleFilesOptionsDialog.this.myModel.nodeChanged((TreeNode)addedFileInfo);
                    }
                }
            }
        });
        tree.setCellRenderer((TreeCellRenderer)new AddedFileCellRenderer());
        TreeUtil.installActions((JTree)tree);
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JComponent toolbar = this.createToolbar();
        result.add((Component)toolbar, "North");
        result.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTreeTable), "Center");
        return result;
    }

    private JComponent createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SelectAllAction());
        group.add((AnAction)new UnselectAllAction());
        return actionManager.createActionToolbar("AddFilesToolbar", (ActionGroup)group, true).getComponent();
    }

    private class UnselectAllAction
    extends SelectUnselectAllAction {
        public UnselectAllAction() {
            super(CvsBundle.message((String)"action.name.unselect.all", (Object[])new Object[0]), AllIcons.Actions.Unselectall);
        }

        @Override
        protected boolean includedValue() {
            return false;
        }
    }

    private class SelectAllAction
    extends SelectUnselectAllAction {
        public SelectAllAction() {
            super(CvsBundle.message((String)"action.name.select.all", (Object[])new Object[0]), AllIcons.Actions.Selectall);
        }

        @Override
        protected boolean includedValue() {
            return true;
        }
    }

    private abstract class SelectUnselectAllAction
    extends AnAction {
        protected SelectUnselectAllAction(String text, Icon icon) {
            super(text, null, icon);
        }

        public void actionPerformed(AnActionEvent e) {
            for (AddedFileInfo addedFileInfo : this.getAllFileInfos()) {
                addedFileInfo.setIncluded(this.includedValue());
            }
            AddMultipleFilesOptionsDialog.this.myTreeTable.repaint();
        }

        private Collection<AddedFileInfo> getAllFileInfos() {
            ArrayList<AddedFileInfo> result = new ArrayList<AddedFileInfo>();
            for (AddedFileInfo myRoot : AddMultipleFilesOptionsDialog.this.myRoots) {
                this.addChildrenTo(result, myRoot);
            }
            return result;
        }

        private void addChildrenTo(ArrayList<AddedFileInfo> result, AddedFileInfo addedFileInfo) {
            result.add(addedFileInfo);
            for (int i = 0; i < addedFileInfo.getChildCount(); ++i) {
                this.addChildrenTo(result, (AddedFileInfo)addedFileInfo.getChildAt(i));
            }
        }

        protected abstract boolean includedValue();
    }
}

