#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: darcs
version: 2.13.0
id: darcs-2.13.0-89cGZE3wVSBLuTb7xN7pxu
key: darcs-2.13.0-89cGZE3wVSBLuTb7xN7pxu
license: GPL
maintainer: <darcs-devel@darcs.net>
stability: Experimental
homepage: http://darcs.net/
synopsis: a distributed, interactive, smart revision control system
description:
    Darcs is a free, open source revision control
    system. It is:
    .
    * Distributed: Every user has access to the full
    command set, removing boundaries between server and
    client or committer and non-committers.
    .
    * Interactive: Darcs is easy to learn and efficient to
    use because it asks you questions in response to
    simple commands, giving you choices in your work
    flow. You can choose to record one change in a file,
    while ignoring another. As you update from upstream,
    you can review each patch name, even the full "diff"
    for interesting patches.
    .
    * Smart: Originally developed by physicist David
    Roundy, darcs is based on a unique algebra of
    patches.
    .
    This smartness lets you respond to changing demands
    in ways that would otherwise not be possible. Learn
    more about spontaneous branches with darcs.
category: Development
author: David Roundy <droundy@darcs.net>, <darcs-devel@darcs.net>
exposed: True
indefinite: False
exposed-modules:
    Darcs.Patch Darcs.Patch.Annotate Darcs.Patch.Apply
    Darcs.Patch.ApplyMonad Darcs.Patch.ApplyPatches
    Darcs.Patch.Bracketed Darcs.Patch.Bracketed.Instances
    Darcs.Patch.Bundle Darcs.Patch.Choices Darcs.Patch.Commute
    Darcs.Patch.CommuteFn Darcs.Patch.Conflict Darcs.Patch.Debug
    Darcs.Patch.Depends Darcs.Patch.Dummy Darcs.Patch.Effect
    Darcs.Patch.FileHunk Darcs.Patch.Format Darcs.Patch.Index.Monad
    Darcs.Patch.Index.Types Darcs.Patch.Info Darcs.Patch.Inspect
    Darcs.Patch.Invert Darcs.Patch.Match Darcs.Patch.Matchable
    Darcs.Patch.Merge Darcs.Patch.MonadProgress Darcs.Patch.Named
    Darcs.Patch.Named.Wrapped Darcs.Patch.OldDate
    Darcs.Patch.PatchInfoAnd Darcs.Patch.Patchy
    Darcs.Patch.Patchy.Instances Darcs.Patch.Permutations
    Darcs.Patch.Prim Darcs.Patch.Prim.Class Darcs.Patch.Prim.FileUUID
    Darcs.Patch.Prim.FileUUID.Apply Darcs.Patch.Prim.FileUUID.Coalesce
    Darcs.Patch.Prim.FileUUID.Commute Darcs.Patch.Prim.FileUUID.Core
    Darcs.Patch.Prim.FileUUID.Details
    Darcs.Patch.Prim.FileUUID.ObjectMap Darcs.Patch.Prim.FileUUID.Read
    Darcs.Patch.Prim.FileUUID.Show Darcs.Patch.Prim.V1
    Darcs.Patch.Prim.V1.Apply Darcs.Patch.Prim.V1.Coalesce
    Darcs.Patch.Prim.V1.Commute Darcs.Patch.Prim.V1.Core
    Darcs.Patch.Prim.V1.Details Darcs.Patch.Prim.V1.Read
    Darcs.Patch.Prim.V1.Show Darcs.Patch.Progress Darcs.Patch.Read
    Darcs.Patch.ReadMonads Darcs.Patch.Rebase
    Darcs.Patch.Rebase.Container Darcs.Patch.Rebase.Fixup
    Darcs.Patch.Rebase.Item Darcs.Patch.Rebase.Name
    Darcs.Patch.Rebase.Viewing Darcs.Patch.RegChars Darcs.Patch.Repair
    Darcs.Patch.RepoPatch Darcs.Patch.RepoType Darcs.Patch.Set
    Darcs.Patch.Show Darcs.Patch.Split Darcs.Patch.Summary
    Darcs.Patch.SummaryData Darcs.Patch.TokenReplace
    Darcs.Patch.TouchesFiles Darcs.Patch.Type Darcs.Patch.V1
    Darcs.Patch.V1.Apply Darcs.Patch.V1.Commute Darcs.Patch.V1.Core
    Darcs.Patch.V1.Read Darcs.Patch.V1.Show Darcs.Patch.V1.Viewing
    Darcs.Patch.V2 Darcs.Patch.V2.Non Darcs.Patch.V2.RepoPatch
    Darcs.Patch.Viewing Darcs.Patch.Witnesses.Eq
    Darcs.Patch.Witnesses.Ordered Darcs.Patch.Witnesses.Sealed
    Darcs.Patch.Witnesses.Show Darcs.Patch.Witnesses.Unsafe
    Darcs.Patch.Witnesses.WZipper Darcs.Prelude Darcs.Repository
    Darcs.Repository.ApplyPatches Darcs.Repository.Cache
    Darcs.Repository.Clone Darcs.Repository.Diff Darcs.Repository.Flags
    Darcs.Repository.Format Darcs.Repository.Hashed
    Darcs.Repository.HashedIO Darcs.Repository.Identify
    Darcs.Repository.InternalTypes Darcs.Repository.Job
    Darcs.Repository.Match Darcs.Repository.Merge Darcs.Repository.Old
    Darcs.Repository.Packs Darcs.Repository.PatchIndex
    Darcs.Repository.Pending Darcs.Repository.Prefs
    Darcs.Repository.Rebase Darcs.Repository.Repair
    Darcs.Repository.Resolution Darcs.Repository.State
    Darcs.Repository.Test Darcs.Repository.Working
    Darcs.UI.ApplyPatches Darcs.UI.Commands Darcs.UI.Commands.Add
    Darcs.UI.Commands.Amend Darcs.UI.Commands.Annotate
    Darcs.UI.Commands.Apply Darcs.UI.Commands.Clone
    Darcs.UI.Commands.Convert Darcs.UI.Commands.Diff
    Darcs.UI.Commands.Dist Darcs.UI.Commands.GZCRCs
    Darcs.UI.Commands.Help Darcs.UI.Commands.Init Darcs.UI.Commands.Log
    Darcs.UI.Commands.MarkConflicts Darcs.UI.Commands.Move
    Darcs.UI.Commands.Optimize Darcs.UI.Commands.Pull
    Darcs.UI.Commands.Push Darcs.UI.Commands.Rebase
    Darcs.UI.Commands.Record Darcs.UI.Commands.Remove
    Darcs.UI.Commands.Repair Darcs.UI.Commands.Replace
    Darcs.UI.Commands.Revert Darcs.UI.Commands.Rollback
    Darcs.UI.Commands.Send Darcs.UI.Commands.SetPref
    Darcs.UI.Commands.Show Darcs.UI.Commands.ShowAuthors
    Darcs.UI.Commands.ShowContents Darcs.UI.Commands.ShowDependencies
    Darcs.UI.Commands.ShowFiles Darcs.UI.Commands.ShowIndex
    Darcs.UI.Commands.ShowPatchIndex Darcs.UI.Commands.ShowRepo
    Darcs.UI.Commands.ShowTags Darcs.UI.Commands.Tag
    Darcs.UI.Commands.Test Darcs.UI.Commands.TransferMode
    Darcs.UI.Commands.Unrecord Darcs.UI.Commands.Unrevert
    Darcs.UI.Commands.Util Darcs.UI.Commands.Util.Tree
    Darcs.UI.Commands.WhatsNew Darcs.UI.CommandsAux Darcs.UI.Completion
    Darcs.UI.Defaults Darcs.UI.Email Darcs.UI.External Darcs.UI.Flags
    Darcs.UI.Message.Send Darcs.UI.Options Darcs.UI.Options.All
    Darcs.UI.Options.Core Darcs.UI.Options.Flags Darcs.UI.Options.Iso
    Darcs.UI.Options.Markdown Darcs.UI.Options.Matching
    Darcs.UI.Options.Util Darcs.UI.PatchHeader Darcs.UI.PrintPatch
    Darcs.UI.RunCommand Darcs.UI.SelectChanges Darcs.UI.TheCommands
    Darcs.UI.Usage Darcs.Util.AtExit Darcs.Util.Bug
    Darcs.Util.ByteString Darcs.Util.CommandLine Darcs.Util.Compat
    Darcs.Util.Crypt.SHA1 Darcs.Util.Crypt.SHA256
    Darcs.Util.DateMatcher Darcs.Util.DateTime Darcs.Util.Diff
    Darcs.Util.Diff.Myers Darcs.Util.Diff.Patience Darcs.Util.Download
    Darcs.Util.Download.HTTP Darcs.Util.Download.Request
    Darcs.Util.English Darcs.Util.Exception Darcs.Util.Exec
    Darcs.Util.External Darcs.Util.File Darcs.Util.Global
    Darcs.Util.Hash Darcs.Util.Index Darcs.Util.IsoDate Darcs.Util.Lock
    Darcs.Util.Path Darcs.Util.Printer Darcs.Util.Printer.Color
    Darcs.Util.Progress Darcs.Util.Prompt Darcs.Util.Ratified
    Darcs.Util.Show Darcs.Util.SignalHandler Darcs.Util.Ssh
    Darcs.Util.Text Darcs.Util.Tree Darcs.Util.Tree.Hashed
    Darcs.Util.Tree.Monad Darcs.Util.Tree.Plain Darcs.Util.URL
    Darcs.Util.Workaround
hidden-modules: Version Darcs.Util.Download.Curl
                Darcs.Util.Encoding
abi: 2855fa0a80b035edd991609284da86c8
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/darcs-2.13.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/darcs-2.13.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/darcs-2.13.0
hs-libraries: HSdarcs-2.13.0-89cGZE3wVSBLuTb7xN7pxu
extra-libraries:
    curl
depends:
    base-4.10.0.0 binary-0.8.5.1 containers-0.5.10.2
    regex-compat-tdfa-0.95.1.4-9J2NigrLRPNAUKwB7SzCnJ
    regex-applicative-0.3.3-J7A66V0KzYR10wjnSp8bVc
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 transformers-0.5.2.0
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh
    fgl-5.5.4.0-COv1pCfgmI26gh5vvUifJw
    graphviz-2999.19.0.0-HGkg8iBfLhBIYU4ZsAivKD
    html-1.0.1.2-Gz5RL5eVWKIJ2YfxLl6v89 filepath-1.4.1.2
    haskeline-0.7.4.0 cryptohash-0.11.9-2TT1SZ7nQoL4el6si6fDRP
    base16-bytestring-0.1.1.6-1RelFaTH3mXDxpXrCeJSko
    utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    tar-0.5.0.3-INtpRXtFzzEKq72z4RSP9M
    data-ordlist-0.4.7.0-FbL4nCzWBaaILSIRV0UBHS
    attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm
    zip-archive-0.3.1.1-CZhWVZnrHky8oZZ6YlWuu5
    async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc
    sandi-0.4.1-CayCIwGskXPGp0cE4Rlwhu
    unix-compat-0.4.3.1-EzGzmB3Cz3F9KJc1tD42yp bytestring-0.10.8.2
    old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h time-1.8.0.2
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz directory-1.3.0.2
    process-1.6.1.0 array-0.5.2.0 random-1.1-DtLcP2Z2iOOC0RwcSmXjBK
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    mmap-0.5.9-EWtfmxbT8jF8qY63lOubUM
    zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB
    network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
    HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV unix-2.7.2.2
    knob-0.1.1-BMqK3hSPOz9mejkvDRIPI terminfo-0.4.1.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             regex-compat-tdfa-0.95.1.4-9J2NigrLRPNAUKwB7SzCnJ=2dda50d75bf730a7cd4b195665cd706f
             regex-applicative-0.3.3-J7A66V0KzYR10wjnSp8bVc=0e2d88138bd55ac2d976f1831af13753
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             fgl-5.5.4.0-COv1pCfgmI26gh5vvUifJw=23b6dd598c8ce946a9fc29265323a307
             graphviz-2999.19.0.0-HGkg8iBfLhBIYU4ZsAivKD=bd595c3ffeaa6ad3546ec42eff93b67a
             html-1.0.1.2-Gz5RL5eVWKIJ2YfxLl6v89=42287eed8df22f4c4bed03249b0608ef
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             haskeline-0.7.4.0=36adec7915bbe665923e4f83d1084101
             cryptohash-0.11.9-2TT1SZ7nQoL4el6si6fDRP=b47898f8e455fde8b6f5ed2f9bdd68b0
             base16-bytestring-0.1.1.6-1RelFaTH3mXDxpXrCeJSko=e16826576c05906da343512ae9616ea8
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             tar-0.5.0.3-INtpRXtFzzEKq72z4RSP9M=537fd462573572155fedd756721a4cd6
             data-ordlist-0.4.7.0-FbL4nCzWBaaILSIRV0UBHS=9ba6857fb7b65a96829753ee152218bb
             attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm=08dd59974100c688bef2cfbf42e32e82
             zip-archive-0.3.1.1-CZhWVZnrHky8oZZ6YlWuu5=587ffcd0be19d71fe664743fc57fbf10
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             sandi-0.4.1-CayCIwGskXPGp0cE4Rlwhu=2efcdc2fedaa54dbec5cbc999117ed4d
             unix-compat-0.4.3.1-EzGzmB3Cz3F9KJc1tD42yp=f0e3615d16ccc9a099618a4b1bfc9d59
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h=e36378d40a60df0fd2f08fb5571aec27
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             mmap-0.5.9-EWtfmxbT8jF8qY63lOubUM=e1392be4e432a9ae27d654f9ab9ed0df
             zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB=f9a6b8e404d4e5df9363e7202bb41dfe
             network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK=83774d660ce535b1c7a882f242c5fec6
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
             HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV=ad16a0554ab273a5de2536f4ea3143c2
             unix-2.7.2.2=7af8630098b53e228272ffaea5bacf62
             knob-0.1.1-BMqK3hSPOz9mejkvDRIPI=142fd384589484f49c3d144d22fdcc32
             terminfo-0.4.1.0=8644ddbf3a910c8572272110dcb45e84
haddock-interfaces: /usr/share/doc/darcs/html/darcs.haddock
haddock-html: /usr/share/doc/darcs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

