/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public abstract class GradientCalculator {
    public static void calculateGradient(Track track, int n, SpeedValue speedValue) {
        speedValue.setInvalid();
        if (track == null || n < 0 || speedValue == null) {
            System.err.println("Cannot calculate gradient for index " + n);
            return;
        }
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null || !dataPoint.hasAltitude() || dataPoint.isWaypoint()) {
            return;
        }
        if (dataPoint.hasHSpeed() && dataPoint.hasVSpeed()) {
            speedValue.setValue(dataPoint.getVSpeed().getValueInMetresPerSec() / dataPoint.getHSpeed().getValueInMetresPerSec());
        } else if (!dataPoint.getSegmentStart()) {
            DataPoint dataPoint2 = track.getPreviousTrackPoint(n - 1);
            DataPoint dataPoint3 = track.getNextTrackPoint(n + 1);
            if (dataPoint2 != null && dataPoint3 != null && !dataPoint3.getSegmentStart() && dataPoint2.hasAltitude() && dataPoint3.hasAltitude()) {
                double d = DataPoint.calculateRadiansBetween(dataPoint2, dataPoint) + DataPoint.calculateRadiansBetween(dataPoint, dataPoint3);
                double d2 = Distance.convertRadiansToDistance(d, UnitSetLibrary.UNITS_METRES);
                double d3 = dataPoint3.getAltitude().getMetricValue() - dataPoint2.getAltitude().getMetricValue();
                double d4 = Math.atan2(d3, d2);
                speedValue.setValue(d4);
            }
        }
    }
}

