#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: fclabels
version: 2.0.3.2
id: fclabels-2.0.3.2-C4TftBJxLKb5LMOYkGTlWW
key: fclabels-2.0.3.2-C4TftBJxLKb5LMOYkGTlWW
license: BSD3
maintainer: Sebastiaan Visser <code@fvisser.nl>
homepage: https://github.com/sebastiaanvisser/fclabels
synopsis: First class accessor labels implemented as lenses.
description:
    This package provides first class labels that can act as
    bidirectional record fields. The labels can be derived
    automatically using Template Haskell which means you don'\''t have
    to write any boilerplate yourself. The labels are implemented as
    /lenses/ and are fully composable. Lenses can be used to /get/,
    /set/ and /modify/ parts of a data type in a consistent way.
    .
    See "Data.Label" for an introductory explanation or see the
    introductory blog post at
    <http://fvisser.nl/post/2013/okt/1/fclabels-2.0.html>
    .
    * /Total and partial lenses/
    .
    Internally lenses do not used Haskell functions directly, but
    are implemented as categories. Categories allow the lenses to be
    run in custom computational contexts. This approach allows us to
    make partial lenses that point to fields of multi-constructor
    datatypes in an elegant way.
    .
    See "Data.Label.Partial" for the use of partial labels.
    .
    * /Monomorphic and polymorphic lenses/
    .
    We have both polymorphic and monomorphic lenses. Polymorphic
    lenses allow updates that change the type. The types of
    polymorphic lenses are slightly more verbose than their
    monomorphic counterparts, but their usage is similar. Because
    monomorphic lenses are built by restricting the types of
    polymorphic lenses they are essentially the same and can be
    freely composed with eachother.
    .
    See "Data.Label.Mono" and "Data.Label.Poly" for the difference
    between polymorphic and monomorphic lenses.
    .
    * /Using fclabels/
    .
    To simplify working with labels we supply both a set of labels
    for Haskell'\''s base types, like lists, tuples, Maybe and Either,
    and we supply a set of combinators for working with labels for
    values in the Reader and State monad.
    .
    See "Data.Label.Base" and "Data.Label.Monadic" for more
    information.
    .
    * /Changelog from 2.0.3.1 to 2.0.3.2/
    .
    >   - Allow HUnit 1.5.*.
category: Data, Lenses
author: Sebastiaan Visser, Erik Hesselink, Chris Eidhof, Sjoerd Visscher
        with lots of help and feedback from others.
exposed: True
indefinite: False
exposed-modules:
    Data.Label Data.Label.Base Data.Label.Derive Data.Label.Failing
    Data.Label.Monadic Data.Label.Mono Data.Label.Partial
    Data.Label.Point Data.Label.Poly Data.Label.Total
abi: f40bd65035a3e8b2e3f0c83c9b118d1c
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/fclabels-2.0.3.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/fclabels-2.0.3.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/fclabels-2.0.3.2
hs-libraries: HSfclabels-2.0.3.2-C4TftBJxLKb5LMOYkGTlWW
depends:
    base-4.10.0.0 template-haskell-2.12.0.0
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 transformers-0.5.2.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
haddock-interfaces: /usr/share/doc/haskell-fclabels/html/fclabels.haddock
haddock-html: /usr/share/doc/haskell-fclabels/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

