#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.5.2
id: scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q
key: scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific
hidden-modules: GHC.Integer.Compat Utils
abi: 1fbe9fca72112f81835ace86a6280857
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/scientific-0.3.5.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/scientific-0.3.5.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/scientific-0.3.5.2
hs-libraries: HSscientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q
depends:
    base-4.10.0.0 integer-logarithms-1.0.2-VAUswqHa2j8Wo9H471XH1
    deepseq-1.4.3.0 text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg containers-0.5.10.2
    binary-0.8.5.1 bytestring-0.10.8.2 integer-gmp-1.0.1.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             integer-logarithms-1.0.2-VAUswqHa2j8Wo9H471XH1=37941b25f975f17ec0da07c68d35aead
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg=998ed6e6951fb3231f40c732faa08c23
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             integer-gmp-1.0.1.0=e6cff563e9a6fa97a3c39931f11293e0
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

