#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.2.2
id: tamarin-prover-theory-1.2.2-dWRHA059Rn7becwJZRF49
key: tamarin-prover-theory-1.2.2-dWRHA059Rn7becwJZRF49
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
indefinite: False
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.Solver.Types Theory.Constraint.System
    Theory.Constraint.System.Constraints Theory.Constraint.System.Dot
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Rule Theory.Model.Signature
    Theory.Proof Theory.Text.Parser Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness
abi: 5f99625afcbcc37216f4dd87cff7a7fe
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tamarin-prover-theory-1.2.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/tamarin-prover-theory-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tamarin-prover-theory-1.2.2
hs-libraries: HStamarin-prover-theory-1.2.2-dWRHA059Rn7becwJZRF49
depends:
    aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq
    aeson-pretty-0.8.5-9BxbFsM21RbE8Yp2sqULuj base-4.10.0.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q
    fclabels-2.0.3.2-C4TftBJxLKb5LMOYkGTlWW
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh process-1.6.1.0
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz transformers-0.5.2.0
    uniplate-1.6.12-7N3IMg4lwN2FPMc94OrKMJ
    tamarin-prover-utils-1.2.2-LVjJJ7aC5vc3QABo3RoZz1
    tamarin-prover-term-1.2.2-E7t9u7QnWmD1bQUA1Lyhy1
abi-depends: aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq=61053bde0c5cda47d1a123db05d36888
             aeson-pretty-0.8.5-9BxbFsM21RbE8Yp2sqULuj=32cd10ac9c8dd84a8b4e2e5c8775464b
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q=97435ce23ff4e4560f559d3afbbee81e
             fclabels-2.0.3.2-C4TftBJxLKb5LMOYkGTlWW=f40bd65035a3e8b2e3f0c83c9b118d1c
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K=d3c5e50fff73217cc80d767e7d27ed7e
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             uniplate-1.6.12-7N3IMg4lwN2FPMc94OrKMJ=aca07ca2d05ef0b3aaff6d1615e5287c
             tamarin-prover-utils-1.2.2-LVjJJ7aC5vc3QABo3RoZz1=e2fb01d51fee8a9252a28a2396837eb8
             tamarin-prover-term-1.2.2-E7t9u7QnWmD1bQUA1Lyhy1=a8f7591145758075cde4c8a07fc4d5ab
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

