/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.P3i;
import javajs.util.SB;
import org.jmol.symmetry.HallRotationTerm;
import org.jmol.symmetry.HallTranslation;
import org.jmol.util.Logger;

class HallInfo {
    String hallSymbol;
    String primitiveHallSymbol;
    char latticeCode = '\u0000';
    String latticeExtension;
    boolean isCentrosymmetric;
    int nRotations;
    HallRotationTerm[] rotationTerms = new HallRotationTerm[16];
    P3i vector12ths;
    String vectorCode;

    HallInfo(String hallSymbol) {
        try {
            String str = this.hallSymbol = hallSymbol.trim();
            str = this.extractLatticeInfo(str);
            if (HallTranslation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = HallTranslation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            str = this.extractVectorInfo(str) + this.latticeExtension;
            if (Logger.debugging) {
                Logger.debug((String)("Hallinfo: " + hallSymbol + " " + str));
            }
            int prevOrder = 0;
            char prevAxisType = '\u0000';
            this.primitiveHallSymbol = "P";
            while (str.length() > 0 && this.nRotations < 16) {
                str = this.extractRotationInfo(str, prevOrder, prevAxisType);
                HallRotationTerm r = this.rotationTerms[this.nRotations - 1];
                prevOrder = r.order;
                prevAxisType = r.axisType;
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + r.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception e) {
            Logger.error((String)("Invalid Hall symbol " + e));
            this.nRotations = 0;
        }
    }

    String dumpInfo() {
        SB sb = new SB();
        sb.append("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            sb.append("\n\nrotation term ").appendI(i + 1).append(this.rotationTerms[i].dumpInfo(this.vectorCode));
        }
        return sb.toString();
    }

    private String getLatticeDesignation() {
        return HallTranslation.getLatticeDesignation2(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String name) {
        int i = name.indexOf(" ");
        if (i < 0) {
            return "";
        }
        String term = name.substring(0, i).toUpperCase();
        this.latticeCode = term.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = term.charAt(1);
        }
        return name.substring(i + 1).trim();
    }

    private String extractVectorInfo(String name) {
        this.vector12ths = new P3i();
        this.vectorCode = "";
        int i = name.indexOf("(");
        int j = name.indexOf(")", i);
        if (i > 0 && j > i) {
            String term = name.substring(i + 1, j);
            this.vectorCode = " (" + term + ")";
            name = name.substring(0, i).trim();
            i = term.indexOf(" ");
            if (i >= 0) {
                this.vector12ths.x = Integer.parseInt(term.substring(0, i));
                if ((i = (term = term.substring(i + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(term.substring(0, i));
                    term = term.substring(i + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(term);
        }
        return name;
    }

    private String extractRotationInfo(String name, int prevOrder, char prevAxisType) {
        String code;
        int i = name.indexOf(" ");
        if (i >= 0) {
            code = name.substring(0, i);
            name = name.substring(i + 1).trim();
        } else {
            code = name;
            name = "";
        }
        this.rotationTerms[this.nRotations] = new HallRotationTerm(this, code, prevOrder, prevAxisType);
        ++this.nRotations;
        return name;
    }
}

