/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectMembersAction
extends AbstractRelationAction {
    private final boolean add;

    public SelectMembersAction(boolean add) {
        this.putValue("ShortDescription", add ? I18n.tr("Add the members of all selected relations to current selection", new Object[0]) : I18n.tr("Select the members of all selected relations", new Object[0]));
        new ImageProvider("selectall").getResource().attachImageIcon(this, true);
        this.putValue("Name", add ? I18n.tr("Select members (add)", new Object[0]) : I18n.tr("Select members", new Object[0]));
        this.add = add;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        HashSet<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        for (Relation r : this.relations) {
            members.addAll(r.getMemberPrimitivesList());
        }
        if (this.add) {
            MainApplication.getLayerManager().getEditLayer().data.addSelected(members);
        } else {
            MainApplication.getLayerManager().getEditLayer().data.setSelected(members);
        }
    }
}

