/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadTask;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class UploadPrimitivesTask
extends AbstractUploadTask {
    private boolean uploadCanceled;
    private Exception lastException;
    private final APIDataSet toUpload;
    private OsmServerWriter writer;
    private final OsmDataLayer layer;
    private Changeset changeset;
    private final Set<IPrimitive> processedPrimitives;
    private final UploadStrategySpecification strategy;

    public UploadPrimitivesTask(UploadStrategySpecification strategy, OsmDataLayer layer, APIDataSet toUpload, Changeset changeset) {
        super(I18n.tr("Uploading data for layer ''{0}''", layer.getName()), false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(strategy, "strategy");
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.toUpload = toUpload;
        this.layer = layer;
        this.changeset = changeset;
        this.strategy = strategy;
        this.processedPrimitives = new HashSet<IPrimitive>();
    }

    protected MaxChangesetSizeExceededPolicy askMaxChangesetSizeExceedsPolicy() {
        HelpAwareOptionPane.ButtonSpec[] specs = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue uploading", new Object[0]), ImageProvider.get("upload"), I18n.tr("Click to continue uploading to additional new changesets", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Go back to Upload Dialog", new Object[0]), ImageProvider.get("dialogs", "uploadproperties"), I18n.tr("Click to return to the Upload Dialog", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort uploading", new Object[0]), null)};
        int numObjectsToUploadLeft = this.toUpload.getSize() - this.processedPrimitives.size();
        String msg1 = I18n.tr("The server reported that the current changeset was closed.<br>This is most likely because the changesets size exceeded the max. size<br>of {0} objects on the server ''{1}''.", OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize(), OsmApi.getOsmApi().getBaseUrl());
        String msg2 = I18n.trn("There is {0} object left to upload.", "There are {0} objects left to upload.", numObjectsToUploadLeft, numObjectsToUploadLeft);
        String msg3 = I18n.tr("Click ''<strong>{0}</strong>'' to continue uploading to additional new changesets.<br>Click ''<strong>{1}</strong>'' to return to the upload dialog.<br>Click ''<strong>{2}</strong>'' to abort uploading and return to map editing.<br>", specs[0].text, specs[1].text, specs[2].text);
        String msg = "<html>" + msg1 + "<br><br>" + msg2 + "<br><br>" + msg3 + "</html>";
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Changeset is full", new Object[0]), 2, null, specs, specs[0], HelpUtil.ht("/Action/Upload#ChangesetFull"));
        switch (ret) {
            case 0: {
                return MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS;
            }
            case 1: {
                return MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG;
            }
        }
        return MaxChangesetSizeExceededPolicy.ABORT;
    }

    protected void openNewChangeset() {
        ChangesetCache.getInstance().update(this.changeset);
        Changeset newChangeSet = new Changeset();
        newChangeSet.setKeys(this.changeset.getKeys());
        this.changeset = newChangeSet;
    }

    protected boolean recoverFromChangesetFullException() throws OsmTransferException {
        if (this.toUpload.getSize() - this.processedPrimitives.size() == 0) {
            this.strategy.setPolicy(MaxChangesetSizeExceededPolicy.ABORT);
            return false;
        }
        if (this.strategy.getPolicy() == null || this.strategy.getPolicy().equals((Object)MaxChangesetSizeExceededPolicy.ABORT)) {
            this.strategy.setPolicy(this.askMaxChangesetSizeExceedsPolicy());
        }
        switch (this.strategy.getPolicy()) {
            case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                this.closeChangesetIfRequired();
                this.openNewChangeset();
                this.toUpload.removeProcessed(this.processedPrimitives);
                return true;
            }
        }
        return false;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException e, ProgressMonitor monitor) throws OsmTransferException {
        if (!e.isKnownPrimitive()) {
            throw e;
        }
        OsmPrimitive p = this.layer.data.getPrimitiveById(e.getPrimitiveId(), e.getPrimitiveType());
        if (p == null) {
            throw e;
        }
        if (p.isDeleted()) {
            String displayName = p.getDisplayName(DefaultNameFormatter.getInstance());
            String msg = p instanceof Node ? I18n.tr("Node ''{0}'' is already deleted. Skipping object in upload.", displayName) : (p instanceof Way ? I18n.tr("Way ''{0}'' is already deleted. Skipping object in upload.", displayName) : (p instanceof Relation ? I18n.tr("Relation ''{0}'' is already deleted. Skipping object in upload.", displayName) : I18n.tr("Object ''{0}'' is already deleted. Skipping object in upload.", displayName)));
            monitor.appendLogMessage(msg);
            Logging.warn(msg);
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(p);
            this.toUpload.removeProcessed(this.processedPrimitives);
            return;
        }
        throw e;
    }

    protected void cleanupAfterUpload() {
        Runnable r = () -> {
            this.layer.cleanupAfterUpload(this.processedPrimitives);
            this.layer.onPostUploadToServer();
            ChangesetCache.getInstance().update(this.changeset);
        };
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException e) {
            Logging.trace(e);
            this.lastException = e;
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            Logging.trace(e);
            this.lastException = new OsmTransferException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() {
        try {
            MessageNotifier.stop();
            block40: while (true) {
                try {
                    this.getProgressMonitor().subTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", this.toUpload.getSize(), this.toUpload.getSize()));
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = new OsmServerWriter();
                    }
                    this.writer.uploadOsm(this.strategy, this.toUpload.getPrimitives(), this.changeset, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
                catch (OsmTransferCanceledException e) {
                    Logging.error(e);
                    this.uploadCanceled = true;
                }
                catch (OsmApiPrimitiveGoneException e) {
                    this.recoverFromGoneOnServer(e, this.getProgressMonitor());
                    continue;
                }
                catch (ChangesetClosedException e) {
                    if (this.writer != null) {
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    switch (e.getSource()) {
                        case UPLOAD_DATA: {
                            if (this.recoverFromChangesetFullException()) continue block40;
                            this.lastException = e;
                            break block40;
                        }
                        default: {
                            this.changeset.setOpen(false);
                            throw e;
                        }
                    }
                }
                finally {
                    if (this.writer != null) {
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = null;
                    }
                    continue;
                }
                break;
            }
            this.closeChangesetIfRequired();
        }
        catch (OsmTransferException e) {
            if (this.uploadCanceled) {
                Logging.info(I18n.tr("Ignoring caught exception because upload is canceled. Exception is: {0}", e.toString()));
            } else {
                this.lastException = e;
            }
        }
        finally {
            if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
                MessageNotifier.start();
            }
        }
        if (this.uploadCanceled && this.processedPrimitives.isEmpty()) {
            return;
        }
        this.cleanupAfterUpload();
    }

    private void closeChangesetIfRequired() throws OsmTransferException {
        if (this.strategy.isCloseChangesetAfterUpload() && this.changeset != null && !this.changeset.isNew() && this.changeset.isOpen()) {
            OsmApi.getOsmApi().closeChangeset(this.changeset, this.progressMonitor.createSubTaskMonitor(0, false));
        }
    }

    @Override
    protected void finish() {
        GuiHelper.runInEDT(() -> {
            ChangesetCache.getInstance().update(this.changeset);
            if (this.changeset != null && this.changeset.isOpen()) {
                UploadDialog.getUploadDialog().setSelectedChangesetForNextUpload(this.changeset);
            }
            if (this.uploadCanceled) {
                return;
            }
            if (this.lastException == null) {
                new Notification("<h3>" + I18n.tr("Upload successful!", new Object[0]) + "</h3>").setIcon(ImageProvider.get("misc", "check_large")).show();
                return;
            }
            if (this.lastException instanceof ChangesetClosedException) {
                ChangesetClosedException e = (ChangesetClosedException)this.lastException;
                if (e.getSource().equals((Object)ChangesetClosedException.Source.UPDATE_CHANGESET)) {
                    this.handleFailedUpload(this.lastException);
                    return;
                }
                if (this.strategy.getPolicy() == null) {
                    return;
                }
                if (e.getSource().equals((Object)ChangesetClosedException.Source.UPLOAD_DATA)) {
                    switch (this.strategy.getPolicy()) {
                        case ABORT: {
                            break;
                        }
                        case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                            break;
                        }
                        case FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG: {
                            this.toUpload.removeProcessed(this.processedPrimitives);
                            UploadDialog.getUploadDialog().setUploadedPrimitives(this.toUpload);
                            UploadDialog.getUploadDialog().setVisible(true);
                        }
                    }
                } else {
                    this.handleFailedUpload(this.lastException);
                }
            } else {
                this.handleFailedUpload(this.lastException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.uploadCanceled = true;
        UploadPrimitivesTask uploadPrimitivesTask = this;
        synchronized (uploadPrimitivesTask) {
            if (this.writer != null) {
                this.writer.cancel();
            }
        }
    }
}

