/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalExpressionKey {
    public static final int UNKNOWN_PARAM_COUNT = -1;
    private final int lambdaParameterCount;
    private final CoarseType lambdaReturnType;
    @NotNull
    private final String knownType;

    public FunctionalExpressionKey(int lambdaParameterCount, @NotNull CoarseType lambdaReturnType, @Nullable String knownFunExprType) {
        if (lambdaReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaReturnType", "com/intellij/psi/impl/java/stubs/FunctionalExpressionKey", "<init>"));
        }
        this.lambdaParameterCount = lambdaParameterCount;
        this.lambdaReturnType = lambdaReturnType;
        this.knownType = StringUtil.notNullize(knownFunExprType);
    }

    @NotNull
    public static FunctionalExpressionKey deserializeKey(@NotNull DataInput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/FunctionalExpressionKey", "deserializeKey"));
        }
        byte parameterCount = dataStream.readByte();
        CoarseType type2 = CoarseType.values()[dataStream.readByte()];
        String knownType = IOUtil.readUTF(dataStream);
        FunctionalExpressionKey functionalExpressionKey = new FunctionalExpressionKey(parameterCount, type2, knownType);
        if (functionalExpressionKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/FunctionalExpressionKey", "deserializeKey"));
        }
        return functionalExpressionKey;
    }

    public void serializeKey(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/FunctionalExpressionKey", "serializeKey"));
        }
        dataStream.writeByte(this.lambdaParameterCount);
        dataStream.writeByte(this.lambdaReturnType.ordinal());
        IOUtil.writeUTF(dataStream, this.knownType);
    }

    public boolean canRepresent(int samParamCount, boolean booleanCompatible, boolean isVoid) {
        if (this.lambdaParameterCount >= 0 && samParamCount != this.lambdaParameterCount) {
            return false;
        }
        switch (this.lambdaReturnType) {
            case VOID: {
                return isVoid;
            }
            case NON_VOID: {
                return !isVoid;
            }
            case BOOLEAN: {
                return booleanCompatible;
            }
        }
        return true;
    }

    public static boolean isBooleanCompatible(PsiType samType) {
        return PsiType.BOOLEAN.equals(samType) || TypeConversionUtil.isAssignableFromPrimitiveWrapper(TypeConversionUtil.erasure(samType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionalExpressionKey)) {
            return false;
        }
        FunctionalExpressionKey key = (FunctionalExpressionKey)o;
        if (this.lambdaParameterCount != key.lambdaParameterCount) {
            return false;
        }
        if (this.lambdaReturnType != key.lambdaReturnType) {
            return false;
        }
        return this.knownType.equals(key.knownType);
    }

    public int hashCode() {
        int result2 = this.lambdaParameterCount;
        result2 = 31 * result2 + this.lambdaReturnType.ordinal();
        result2 = 31 * result2 + this.knownType.hashCode();
        return result2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lambdaParameterCount", this.lambdaParameterCount).add("type", (Object)this.lambdaReturnType).add("knownType", this.knownType).toString();
    }

    public static enum CoarseType {
        VOID,
        UNKNOWN,
        BOOLEAN,
        NON_VOID;

    }
}

