// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_Unit_HeaderFile
#define _Units_Unit_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_Unit.hxx>

#include <Handle_TCollection_HAsciiString.hxx>
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#include <Standard_Real.hxx>
#include <Handle_Units_Quantity.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <TCollection_AsciiString.hxx>
#include <Handle_Units_Token.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class TCollection_HAsciiString;
class TColStd_HSequenceOfHAsciiString;
class Units_Quantity;
class Units_Token;


//! This class defines an elementary word contained in
//! a physical quantity.
class Units_Unit : public MMgt_TShared
{

public:

  
  //! Creates  and returns a  unit.  <aname> is  the name of
  //! the  unit, <asymbol> is the  usual abbreviation of the
  //! unit,  and  <avalue> is the  value in relation to  the
  //! International System of Units.
  Standard_EXPORT Units_Unit(const Standard_CString aname, const Standard_CString asymbol, const Standard_Real avalue, const Handle(Units_Quantity)& aquantity);
  
  //! Creates  and returns a  unit.  <aname> is  the name of
  //! the  unit, <asymbol> is the  usual abbreviation of the
  //! unit.
  Standard_EXPORT Units_Unit(const Standard_CString aname, const Standard_CString asymbol);
  
  //! Creates  and returns a  unit.  <aname> is  the name of
  //! the  unit.
  Standard_EXPORT Units_Unit(const Standard_CString aname);
  
  //! Returns the name of the unit <thename>
      TCollection_AsciiString Name()  const;
  
  //! Adds a new symbol <asymbol> attached to <me>.
  Standard_EXPORT   void Symbol (const Standard_CString asymbol) ;
  
  //! Returns the  value in relation  with the International
  //! System of Units.
      Standard_Real Value()  const;
  
  //! Returns <thequantity> contained in <me>.
      Handle(Units_Quantity) Quantity()  const;
  
  //! Returns the sequence of symbols <thesymbolssequence>
      Handle(TColStd_HSequenceOfHAsciiString) SymbolsSequence()  const;
  
  //! Sets the value <avalue> to <me>.
      void Value (const Standard_Real avalue) ;
  
  //! Sets the physical Quantity <aquantity> to <me>.
      void Quantity (const Handle(Units_Quantity)& aquantity) ;
  
  //! Starting with <me>, returns a new Token object.
  Standard_EXPORT virtual   Handle(Units_Token) Token()  const;
  
  //! Compares all the symbols  linked  within <me> with the
  //! name of <atoken>,  and returns  True  if there is  one
  //! symbol equal to the name, False otherwise.
  Standard_EXPORT   Standard_Boolean IsEqual (const Standard_CString astring)  const;
  
  //! Useful for debugging
  Standard_EXPORT virtual   void Dump (const Standard_Integer ashift, const Standard_Integer alevel)  const;




  DEFINE_STANDARD_RTTI(Units_Unit)

protected:


  Handle(TColStd_HSequenceOfHAsciiString) thesymbolssequence;
  Standard_Real thevalue;


private: 


  Handle(TCollection_HAsciiString) thename;
  Handle(Units_Quantity) thequantity;


};


#include <Units_Unit.lxx>





#endif // _Units_Unit_HeaderFile
