/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.Message;

public final class ConfigurationResolveReport {
    private final ModuleDescriptor md;
    private final String conf;
    private final Date date;
    private final ResolveOptions options;
    private Map dependencyReports = new LinkedHashMap();
    private Map dependencies = new LinkedHashMap();
    private final ResolveEngine resolveEngine;
    private Map modulesIdsMap = new LinkedHashMap();
    private List modulesIds;

    public ConfigurationResolveReport(ResolveEngine resolveEngine, ModuleDescriptor moduleDescriptor, String string, Date date, ResolveOptions resolveOptions) {
        this.resolveEngine = resolveEngine;
        this.md = moduleDescriptor;
        this.conf = string;
        this.date = date;
        this.options = resolveOptions;
    }

    public final void checkIfChanged() {
        String string;
        ResolutionCacheManager resolutionCacheManager = this.resolveEngine.getSettings().getResolutionCacheManager();
        File file2 = resolutionCacheManager.getConfigurationResolveReportInCache(string = this.options.getResolveId(), this.conf);
        if (file2.exists()) {
            try {
                XmlReportParser xmlReportParser = new XmlReportParser();
                xmlReportParser.parse(file2);
                List<ModuleRevisionId> list = Arrays.asList(xmlReportParser.getDependencyRevisionIds());
                Boolean.valueOf(!new HashSet<ModuleRevisionId>(list).equals(this.getModuleRevisionIds()));
                return;
            }
            catch (Exception exception) {
                Message.warn("Error while parsing configuration resolve report " + file2.getAbsolutePath());
                exception.printStackTrace();
                return;
            }
        }
    }

    public final Set getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (ivyNode.isEvicted(this.conf) || ivyNode.hasProblem()) continue;
            linkedHashSet.add(ivyNode.getResolvedId());
        }
        return linkedHashSet;
    }

    public final void addDependency(IvyNode ivyNode) {
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        this.dependencyReports.put(ivyNode, Collections.EMPTY_LIST);
    }

    public final void updateDependency(ModuleRevisionId moduleRevisionId, IvyNode ivyNode) {
        this.dependencies.put(moduleRevisionId, ivyNode);
    }

    public final void addDependency(IvyNode ivyNode, DownloadReport downloadReport) {
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>();
        Artifact[] artifactArray = ivyNode.getArtifacts(this.conf);
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = downloadReport.getArtifactReport(artifactArray[i]);
            if (artifactDownloadReport != null) {
                arrayList.add(artifactDownloadReport);
                continue;
            }
            Message.debug("no report found for " + artifactArray[i]);
        }
        this.dependencyReports.put(ivyNode, arrayList);
    }

    public final String getConfiguration() {
        return this.conf;
    }

    public final Date getDate() {
        return this.date;
    }

    public final ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public final IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.hasProblem()) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    private Collection getDependencies() {
        return new LinkedHashSet(this.dependencies.values());
    }

    public final IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isEvicted(this.conf)) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    public final IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isDownloaded() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    public final IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isSearched() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    public final ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        Collection collection = (Collection)this.dependencyReports.get((IvyNode)this.dependencies.get(moduleRevisionId2));
        if (collection == null) {
            return new ArtifactDownloadReport[0];
        }
        return collection.toArray(new ArtifactDownloadReport[collection.size()]);
    }

    public final List getModuleIds() {
        if (this.modulesIds == null) {
            List list = this.resolveEngine.getSortEngine().sortNodes(this.getDependencies(), SortOptions.SILENT);
            Collections.reverse(list);
            for (IvyNode ivyNode : list) {
                ModuleId moduleId = ivyNode.getResolvedId().getModuleId();
                LinkedHashSet<IvyNode> linkedHashSet = (LinkedHashSet<IvyNode>)this.modulesIdsMap.get(moduleId);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<IvyNode>();
                    this.modulesIdsMap.put(moduleId, linkedHashSet);
                }
                linkedHashSet.add(ivyNode);
            }
            this.modulesIds = new ArrayList(this.modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this.modulesIds);
    }

    public final Collection getNodes(ModuleId moduleId) {
        if (this.modulesIds == null) {
            this.getModuleIds();
        }
        return (Collection)this.modulesIdsMap.get(moduleId);
    }

    public final int getArtifactsNumber() {
        int n = 0;
        for (Collection collection : this.dependencyReports.values()) {
            n += collection == null ? 0 : collection.size();
        }
        return n;
    }

    public final ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean bl) {
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        Iterator iterator2 = this.dependencyReports.values().iterator();
        while (iterator2.hasNext()) {
            for (ArtifactDownloadReport artifactDownloadReport : (Collection)iterator2.next()) {
                if (downloadStatus != null && artifactDownloadReport.getDownloadStatus() != downloadStatus) continue;
                linkedHashSet.add(artifactDownloadReport);
            }
        }
        return linkedHashSet.toArray(new ArtifactDownloadReport[linkedHashSet.size()]);
    }

    public final ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        return this.getArtifactsReports(DownloadStatus.SUCCESSFUL, true);
    }

    public final ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public final boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public final int getNodesNumber() {
        return this.getDependencies().size();
    }

    public static ArtifactDownloadReport[] filterOutMergedArtifacts(ArtifactDownloadReport[] artifactDownloadReportArray) {
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>(Arrays.asList(artifactDownloadReportArray));
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            if (((ArtifactDownloadReport)iterator2.next()).getArtifact().getExtraAttribute("ivy:merged") == null) continue;
            iterator2.remove();
        }
        return arrayList.toArray(new ArtifactDownloadReport[arrayList.size()]);
    }
}

