/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.logicalexpressions;

import ch.ehi.basics.tools.AbstractVisitor;
import ch.ehi.interlis.logicalexpressions.Factor;
import ch.ehi.uml1_4.changepropagation.MetaModel;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.implementation.AbstractEditorElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Term
extends AbstractEditorElement
implements Serializable {
    private Set right = new HashSet();
    private Factor factor;
    private Term left;
    private int kind = 1;

    @Override
    public void unlinkAll() {
        this.clearRight();
        this.detachFactor();
        this.detachLeft();
        super.unlinkAll();
    }

    @Override
    public void enumerateChildren(AbstractVisitor visitor) {
        Iterator it = null;
        it = this.iteratorRight();
        while (it.hasNext()) {
            visitor.visit(it.next());
        }
        if (this.containsFactor()) {
            visitor.visit(this.getFactor());
        }
        if (this.containsLeft()) {
            visitor.visit(this.getLeft());
        }
        super.enumerateChildren(visitor);
    }

    public void addRight(Term right1) {
        this.right.add(right1);
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "addRight"));
    }

    public Term removeRight(Term right1) {
        Term ret = null;
        if (right1 == null || !this.right.contains(right1)) {
            throw new IllegalArgumentException("cannot remove null or unknown object");
        }
        ret = right1;
        this.right.remove(right1);
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "removeRight"));
        return ret;
    }

    public boolean containsRight(Term right1) {
        return this.right.contains(right1);
    }

    public Iterator iteratorRight() {
        return this.right.iterator();
    }

    public void clearRight() {
        if (this.sizeRight() > 0) {
            this.right.clear();
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "clearRight"));
        }
    }

    public int sizeRight() {
        return this.right.size();
    }

    public void attachFactor(Factor factor1) {
        if (this.factor != null) {
            throw new IllegalStateException("already a factor attached");
        }
        if (factor1 == null) {
            throw new IllegalArgumentException("null may not be attached as factor");
        }
        this.factor = factor1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachFactor"));
    }

    public Factor detachFactor() {
        Factor ret = null;
        ret = this.factor;
        this.factor = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachFactor"));
        return ret;
    }

    public Factor getFactor() {
        if (this.factor == null) {
            throw new IllegalStateException("no factor attached");
        }
        return this.factor;
    }

    public boolean containsFactor() {
        return this.factor != null;
    }

    public void attachLeft(Term left1) {
        if (this.left != null) {
            throw new IllegalStateException("already a left attached");
        }
        if (left1 == null) {
            throw new IllegalArgumentException("null may not be attached as left");
        }
        this.left = left1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachLeft"));
    }

    public Term detachLeft() {
        Term ret = null;
        ret = this.left;
        this.left = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachLeft"));
        return ret;
    }

    public Term getLeft() {
        if (this.left == null) {
            throw new IllegalStateException("no left attached");
        }
        return this.left;
    }

    public boolean containsLeft() {
        return this.left != null;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int value1) {
        if (this.kind != value1) {
            this.kind = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setKind"));
        }
    }
}

