/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import sun.reflect.misc.ReflectUtil;
import sun.swing.SwingUtilities2;

public class DefaultFormatter
extends JFormattedTextField.AbstractFormatter
implements Cloneable,
Serializable {
    private boolean allowsInvalid = true;
    private boolean overwriteMode = true;
    private boolean commitOnEdit;
    private Class<?> valueClass;
    private NavigationFilter navigationFilter;
    private DocumentFilter documentFilter;
    transient ReplaceHolder replaceHolder;

    @Override
    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        this.positionCursorAtInitialLocation();
    }

    public void setCommitsOnValidEdit(boolean bl) {
        this.commitOnEdit = bl;
    }

    public boolean getCommitsOnValidEdit() {
        return this.commitOnEdit;
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteMode = bl;
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setAllowsInvalid(boolean bl) {
        this.allowsInvalid = bl;
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setValueClass(Class<?> clazz) {
        this.valueClass = clazz;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Constructor<?> constructor;
        Class<?> clazz = this.getValueClass();
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (clazz == null && jFormattedTextField != null && (constructor = jFormattedTextField.getValue()) != null) {
            clazz = constructor.getClass();
        }
        if (clazz != null) {
            try {
                ReflectUtil.checkPackageAccess(clazz);
                SwingUtilities2.checkAccess(clazz.getModifiers());
                constructor = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = null;
            }
            if (constructor != null) {
                try {
                    SwingUtilities2.checkAccess(constructor.getModifiers());
                    return constructor.newInstance(string);
                }
                catch (Throwable throwable) {
                    throw new ParseException("Error creating instance", 0);
                }
            }
        }
        return string;
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        if (this.documentFilter == null) {
            this.documentFilter = new DefaultDocumentFilter();
        }
        return this.documentFilter;
    }

    @Override
    protected NavigationFilter getNavigationFilter() {
        if (this.navigationFilter == null) {
            this.navigationFilter = new DefaultNavigationFilter();
        }
        return this.navigationFilter;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultFormatter defaultFormatter = (DefaultFormatter)super.clone();
        defaultFormatter.navigationFilter = null;
        defaultFormatter.documentFilter = null;
        defaultFormatter.replaceHolder = null;
        return defaultFormatter;
    }

    void positionCursorAtInitialLocation() {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (jFormattedTextField != null) {
            jFormattedTextField.setCaretPosition(this.getInitialVisualPosition());
        }
    }

    int getInitialVisualPosition() {
        return this.getNextNavigatableChar(0, 1);
    }

    boolean isNavigatable(int n) {
        return true;
    }

    boolean isLegalInsertText(String string) {
        return true;
    }

    private int getNextNavigatableChar(int n, int n2) {
        int n3 = this.getFormattedTextField().getDocument().getLength();
        while (n >= 0 && n < n3) {
            if (this.isNavigatable(n)) {
                return n;
            }
            n += n2;
        }
        return n;
    }

    String getReplaceString(int n, int n2, String string) {
        String string2 = this.getFormattedTextField().getText();
        String string3 = string2.substring(0, n);
        if (string != null) {
            string3 = string3 + string;
        }
        if (n + n2 < string2.length()) {
            string3 = string3 + string2.substring(n + n2);
        }
        return string3;
    }

    boolean isValidEdit(ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            String string = this.getReplaceString(replaceHolder.offset, replaceHolder.length, replaceHolder.text);
            try {
                replaceHolder.value = this.stringToValue(string);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    void commitEdit() throws ParseException {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (jFormattedTextField != null) {
            jFormattedTextField.commitEdit();
        }
    }

    void updateValue() {
        this.updateValue(null);
    }

    void updateValue(Object object) {
        try {
            if (object == null) {
                String string = this.getFormattedTextField().getText();
                object = this.stringToValue(string);
            }
            if (this.getCommitsOnValidEdit()) {
                this.commitEdit();
            }
            this.setEditValid(true);
        }
        catch (ParseException parseException) {
            this.setEditValid(false);
        }
    }

    int getNextCursorPosition(int n, int n2) {
        int n3 = this.getNextNavigatableChar(n, n2);
        int n4 = this.getFormattedTextField().getDocument().getLength();
        if (!this.getAllowsInvalid()) {
            if (n2 == -1 && n == n3) {
                if ((n3 = this.getNextNavigatableChar(n3, 1)) >= n4) {
                    n3 = n;
                }
            } else if (n2 == 1 && n3 >= n4 && (n3 = this.getNextNavigatableChar(n4 - 1, -1)) < n4) {
                ++n3;
            }
        }
        return n3;
    }

    void repositionCursor(int n, int n2) {
        this.getFormattedTextField().getCaret().setDot(this.getNextCursorPosition(n, n2));
    }

    int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
        if (n3 == -1) {
            return -1;
        }
        if (!(this.getAllowsInvalid() || n2 != 3 && n2 != 7)) {
            int n4 = -1;
            while (!this.isNavigatable(n3) && n3 != n4) {
                n4 = n3;
                n3 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n3, bias, n2, biasArray);
            }
            int n5 = this.getFormattedTextField().getDocument().getLength();
            if (n4 == n3 || n3 == n5) {
                if (n3 == 0) {
                    biasArray[0] = Position.Bias.Forward;
                    n3 = this.getInitialVisualPosition();
                }
                if (n3 >= n5 && n5 > 0) {
                    biasArray[0] = Position.Bias.Forward;
                    n3 = this.getNextNavigatableChar(n5 - 1, -1) + 1;
                }
            }
        }
        return n3;
    }

    boolean canReplace(ReplaceHolder replaceHolder) {
        return this.isValidEdit(replaceHolder);
    }

    void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        ReplaceHolder replaceHolder = this.getReplaceHolder(filterBypass, n, n2, string, attributeSet);
        this.replace(replaceHolder);
    }

    boolean replace(ReplaceHolder replaceHolder) throws BadLocationException {
        boolean bl = true;
        int n = 1;
        if (!(replaceHolder.length <= 0 || replaceHolder.text != null && replaceHolder.text.length() != 0 || this.getFormattedTextField().getSelectionStart() == replaceHolder.offset && replaceHolder.length <= 1)) {
            n = -1;
        }
        if (this.getOverwriteMode() && replaceHolder.text != null && this.getFormattedTextField().getSelectedText() == null) {
            replaceHolder.length = Math.min(Math.max(replaceHolder.length, replaceHolder.text.length()), replaceHolder.fb.getDocument().getLength() - replaceHolder.offset);
        }
        if (replaceHolder.text != null && !this.isLegalInsertText(replaceHolder.text) || !this.canReplace(replaceHolder) || replaceHolder.length == 0 && (replaceHolder.text == null || replaceHolder.text.length() == 0)) {
            bl = false;
        }
        if (bl) {
            int n2 = replaceHolder.cursorPosition;
            replaceHolder.fb.replace(replaceHolder.offset, replaceHolder.length, replaceHolder.text, replaceHolder.attrs);
            if (n2 == -1) {
                n2 = replaceHolder.offset;
                if (n == 1 && replaceHolder.text != null) {
                    n2 = replaceHolder.offset + replaceHolder.text.length();
                }
            }
            this.updateValue(replaceHolder.value);
            this.repositionCursor(n2, n);
            return true;
        }
        this.invalidEdit();
        return false;
    }

    void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
        filterBypass.setDot(n, bias);
    }

    void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
        filterBypass.moveDot(n, bias);
    }

    ReplaceHolder getReplaceHolder(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) {
        if (this.replaceHolder == null) {
            this.replaceHolder = new ReplaceHolder();
        }
        this.replaceHolder.reset(filterBypass, n, n2, string, attributeSet);
        return this.replaceHolder;
    }

    private class DefaultDocumentFilter
    extends DocumentFilter
    implements Serializable {
        private DefaultDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.remove(n, n2);
            } else {
                DefaultFormatter.this.replace(filterBypass, n, n2, null, null);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists() || Utilities.isComposedTextAttributeDefined(attributeSet)) {
                filterBypass.insertString(n, string, attributeSet);
            } else {
                DefaultFormatter.this.replace(filterBypass, n, 0, string, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists() || Utilities.isComposedTextAttributeDefined(attributeSet)) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                DefaultFormatter.this.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }

    private class DefaultNavigationFilter
    extends NavigationFilter
    implements Serializable {
        private DefaultNavigationFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.setDot(n, bias);
            } else {
                DefaultFormatter.this.setDot(filterBypass, n, bias);
            }
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.moveDot(n, bias);
            } else {
                DefaultFormatter.this.moveDot(filterBypass, n, bias);
            }
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (jTextComponent.composedTextExists()) {
                return jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
            }
            return DefaultFormatter.this.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
        }
    }

    static class ReplaceHolder {
        DocumentFilter.FilterBypass fb;
        int offset;
        int length;
        String text;
        AttributeSet attrs;
        Object value;
        int cursorPosition;

        ReplaceHolder() {
        }

        void reset(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) {
            this.fb = filterBypass;
            this.offset = n;
            this.length = n2;
            this.text = string;
            this.attrs = attributeSet;
            this.value = null;
            this.cursorPosition = -1;
        }
    }
}

