/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.ArrayList;
import javax.annotation.Nullable;

public final class CommandLineOptionConfiguration {
    private final String longOption;
    private final String shortOption;
    private final String description;
    private boolean incubating;
    private String deprecationWarning;

    private CommandLineOptionConfiguration(String longOption, String description) {
        this(longOption, null, description);
    }

    private CommandLineOptionConfiguration(String longOption, @Nullable String shortOption, String description) {
        assert (longOption != null) : "longOption cannot be null";
        assert (description != null) : "description cannot be null";
        this.longOption = longOption;
        this.shortOption = shortOption;
        this.description = description;
    }

    public static CommandLineOptionConfiguration create(String longOption, String description) {
        return new CommandLineOptionConfiguration(longOption, description);
    }

    public static CommandLineOptionConfiguration create(String longOption, String shortOption, String description) {
        return new CommandLineOptionConfiguration(longOption, shortOption, description);
    }

    public CommandLineOptionConfiguration incubating() {
        this.incubating = true;
        return this;
    }

    public CommandLineOptionConfiguration deprecated(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return this;
    }

    public String getLongOption() {
        return this.longOption;
    }

    @Nullable
    public String getShortOption() {
        return this.shortOption;
    }

    public String[] getAllOptions() {
        ArrayList<String> allOptions = new ArrayList<String>();
        allOptions.add(this.longOption);
        if (this.shortOption != null) {
            allOptions.add(this.shortOption);
        }
        return allOptions.toArray(new String[allOptions.size()]);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIncubating() {
        return this.incubating;
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }
}

