/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "recordNopsRequiredForDebugger", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "requiredNops", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "recordNopsRequiredForTryCatchBlocks", "transform", "internalClassName", "", "kotlin-compiler"})
public final class RedundantNopsCleanupMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        new LabelNormalizationMethodTransformer().transform(internalClassName, methodNode);
        HashSet requiredNops = new HashSet();
        this.recordNopsRequiredForTryCatchBlocks(methodNode, requiredNops);
        this.recordNopsRequiredForDebugger(methodNode, requiredNops);
        AbstractInsnNode current = methodNode.instructions.getFirst();
        while (current != null) {
            if (current.getOpcode() == 0 && !requiredNops.contains(current)) {
                AbstractInsnNode toRemove = current;
                current = current.getNext();
                methodNode.instructions.remove(toRemove);
                continue;
            }
            current = current.getNext();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordNopsRequiredForDebugger(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Object object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            Object it;
            AbstractInsnNode finger$iv;
            AbstractInsnNode insn = object.next();
            if (!(insn instanceof LineNumberNode)) continue;
            $receiver$iv = insn;
            for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !((it = finger$iv) instanceof LineNumberNode && ((LineNumberNode)it).line != ((LineNumberNode)insn).line); finger$iv = finger$iv.getNext()) {
            }
            AbstractInsnNode nextLineNumber = finger$iv;
            CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(insn, nextLineNumber));
        }
        object = this;
        RedundantNopsCleanupMethodTransformer $receiver = (RedundantNopsCleanupMethodTransformer)object;
        Object[] $receiver2 = $receiver$iv = new HashSet();
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            $receiver2.add(localVariable.start);
            $receiver2.add(localVariable.end);
        }
        Object[] labels2 = $receiver$iv;
        $receiver2 = $receiver$iv = (Object[])methodNode.instructions.toArray();
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            AbstractInsnNode it = (AbstractInsnNode)element$iv$iv;
            if (!kotlin.collections.CollectionsKt.contains((Iterable)labels2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = 0;
        List localVariableLabels = (List)destination$iv$iv;
        int n2 = localVariableLabels.size() - 2;
        if (n <= n2) {
            while (true) {
                boolean bl;
                AbstractInsnNode end;
                AbstractInsnNode begin;
                void i;
                block8: {
                    begin = (AbstractInsnNode)localVariableLabels.get((int)i);
                    end = (AbstractInsnNode)localVariableLabels.get((int)(i + true));
                    AbstractInsnNode abstractInsnNode = begin;
                    Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "begin");
                    Sequence $receiver$iv2 = new InsnSequence(abstractInsnNode, end);
                    Iterator iterator2 = $receiver$iv2.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        if (!requiredNops.contains(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) {
                    CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(begin, end));
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void recordNopsRequiredForTryCatchBlocks(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            AbstractInsnNode nop;
            AbstractInsnNode it;
            AbstractInsnNode finger$iv;
            AbstractInsnNode $receiver$iv = tcb.start;
            for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.isMeaningful(it = finger$iv); finger$iv = finger$iv.getNext()) {
            }
            AbstractInsnNode abstractInsnNode = nop = finger$iv;
            if (abstractInsnNode == null) continue;
            if (abstractInsnNode.getOpcode() != 0) continue;
            requiredNops.add(nop);
        }
    }
}

