/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;

public class ShutdownCoordinator
implements DaemonStartListener,
Stoppable {
    private final Set<DaemonConnectDetails> daemons = new CopyOnWriteArraySet<DaemonConnectDetails>();
    private final DaemonClientFactory clientFactory;
    private final OutputEventListener outputEventListener;

    public ShutdownCoordinator(DaemonClientFactory clientFactory, OutputEventListener outputEventListener) {
        this.clientFactory = clientFactory;
        this.outputEventListener = outputEventListener;
    }

    public void daemonStarted(DaemonConnectDetails daemon) {
        this.daemons.add(daemon);
    }

    public void stop() {
        ServiceRegistry clientServices = this.clientFactory.createStopDaemonServices(this.outputEventListener, new DaemonParameters(new BuildLayoutParameters()));
        DaemonStopClient client = clientServices.get(DaemonStopClient.class);
        client.gracefulStop(this.daemons);
    }
}

