/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchUtil {
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final Pattern QUOTED = Pattern.compile("\"([^\"]+)\"");
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    public static final String STYLE_END = "</style>";

    private SearchUtil() {
    }

    public static void processProjectConfigurables(Project project, Map<SearchableConfigurable, Set<OptionDescription>> options) {
        SearchUtil.processConfigurables(ShowSettingsUtilImpl.getConfigurables(project, true), options);
    }

    private static void processConfigurables(Configurable[] configurables, Map<SearchableConfigurable, Set<OptionDescription>> options) {
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable) || configurable instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable).isVisible()) continue;
            TreeSet<OptionDescription> configurableOptions = new TreeSet<OptionDescription>();
            options.put((SearchableConfigurable)configurable, configurableOptions);
            if (configurable instanceof MasterDetails) {
                MasterDetails md = (MasterDetails)configurable;
                md.initUi();
                SearchUtil.processComponent(configurable, configurableOptions, md.getMaster());
                SearchUtil.processComponent(configurable, configurableOptions, md.getDetails().getComponent());
                continue;
            }
            SearchUtil.processComponent(configurable, configurableOptions, configurable.createComponent());
        }
    }

    private static void processComponent(Configurable configurable, Set<OptionDescription> configurableOptions, JComponent component) {
        if (component != null) {
            SearchUtil.processUILabel(configurable.getDisplayName(), configurableOptions, null);
            SearchUtil.processComponent(component, configurableOptions, null);
        }
    }

    private static void processComponent(JComponent component, Set<OptionDescription> configurableOptions, String path) {
        block7: {
            block10: {
                Object tabbedPane;
                block9: {
                    block8: {
                        block6: {
                            String label;
                            TitledBorder titledBorder;
                            String title;
                            if (component instanceof SkipSelfSearchComponent) {
                                return;
                            }
                            Border border = component.getBorder();
                            if (border instanceof TitledBorder && (title = (titledBorder = (TitledBorder)border).getTitle()) != null) {
                                SearchUtil.processUILabel(title, configurableOptions, path);
                            }
                            if ((label = SearchUtil.getLabelFromComponent(component)) == null) break block6;
                            SearchUtil.processUILabel(label, configurableOptions, path);
                            break block7;
                        }
                        if (!(component instanceof JComboBox)) break block8;
                        List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)component);
                        for (String each : labels) {
                            SearchUtil.processUILabel(each, configurableOptions, path);
                        }
                        break block7;
                    }
                    if (!(component instanceof JTabbedPane)) break block9;
                    tabbedPane = (JTabbedPane)component;
                    int tabCount = ((JTabbedPane)tabbedPane).getTabCount();
                    for (int i = 0; i < tabCount; ++i) {
                        String title = path != null ? path + '.' + ((JTabbedPane)tabbedPane).getTitleAt(i) : ((JTabbedPane)tabbedPane).getTitleAt(i);
                        SearchUtil.processUILabel(title, configurableOptions, title);
                        Component tabComponent = ((JTabbedPane)tabbedPane).getComponentAt(i);
                        if (!(tabComponent instanceof JComponent)) continue;
                        SearchUtil.processComponent((JComponent)tabComponent, configurableOptions, title);
                    }
                    break block7;
                }
                if (!(component instanceof TabbedPaneWrapper.TabbedPaneHolder)) break block10;
                tabbedPane = ((TabbedPaneWrapper.TabbedPaneHolder)component).getTabbedPaneWrapper();
                int tabCount = ((TabbedPaneWrapper)tabbedPane).getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    String tabTitle = ((TabbedPaneWrapper)tabbedPane).getTitleAt(i);
                    String title = path != null ? path + '.' + tabTitle : tabTitle;
                    SearchUtil.processUILabel(title, configurableOptions, title);
                    JComponent tabComponent = ((TabbedPaneWrapper)tabbedPane).getComponentAt(i);
                    if (tabComponent == null) continue;
                    SearchUtil.processComponent(tabComponent, configurableOptions, title);
                }
                break block7;
            }
            Component[] components = component.getComponents();
            if (components == null) break block7;
            for (Component child : components) {
                if (!(child instanceof JComponent)) continue;
                SearchUtil.processComponent((JComponent)child, configurableOptions, path);
            }
        }
    }

    @Nullable
    private static String getLabelFromComponent(@Nullable Component component) {
        String label = null;
        if (component instanceof JLabel) {
            label = ((JLabel)component).getText();
        } else if (component instanceof JCheckBox) {
            label = ((JCheckBox)component).getText();
        } else if (component instanceof JRadioButton) {
            label = ((JRadioButton)component).getText();
        } else if (component instanceof JButton) {
            label = ((JButton)component).getText();
        }
        return StringUtil.nullize((String)label, (boolean)true);
    }

    @NotNull
    private static List<String> getItemsFromComboBox(@NotNull JComboBox comboBox) {
        DefaultListCellRenderer renderer;
        if (comboBox == null) {
            SearchUtil.$$$reportNull$$$0(0);
        }
        if ((renderer = comboBox.getRenderer()) == null) {
            renderer = new DefaultListCellRenderer();
        }
        JList<Object> jList = new BasicComboPopup(comboBox).getList();
        ArrayList<String> result2 = new ArrayList<String>();
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object value = comboBox.getItemAt(i);
            Component labelComponent = renderer.getListCellRendererComponent(jList, value, i, false, false);
            String label = SearchUtil.getLabelFromComponent(labelComponent);
            if (label == null) continue;
            result2.add(label);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SearchUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void processUILabel(String title, Set<OptionDescription> configurableOptions, String path) {
        title = HTML_PATTERN.matcher(title).replaceAll(" ");
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWordsWithoutStemming(title);
        String regex = "[\\W&&[^\\p{Punct}\\p{Blank}]]";
        for (String option : words) {
            configurableOptions.add(new OptionDescription(option, title.replaceAll("[\\W&&[^\\p{Punct}\\p{Blank}]]", " "), path));
        }
    }

    public static Runnable lightOptions(SearchableConfigurable configurable, JComponent component, String option, GlassPanel glassPanel) {
        return () -> {
            if (!SearchUtil.traverseComponentsTree(configurable, glassPanel, component, option, true)) {
                SearchUtil.traverseComponentsTree(configurable, glassPanel, component, option, false);
            }
        };
    }

    private static int getSelection(String tabIdx, JTabbedPane tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i;
            }
            if (!tabIdx.equalsIgnoreCase(title)) continue;
            return i;
        }
        return -1;
    }

    public static int getSelection(String tabIdx, TabbedPaneWrapper tabbedPane) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = tabbedPane.getTitleAt(i);
            Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
            pathWords.removeAll(titleWords);
            if (!pathWords.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static boolean traverseComponentsTree(SearchableConfigurable configurable, GlassPanel glassPanel, JComponent rootComponent, String option, boolean force) {
        Component[] components;
        int index;
        String path;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        if (option == null || option.trim().length() == 0) {
            return false;
        }
        boolean highlight = false;
        String label = SearchUtil.getLabelFromComponent(rootComponent);
        if (label != null) {
            if (SearchUtil.isComponentHighlighted(label, option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(rootComponent);
            }
        } else if (rootComponent instanceof JComboBox) {
            List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)rootComponent);
            if (ContainerUtil.exists(labels, it -> SearchUtil.isComponentHighlighted(it, option, force, configurable))) {
                highlight = true;
                glassPanel.addSpotlight(rootComponent);
            }
        } else if (rootComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)rootComponent;
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPane)) > -1 && index < tabbedPane.getTabCount() && tabbedPane.getTabComponentAt(index) instanceof JComponent) {
                glassPanel.addSpotlight((JComponent)tabbedPane.getTabComponentAt(index));
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            path = SearchableOptionsRegistrar.getInstance().getInnerPath(configurable, option);
            if (path != null && (index = SearchUtil.getSelection(path, tabbedPaneWrapper)) > -1 && index < tabbedPaneWrapper.getTabCount()) {
                glassPanel.addSpotlight((JComponent)tabbedPaneWrapper.getTabComponentAt(index));
            }
        }
        for (Component component : components = rootComponent.getComponents()) {
            String title;
            Border border;
            if (!(component instanceof JComponent)) continue;
            boolean innerHighlight = SearchUtil.traverseComponentsTree(configurable, glassPanel, (JComponent)component, option, force);
            if (!highlight && !innerHighlight && (border = rootComponent.getBorder()) instanceof TitledBorder && SearchUtil.isComponentHighlighted(title = ((TitledBorder)border).getTitle(), option, force, configurable)) {
                highlight = true;
                glassPanel.addSpotlight(rootComponent);
                rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, Boolean.TRUE);
            }
            if (!innerHighlight) continue;
            highlight = true;
        }
        return highlight;
    }

    public static boolean isComponentHighlighted(String text, String option, boolean force, SearchableConfigurable configurable) {
        Set options;
        if (text == null || option == null || option.length() == 0) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = searchableOptionsRegistrar.getProcessedWords(option);
        Set set2 = options = configurable != null ? searchableOptionsRegistrar.replaceSynonyms(words, configurable) : words;
        if (options == null || options.isEmpty()) {
            return text.toLowerCase(Locale.US).contains(option.toLowerCase(Locale.US));
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text);
        if (!force) {
            options.retainAll(tokens);
            boolean highlight = !options.isEmpty();
            return highlight || text.toLowerCase(Locale.US).contains(option.toLowerCase(Locale.US));
        }
        options.removeAll(tokens);
        return options.isEmpty();
    }

    public static String markup(@NotNull String textToMarkup, @Nullable String filter2) {
        String foot;
        String head;
        if (textToMarkup == null) {
            SearchUtil.$$$reportNull$$$0(2);
        }
        if (filter2 == null || filter2.length() == 0) {
            return textToMarkup;
        }
        int bodyStart = textToMarkup.indexOf("<body>");
        int bodyEnd = textToMarkup.indexOf("</body>");
        if (bodyStart >= 0) {
            head = textToMarkup.substring(0, bodyStart += "<body>".length());
            foot = bodyEnd >= 0 ? textToMarkup.substring(bodyEnd) : "";
            textToMarkup = textToMarkup.substring(bodyStart, bodyEnd);
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet<String> quoted = new HashSet<String>();
        filter2 = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(textToMarkup, filter2), quoted);
        Set options = registrar.getProcessedWords(filter2);
        Set words = registrar.getProcessedWords(textToMarkup);
        for (String option : options) {
            if (!words.contains(option)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, option);
        }
        for (String stripped : quoted) {
            if (registrar.isStopWord(stripped)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, stripped);
        }
        return head + textToMarkup + foot;
    }

    private static String quoteStrictOccurrences(String textToMarkup, String filter2) {
        String cur = "";
        String s = textToMarkup.toLowerCase(Locale.US);
        for (String part : filter2.split(" ")) {
            cur = s.contains(part) ? cur + "\"" + part + "\" " : cur + part + " ";
        }
        return cur;
    }

    private static String markup(String textToMarkup, Pattern insideHtmlTagPattern, String option) {
        int styleIdx = textToMarkup.indexOf("<style");
        int styleEndIdx = textToMarkup.indexOf(STYLE_END);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return SearchUtil.markupInText(textToMarkup, insideHtmlTagPattern, option);
        }
        return SearchUtil.markup(textToMarkup.substring(0, styleIdx), insideHtmlTagPattern, option) + SearchUtil.markup(textToMarkup.substring(styleEndIdx + STYLE_END.length()), insideHtmlTagPattern, option);
    }

    private static String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option) {
        int idx;
        String result2 = "";
        int beg = 0;
        while ((idx = StringUtil.indexOfIgnoreCase((String)textToMarkup, (String)option, (int)beg)) != -1) {
            String prefix = textToMarkup.substring(beg, idx);
            String toMark = textToMarkup.substring(idx, idx + option.length());
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = textToMarkup.indexOf(">", idx);
                result2 = result2 + prefix + textToMarkup.substring(idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2 = result2 + prefix + "<font color='#ffffff' bgColor='#1d5da7'>" + toMark + "</font>";
            beg = idx + option.length();
        }
        result2 = result2 + textToMarkup.substring(beg);
        return result2;
    }

    public static void appendFragments(String filter2, String text, @SimpleTextAttributes.StyleAttributeConstant int style, Color foreground, Color background, SimpleColoredComponent textRenderer) {
        if (text == null) {
            return;
        }
        if (filter2 == null || filter2.length() == 0) {
            textRenderer.append(text, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            HashSet<String> quoted = new HashSet<String>();
            filter2 = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(text, filter2), quoted);
            TreeMap<Integer, String> indx = new TreeMap<Integer, String>();
            for (String stripped : quoted) {
                int idx;
                int beg = 0;
                while ((idx = StringUtil.indexOfIgnoreCase((String)text, (String)stripped, (int)beg)) != -1) {
                    indx.put(idx, text.substring(idx, idx + stripped.length()));
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            for (Integer index : indx.keySet()) {
                String stripped = (String)indx.get(index);
                int start = index;
                if (pos > start) {
                    String highlighted = (String)selectedWords.get(selectedWords.size() - 1);
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                SearchUtil.appendSelectedWords(text, selectedWords, pos, start, filter2);
                selectedWords.add(stripped);
                pos = start + stripped.length();
            }
            SearchUtil.appendSelectedWords(text, selectedWords, pos, text.length(), filter2);
            int idx = 0;
            for (String word : selectedWords) {
                String before = (text = text.substring(idx)).substring(0, text.indexOf(word));
                if (before.length() > 0) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = text.indexOf(word) + word.length();
                textRenderer.append(text.substring(idx - word.length(), idx), new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            String after = text.substring(idx, text.length());
            if (after.length() > 0) {
                textRenderer.append(after, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    private static void appendSelectedWords(String text, List<String> selectedWords, int pos, int end, String filter2) {
        if (pos < end) {
            String[] words;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter2);
            for (String word : words = text.substring(pos, end).split("[\\W&&[^-]]+")) {
                if (!filters.contains(PorterStemmerUtil.stem(word.toLowerCase(Locale.US)))) continue;
                selectedWords.add(word);
            }
        }
    }

    public static List<Set<String>> findKeys(String filter2, Set<String> quoted) {
        filter2 = SearchUtil.processFilter(filter2.toLowerCase(Locale.US), quoted);
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = optionsRegistrar.getProcessedWords(filter2);
        for (String word : words) {
            Set<OptionDescription> descriptions = ((SearchableOptionsRegistrarImpl)optionsRegistrar).getAcceptableDescriptions(word);
            HashSet<String> keySet = new HashSet<String>();
            if (descriptions != null) {
                for (OptionDescription description : descriptions) {
                    keySet.add(description.getPath());
                }
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !StringUtil.isEmptyOrSpaces((String)filter2)) {
            keySetList.add(Collections.singleton(filter2));
        }
        return keySetList;
    }

    public static String processFilter(String filter2, Set<String> quoted) {
        String withoutQuoted = "";
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter2);
        while (matcher.find()) {
            int start = matcher.start(1);
            withoutQuoted = withoutQuoted + " " + filter2.substring(beg, start);
            beg = matcher.end(1);
            String trimmed = filter2.substring(start, beg).trim();
            if (trimmed.length() <= 0) continue;
            quoted.add(trimmed);
        }
        return withoutQuoted + " " + filter2.substring(beg);
    }

    public static List<Configurable> expand(ConfigurableGroup[] groups) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        for (ConfigurableGroup eachGroup : groups) {
            result2.addAll(SearchUtil.expandGroup(eachGroup));
        }
        return result2;
    }

    public static List<Configurable> expandGroup(ConfigurableGroup group) {
        Object[] configurables = group.getConfigurables();
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        ContainerUtil.addAll(result2, (Object[])configurables);
        for (Object each : configurables) {
            SearchUtil.addChildren((Configurable)each, result2);
        }
        return ContainerUtil.filter(result2, configurable -> !(configurable instanceof SearchableConfigurable.Parent) || ((SearchableConfigurable.Parent)configurable).isVisible());
    }

    private static void addChildren(Configurable configurable, List<Configurable> list2) {
        if (configurable instanceof Configurable.Composite) {
            Configurable[] kids;
            for (Configurable eachKid : kids = ((Configurable.Composite)configurable).getConfigurables()) {
                list2.add(eachKid);
                SearchUtil.addChildren(eachKid, list2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMarkup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsFromComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemsFromComboBox";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

