/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(0);
        }
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @NotNull String libraryName) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            OrderEntryUtil.$$$reportNull$$$0(2);
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            String libName;
            if (!(orderEntry instanceof LibraryOrderEntry) || !libraryName.equals(libName = ((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module2) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module2.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model, @Nullable Sdk sdk) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry) || !sdk.equals(((JdkOrderEntry)orderEntry).getJdk())) continue;
            return (JdkOrderEntry)orderEntry;
        }
        return null;
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        if (orderEntry1 instanceof JdkOrderEntry && orderEntry2 instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getJdk(), (Object)jdkOrderEntry2.getJdk()) && Comparing.strEqual((String)jdkOrderEntry1.getJdkName(), (String)jdkOrderEntry2.getJdkName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry && orderEntry2 instanceof LibraryOrderEntry) {
            LibraryOrderEntry jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getLibrary(), (Object)jdkOrderEntry2.getLibrary());
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry && orderEntry2 instanceof ModuleSourceOrderEntry) {
            ModuleSourceOrderEntry jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getOwnerModule(), (Object)jdkOrderEntry2.getOwnerModule());
        }
        if (orderEntry1 instanceof ModuleOrderEntry && orderEntry2 instanceof ModuleOrderEntry) {
            ModuleOrderEntry jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getModule(), (Object)jdkOrderEntry2.getModule());
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name = library1.getName();
            return name != null && name.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            if (Comparing.equal((Object[])library1.getUrls(type), (Object[])library2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(LibraryOrderEntry libraryOrderEntry, Module module2) {
        Library library = libraryOrderEntry.getLibrary();
        if (library == null) {
            return;
        }
        OrderEntryUtil.addLibraryToRoots(module2, library);
    }

    public static void addLibraryToRoots(@NotNull Module module2, @NotNull Library library) {
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(5);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(6);
        }
        OrderEntryUtil.addLibraryToRoots(module2, library, DependencyScope.COMPILE, false);
    }

    public static void addLibraryToRoots(@NotNull Module module2, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        LibraryOrderEntry entry;
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(7);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            OrderEntryUtil.$$$reportNull$$$0(9);
        }
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        if (library.getTable() == null) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files;
                for (VirtualFile jarFile : files = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
            entry = rootModel.findLibraryOrderEntry(jarLibrary);
        } else {
            entry = rootModel.addLibraryEntry(library);
        }
        if (entry != null) {
            entry.setScope(scope);
            entry.setExported(exported);
        }
        rootModel.commit();
    }

    private static int findLibraryOrderEntry(@NotNull OrderEntry[] entries, @NotNull Library library) {
        if (entries == null) {
            OrderEntryUtil.$$$reportNull$$$0(10);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < entries.length; ++i) {
            OrderEntry entry = entries[i];
            if (!(entry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)entry).getLibrary())) continue;
            return i;
        }
        return -1;
    }

    public static void replaceLibrary(@NotNull ModifiableRootModel model, @NotNull Library oldLibrary, @NotNull Library newLibrary) {
        int i;
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(12);
        }
        if (oldLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(13);
        }
        if (newLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(14);
        }
        if ((i = OrderEntryUtil.findLibraryOrderEntry(model.getOrderEntries(), oldLibrary)) == -1) {
            return;
        }
        model.addLibraryEntry(newLibrary);
        OrderEntryUtil.replaceLibraryByAdded(model, i);
    }

    public static void replaceLibraryEntryByAdded(@NotNull ModifiableRootModel model, @NotNull LibraryOrderEntry entry) {
        int i;
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(15);
        }
        if (entry == null) {
            OrderEntryUtil.$$$reportNull$$$0(16);
        }
        if ((i = ArrayUtil.indexOf((Object[])model.getOrderEntries(), (Object)entry)) == -1) {
            return;
        }
        OrderEntryUtil.replaceLibraryByAdded(model, i);
    }

    private static void replaceLibraryByAdded(ModifiableRootModel model, int toReplace) {
        OrderEntry[] entries = model.getOrderEntries();
        LibraryOrderEntry newEntry = (LibraryOrderEntry)entries[entries.length - 1];
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entries[toReplace];
        boolean exported = libraryEntry.isExported();
        DependencyScope scope = libraryEntry.getScope();
        model.removeOrderEntry((OrderEntry)libraryEntry);
        newEntry.setExported(exported);
        newEntry.setScope(scope);
        OrderEntry[] newEntries = new OrderEntry[entries.length - 1];
        System.arraycopy(entries, 0, newEntries, 0, toReplace);
        newEntries[toReplace] = newEntry;
        System.arraycopy(entries, toReplace + 1, newEntries, toReplace + 1, entries.length - toReplace - 2);
        model.rearrangeOrderEntries(newEntries);
    }

    public static <T extends OrderEntry> void processOrderEntries(@NotNull Module module2, @NotNull Class<T> orderEntryClass, @NotNull Processor<T> processor2) {
        OrderEntry[] orderEntries;
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(17);
        }
        if (orderEntryClass == null) {
            OrderEntryUtil.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(19);
        }
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            if (orderEntryClass.isInstance(orderEntry) && !processor2.process(orderEntryClass.cast(orderEntry))) break;
        }
    }

    public static DependencyScope intersectScopes(DependencyScope scope1, DependencyScope scope2) {
        if (scope1 == scope2) {
            return scope1;
        }
        if (scope1 == DependencyScope.COMPILE) {
            return scope2;
        }
        if (scope2 == DependencyScope.COMPILE) {
            return scope1;
        }
        if (scope1 == DependencyScope.TEST || scope2 == DependencyScope.TEST) {
            return DependencyScope.TEST;
        }
        return scope1;
    }

    @NotNull
    public static List<Library> getModuleLibraries(@NotNull ModuleRootModel model) {
        if (model == null) {
            OrderEntryUtil.$$$reportNull$$$0(20);
        }
        OrderEntry[] orderEntries = model.getOrderEntries();
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : orderEntries) {
            LibraryOrderEntry entry;
            if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
            libraries.add(entry.getLibrary());
        }
        ArrayList<Library> arrayList = libraries;
        if (arrayList == null) {
            OrderEntryUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 5: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLibrary";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOrderEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findJdkOrderEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibrary";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraryEntryByAdded";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processOrderEntries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getModuleLibraries";
                break;
            }
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

