/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.VolatileImage;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PaintersHelper
implements Painter.Listener {
    private static final Logger LOG = Logger.getInstance(PaintersHelper.class);
    private final Set<Painter> myPainters;
    private final Map<Painter, Component> myPainter2Component;
    private final JComponent myRootComponent;

    public PaintersHelper(@NotNull JComponent component) {
        if (component == null) {
            PaintersHelper.$$$reportNull$$$0(0);
        }
        this.myPainters = ContainerUtil.newLinkedHashSet();
        this.myPainter2Component = ContainerUtil.newLinkedHashMap();
        this.myRootComponent = component;
    }

    public boolean hasPainters() {
        return !this.myPainters.isEmpty();
    }

    public boolean needsRepaint() {
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            return true;
        }
        return false;
    }

    public void addPainter(@NotNull Painter painter, @Nullable Component component) {
        if (painter == null) {
            PaintersHelper.$$$reportNull$$$0(1);
        }
        this.myPainters.add(painter);
        this.myPainter2Component.put(painter, component == null ? this.myRootComponent : component);
        painter.addListener((Painter.Listener)this);
    }

    public void removePainter(@NotNull Painter painter) {
        if (painter == null) {
            PaintersHelper.$$$reportNull$$$0(2);
        }
        painter.removeListener((Painter.Listener)this);
        this.myPainters.remove(painter);
        this.myPainter2Component.remove(painter);
    }

    public void clear() {
        for (Painter painter : this.myPainters) {
            painter.removeListener((Painter.Listener)this);
        }
        this.myPainters.clear();
        this.myPainter2Component.clear();
    }

    public void paint(Graphics g) {
        this.runAllPainters(g, this.computeOffsets(g, this.myRootComponent));
    }

    void runAllPainters(Graphics gg, int[] offsets) {
        if (this.myPainters.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        AffineTransform orig = g.getTransform();
        int i = 0;
        AffineTransform t = new AffineTransform();
        t.translate(offsets[i++], offsets[i++]);
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.myPainter2Component.get(painter);
            g.setTransform(t);
            g.translate(offsets[i++], offsets[i++]);
            g.scale(orig.getScaleX(), orig.getScaleY());
            painter.paint(cur, g);
        }
        g.setTransform(orig);
    }

    @NotNull
    int[] computeOffsets(Graphics gg, @NotNull JComponent component) {
        if (component == null) {
            PaintersHelper.$$$reportNull$$$0(3);
        }
        if (this.myPainters.isEmpty()) {
            if (ArrayUtil.EMPTY_INT_ARRAY == null) {
                PaintersHelper.$$$reportNull$$$0(4);
            }
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int i = 0;
        int[] offsets = new int[2 + this.myPainters.size() * 2];
        Graphics2D g = (Graphics2D)gg;
        AffineTransform tx = g.getTransform();
        offsets[i++] = (int)tx.getTranslateX();
        offsets[i++] = (int)tx.getTranslateY();
        Rectangle r = null;
        Component prev = null;
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.myPainter2Component.get(painter);
            if (cur != prev || r == null) {
                Container curParent = cur.getParent();
                if (curParent == null) continue;
                r = SwingUtilities.convertRectangle(curParent, cur.getBounds(), component);
                prev = cur;
            }
            offsets[i++] = (int)((double)r.x * tx.getScaleX());
            offsets[i++] = (int)((double)r.y * tx.getScaleY());
        }
        if (offsets == null) {
            PaintersHelper.$$$reportNull$$$0(5);
        }
        return offsets;
    }

    public void onNeedsRepaint(Painter painter, JComponent dirtyComponent) {
        if (dirtyComponent != null && dirtyComponent.isShowing()) {
            Rectangle rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this.myRootComponent);
            this.myRootComponent.repaint(rec);
        } else {
            this.myRootComponent.repaint();
        }
    }

    public static void initWallpaperPainter(@NotNull String propertyName, @NotNull PaintersHelper painters) {
        if (propertyName == null) {
            PaintersHelper.$$$reportNull$$$0(6);
        }
        if (painters == null) {
            PaintersHelper.$$$reportNull$$$0(7);
        }
        ImagePainter painter = (ImagePainter)PaintersHelper.newWallpaperPainter(propertyName, painters.myRootComponent);
        painters.addPainter((Painter)painter, null);
    }

    private static AbstractPainter newWallpaperPainter(final @NotNull String propertyName, final @NotNull JComponent rootComponent) {
        if (propertyName == null) {
            PaintersHelper.$$$reportNull$$$0(8);
        }
        if (rootComponent == null) {
            PaintersHelper.$$$reportNull$$$0(9);
        }
        return new ImagePainter(){
            Image image;
            float alpha;
            Insets insets;
            Fill fillType;
            Place place;
            String current;

            public boolean needsRepaint() {
                return this.ensureImageLoaded();
            }

            public void executePaint(Component component, Graphics2D g) {
                if (this.image == null) {
                    return;
                }
                this.executePaint(g, component, this.image, this.fillType, this.place, this.alpha, this.insets);
            }

            boolean ensureImageLoaded() {
                IdeFrame frame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)rootComponent);
                Project project = frame == null ? null : frame.getProject();
                String value = IdeBackgroundUtil.getBackgroundSpec(project, propertyName);
                if (!Comparing.equal((String)value, (String)this.current)) {
                    this.current = value;
                    this.loadImageAsync(value);
                }
                return this.image != null;
            }

            private void resetImage(String value, Image newImage, float newAlpha, Fill newFill, Place newPlace) {
                boolean newOk;
                if (!Comparing.equal((String)this.current, (String)value)) {
                    return;
                }
                boolean prevOk = this.image != null;
                this.clearImages(-1L);
                this.image = newImage;
                this.insets = JBUI.emptyInsets();
                this.alpha = newAlpha;
                this.fillType = newFill;
                this.place = newPlace;
                boolean bl = newOk = newImage != null;
                if (prevOk || newOk) {
                    ModalityState modalityState = ModalityState.stateForComponent((Component)rootComponent);
                    if (modalityState.dominates(ModalityState.NON_MODAL)) {
                        UIUtil.getActiveWindow().repaint();
                    } else {
                        IdeBackgroundUtil.repaintAllWindows();
                    }
                }
            }

            private void loadImageAsync(String propertyValue) {
                String[] parts = (propertyValue != null ? propertyValue : propertyName + ".png").split(",");
                float newAlpha = Math.abs(Math.min((float)StringUtil.parseInt((String)(parts.length > 1 ? parts[1] : ""), (int)10) / 100.0f, 1.0f));
                Fill newFillType = (Fill)StringUtil.parseEnum((String)(parts.length > 2 ? parts[2].toUpperCase(Locale.ENGLISH) : ""), (Enum)Fill.SCALE, Fill.class);
                Place newPlace = (Place)StringUtil.parseEnum((String)(parts.length > 3 ? parts[3].toUpperCase(Locale.ENGLISH) : ""), (Enum)Place.CENTER, Place.class);
                String filePath = parts[0];
                if (StringUtil.isEmpty((String)filePath)) {
                    this.resetImage(propertyValue, null, newAlpha, newFillType, newPlace);
                    return;
                }
                try {
                    URL url = filePath.contains("://") ? new URL(filePath) : (FileUtil.isAbsolutePlatformIndependent((String)filePath) ? new File(filePath) : new File(PathManager.getConfigPath(), filePath)).toURI().toURL();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (rootComponent == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Image m = ImageLoader.loadFromUrl((URL)url);
                        ModalityState modalityState = ModalityState.stateForComponent((Component)rootComponent);
                        ApplicationManager.getApplication().invokeLater(() -> this.resetImage(propertyValue, m, newAlpha, newFillType, newPlace), modalityState);
                    });
                }
                catch (Exception e) {
                    this.resetImage(propertyValue, null, newAlpha, newFillType, newPlace);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootComponent", "com/intellij/openapi/wm/impl/PaintersHelper$1", "lambda$loadImageAsync$1"));
            }
        };
    }

    public static AbstractPainter newImagePainter(final @NotNull Image image, final Fill fillType, final Place place, final float alpha, final Insets insets) {
        if (image == null) {
            PaintersHelper.$$$reportNull$$$0(10);
        }
        return new ImagePainter(){

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component, Graphics2D g) {
                this.executePaint(g, component, image, fillType, place, alpha, insets);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/PaintersHelper";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/PaintersHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPainter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removePainter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeOffsets";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initWallpaperPainter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newWallpaperPainter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newImagePainter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ImagePainter
    extends AbstractPainter {
        final Map<GraphicsConfiguration, Cached> cachedMap = ContainerUtil.newHashMap();

        private ImagePainter() {
        }

        public void executePaint(Graphics2D g, Component component, Image image, Fill fillType, Place place, float alpha, Insets insets) {
            int y;
            int x;
            long currentTime;
            VolatileImage scaled;
            int cw0 = component.getWidth();
            int ch0 = component.getHeight();
            JBInsets i = JBUI.insets((int)(insets.top * ch0 / 100), (int)(insets.left * cw0 / 100), (int)(insets.bottom * ch0 / 100), (int)(insets.right * cw0 / 100));
            int cw = cw0 - i.left - i.right;
            int ch = ch0 - i.top - i.bottom;
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w <= 0 || h <= 0) {
                return;
            }
            GraphicsConfiguration cfg = g.getDeviceConfiguration();
            Cached cached = this.cachedMap.get(cfg);
            VolatileImage volatileImage = scaled = cached == null ? null : cached.image;
            if (fillType == Fill.SCALE || fillType == Fill.TILE) {
                boolean rescale;
                int sh;
                int sw;
                if (fillType == Fill.SCALE) {
                    boolean useWidth = cw * h > ch * w;
                    sw = useWidth ? cw : w * ch / h;
                    sh = useWidth ? h * cw / w : ch;
                } else {
                    sw = cw < w ? w : (cw + w) / w * w;
                    sh = ch < h ? h : (ch + h) / h * h;
                }
                int sw0 = scaled == null ? -1 : scaled.getWidth(null);
                int sh0 = scaled == null ? -1 : scaled.getHeight(null);
                boolean bl = rescale = cached == null || cached.used.width != sw || cached.used.height != sh;
                while ((scaled = ImagePainter.validateImage(cfg, scaled)) == null || rescale) {
                    if (scaled == null || sw0 < sw || sh0 < sh) {
                        scaled = ImagePainter.createImage(cfg, sw + sw / 10, sh + sh / 10);
                        cached = new Cached(scaled, new Dimension(sw, sh));
                        this.cachedMap.put(cfg, cached);
                    } else {
                        cached.used.setSize(sw, sh);
                    }
                    Graphics2D gg = scaled.createGraphics();
                    gg.setComposite(AlphaComposite.Src);
                    if (fillType == Fill.SCALE) {
                        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        UIUtil.drawImage((Graphics)gg, (Image)image, (Rectangle)new Rectangle(0, 0, sw, sh), null);
                    } else {
                        for (int x2 = 0; x2 < sw; x2 += w) {
                            for (int y2 = 0; y2 < sh; y2 += h) {
                                UIUtil.drawImage((Graphics)gg, (Image)image, (int)x2, (int)y2, null);
                            }
                        }
                    }
                    gg.dispose();
                    rescale = false;
                }
                w = sw;
                h = sh;
            } else {
                while ((scaled = ImagePainter.validateImage(cfg, scaled)) == null) {
                    scaled = ImagePainter.createImage(cfg, w, h);
                    cached = new Cached(scaled, new Dimension(w, h));
                    this.cachedMap.put(cfg, cached);
                    Graphics2D gg = scaled.createGraphics();
                    gg.setComposite(AlphaComposite.Src);
                    UIUtil.drawImage((Graphics)gg, (Image)image, (int)0, (int)0, null);
                    gg.dispose();
                }
            }
            cached.touched = currentTime = System.currentTimeMillis();
            if (this.cachedMap.size() > 2) {
                this.clearImages(currentTime);
            }
            if (place == Place.CENTER || place == Place.TOP_CENTER || place == Place.BOTTOM_CENTER) {
                x = i.left + (w - cw) / 2;
                y = place == Place.TOP_CENTER ? i.top : (place == Place.BOTTOM_CENTER ? h - ch0 - i.bottom : i.top + (h - ch) / 2);
            } else if (place == Place.TOP_LEFT || place == Place.TOP_RIGHT || place == Place.BOTTOM_LEFT || place == Place.BOTTOM_RIGHT) {
                x = place == Place.TOP_LEFT || place == Place.BOTTOM_LEFT ? i.left : w - cw0 - i.right;
                y = place == Place.TOP_LEFT || place == Place.TOP_RIGHT ? i.top : h - ch0 - i.bottom;
            } else {
                return;
            }
            float adjustedAlpha = Boolean.TRUE.equals(g.getRenderingHint(IdeBackgroundUtil.ADJUST_ALPHA)) ? alpha / 2.0f : alpha;
            GraphicsConfig gc = new GraphicsConfig((Graphics)g).setAlpha(adjustedAlpha);
            Rectangle src = new Rectangle(x, y, w, h);
            Rectangle dst = new Rectangle(i.left, i.top, w, h);
            UIUtil.drawImage((Graphics)g, (Image)scaled, (Rectangle)dst, (Rectangle)src, null);
            gc.restore();
        }

        void clearImages(long currentTime) {
            boolean all = currentTime <= 0L;
            Iterator<GraphicsConfiguration> it = this.cachedMap.keySet().iterator();
            while (it.hasNext()) {
                GraphicsConfiguration cfg = it.next();
                Cached c = this.cachedMap.get(cfg);
                if (!all && currentTime - c.touched <= 120000L) continue;
                it.remove();
                LOG.info(ImagePainter.logPrefix(cfg, c.image) + "image flushed" + (all ? "" : "; untouched for " + StringUtil.formatDuration((long)(currentTime - c.touched))));
                c.image.flush();
            }
        }

        @Nullable
        private static VolatileImage validateImage(@Nullable GraphicsConfiguration cfg, @Nullable VolatileImage image) {
            if (image == null) {
                return null;
            }
            boolean lost1 = image.contentsLost();
            int validated = image.validate(cfg);
            boolean lost2 = image.contentsLost();
            if (lost1 || lost2 || validated != 0) {
                LOG.info(ImagePainter.logPrefix(cfg, image) + "image flushed: contentsLost=" + lost1 + "||" + lost2 + "; validate=" + validated);
                image.flush();
                return null;
            }
            return image;
        }

        @NotNull
        private static VolatileImage createImage(@Nullable GraphicsConfiguration cfg, int w, int h) {
            VolatileImage image;
            GraphicsConfiguration safe = cfg != null ? cfg : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            try {
                image = safe.createCompatibleVolatileImage(w, h, new ImageCapabilities(true), 3);
            }
            catch (Exception e) {
                image = safe.createCompatibleVolatileImage(w, h, 3);
            }
            image.validate(cfg);
            image.setAccelerationPriority(1.0f);
            ImageCapabilities caps = image.getCapabilities();
            LOG.info(ImagePainter.logPrefix(cfg, image) + (caps.isAccelerated() ? "" : "non-") + "accelerated " + (caps.isTrueVolatile() ? "" : "non-") + "volatile image created");
            VolatileImage volatileImage = image;
            if (volatileImage == null) {
                ImagePainter.$$$reportNull$$$0(0);
            }
            return volatileImage;
        }

        @NotNull
        private static String logPrefix(@Nullable GraphicsConfiguration cfg, @NotNull VolatileImage image) {
            if (image == null) {
                ImagePainter.$$$reportNull$$$0(1);
            }
            String string = "(" + (cfg == null ? "null" : cfg.getClass().getSimpleName()) + ") " + image.getWidth() + "x" + image.getHeight() + " ";
            if (string == null) {
                ImagePainter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "logPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Cached {
        final VolatileImage image;
        final Dimension used;
        long touched;

        Cached(VolatileImage image, Dimension dim) {
            this.image = image;
            this.used = dim;
        }
    }

    public static enum Place {
        CENTER,
        TOP_CENTER,
        BOTTOM_CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum Fill {
        PLAIN,
        SCALE,
        TILE;

    }
}

