/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectedIndentOptionsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"indent.options.notification.provider");
    private static final Key<Boolean> NOTIFIED_FLAG = Key.create((String)"indent.options.notification.provider.status");
    public static final Key<Boolean> DETECT_INDENT_NOTIFICATION_SHOWN_KEY = Key.create((String)"indent.options.notification.provider.status.test.notification.shown");
    private static boolean myShowNotificationInTest = false;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            DetectedIndentOptionsNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        Editor editor;
        Project project;
        if (file2 == null) {
            DetectedIndentOptionsNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            DetectedIndentOptionsNotificationProvider.$$$reportNull$$$0(2);
        }
        Boolean notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG);
        if (fileEditor instanceof TextEditor && notifiedFlag != null && (project = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != null) {
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = documentManager.getPsiFile(document);
            Ref indentOptionsProviderRef = new Ref();
            if (psiFile != null) {
                EditorNotificationInfo info;
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
                CommonCodeStyleSettings.IndentOptions userOptions = settings.getIndentOptions(psiFile.getFileType());
                CommonCodeStyleSettings.IndentOptions detectedOptions = CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile(psiFile, null, false, provider -> {
                    indentOptionsProviderRef.set(provider);
                    return false;
                });
                FileIndentOptionsProvider provider2 = (FileIndentOptionsProvider)indentOptionsProviderRef.get();
                EditorNotificationInfo editorNotificationInfo = info = provider2 != null && !provider2.isAcceptedWithoutWarning(project, file2) && !userOptions.equals((Object)detectedOptions) ? provider2.getNotificationInfo(project, file2, fileEditor, userOptions, detectedOptions) : null;
                if (info != null) {
                    EditorNotificationPanel panel2 = new EditorNotificationPanel().text(info.getTitle());
                    if (info.getIcon() != null) {
                        panel2.icon(info.getIcon());
                    }
                    for (EditorNotificationInfo.ActionLabelData actionLabelData : info.getLabelAndActions()) {
                        Runnable onClickAction = () -> {
                            actionLabelData.action.run();
                            EditorNotifications.getInstance((Project)project).updateAllNotifications();
                        };
                        panel2.createActionLabel(actionLabelData.label, onClickAction);
                    }
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        file2.putUserData(DETECT_INDENT_NOTIFICATION_SHOWN_KEY, (Object)Boolean.TRUE);
                    }
                    return panel2;
                }
            }
        }
        return null;
    }

    public static void updateIndentNotification(@NotNull PsiFile file2, boolean enforce) {
        VirtualFile vFile;
        if (file2 == null) {
            DetectedIndentOptionsNotificationProvider.$$$reportNull$$$0(3);
        }
        if ((vFile = file2.getVirtualFile()) == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() && myShowNotificationInTest) {
            Boolean notifiedFlag;
            Project project = file2.getProject();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            if (fileEditorManager == null) {
                return;
            }
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(vFile);
            if (fileEditor != null && ((notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG)) == null || enforce)) {
                fileEditor.putUserData(NOTIFIED_FLAG, (Object)Boolean.TRUE);
                EditorNotifications.getInstance((Project)project).updateNotifications(vFile);
            }
        }
    }

    public static void setShowNotificationInTest(boolean show) {
        myShowNotificationInTest = show;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateIndentNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

