/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

final class BreadcrumbsConfigurable
implements Configurable {
    private final TreeMap<String, JCheckBox> map = new TreeMap();
    private JComponent component;
    private JCheckBox show;
    private JRadioButton above;
    private JRadioButton below;
    private JLabel placement;
    private JLabel languages;

    BreadcrumbsConfigurable() {
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"configurable.breadcrumbs", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.editor.general.breadcrumbs";
    }

    public JComponent createComponent() {
        if (this.component == null) {
            for (BreadcrumbsProvider provider : (BreadcrumbsProvider[])BreadcrumbsProvider.EP_NAME.getExtensions()) {
                for (Language language : provider.getLanguages()) {
                    String id = language.getID();
                    if (this.map.containsKey(id)) continue;
                    this.map.put(id, new JCheckBox(language.getDisplayName()));
                }
            }
            JPanel boxes = new JPanel(new GridLayout(0, 3));
            for (JCheckBox box : this.map.values()) {
                boxes.add(box);
            }
            this.show = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.breadcrumbs", (Object[])new Object[0]));
            this.show.addItemListener(event -> this.updateEnabled());
            this.above = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.above", (Object[])new Object[0]));
            this.below = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.below", (Object[])new Object[0]));
            ButtonGroup group = new ButtonGroup();
            group.add(this.above);
            group.add(this.below);
            this.placement = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.placement", (Object[])new Object[0]));
            this.placement.setBorder((Border)JBUI.Borders.emptyRight((int)12));
            JPanel placementPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
            placementPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)24));
            placementPanel.add(this.placement);
            placementPanel.add(this.above);
            placementPanel.add(this.below);
            this.languages = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.languages", (Object[])new Object[0]));
            JPanel languagesPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
            languagesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)24, (int)12, (int)0));
            languagesPanel.add(this.languages);
            languagesPanel.add(boxes);
            this.component = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)12), 2));
            this.component.add(this.show);
            this.component.add(placementPanel);
            this.component.add(languagesPanel);
            this.component.add((Component)LinkLabel.create((String)ApplicationBundle.message((String)"configure.breadcrumbs.colors", (Object[])new Object[0]), () -> {
                DataContext context = DataManager.getInstance().getDataContext((Component)this.component);
                ColorAndFontOptions.selectOrEditColor(context, "Breadcrumbs//Current", GeneralColorsPage.class);
            }));
        }
        return this.component;
    }

    public void reset() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        this.setBreadcrumbsAbove(settings.isBreadcrumbsAbove());
        this.setBreadcrumbsShown(settings.isBreadcrumbsShown());
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            entry.getValue().setSelected(settings.isBreadcrumbsShownFor(entry.getKey()));
        }
        this.updateEnabled();
    }

    public boolean isModified() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (this.isBreadcrumbsAbove() != settings.isBreadcrumbsAbove()) {
            return true;
        }
        if (this.isBreadcrumbsShown() != settings.isBreadcrumbsShown()) {
            return true;
        }
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            if (settings.isBreadcrumbsShownFor(entry.getKey()) == entry.getValue().isSelected()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        boolean modified = false;
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings.setBreadcrumbsAbove(this.isBreadcrumbsAbove())) {
            modified = true;
        }
        if (settings.setBreadcrumbsShown(this.isBreadcrumbsShown())) {
            modified = true;
        }
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            if (!settings.setBreadcrumbsShownFor(entry.getKey(), entry.getValue().isSelected())) continue;
            modified = true;
        }
        if (modified) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private boolean isBreadcrumbsAbove() {
        return this.above != null && this.above.isSelected();
    }

    private void setBreadcrumbsAbove(boolean value) {
        JRadioButton button;
        JRadioButton jRadioButton = button = value ? this.above : this.below;
        if (button != null) {
            button.setSelected(true);
        }
    }

    private boolean isBreadcrumbsShown() {
        return this.show != null && this.show.isSelected();
    }

    private void setBreadcrumbsShown(boolean value) {
        if (this.show != null) {
            this.show.setSelected(value);
        }
    }

    private void updateEnabled() {
        boolean enabled = this.isBreadcrumbsShown();
        if (this.above != null) {
            this.above.setEnabled(enabled);
        }
        if (this.below != null) {
            this.below.setEnabled(enabled);
        }
        if (this.placement != null) {
            this.placement.setEnabled(enabled);
        }
        if (this.languages != null) {
            this.languages.setEnabled(enabled);
        }
        for (JCheckBox box : this.map.values()) {
            box.setEnabled(enabled);
        }
    }
}

