/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import java.awt.Dimension;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.ZoomOptions;
import org.jdom.Element;

final class ZoomOptionsImpl
implements ZoomOptions,
JDOMExternalizable {
    private boolean wheelZooming = true;
    private boolean smartZooming = true;
    private int prefferedWidth;
    private int prefferedHeight;
    private final PropertyChangeSupport propertyChangeSupport;

    ZoomOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.prefferedWidth = ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.width;
        this.prefferedHeight = ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.height;
        this.propertyChangeSupport = propertyChangeSupport;
    }

    @Override
    public boolean isWheelZooming() {
        return this.wheelZooming;
    }

    @Override
    public boolean isSmartZooming() {
        return this.smartZooming;
    }

    @Override
    public Dimension getPrefferedSize() {
        return new Dimension(this.prefferedWidth, this.prefferedHeight);
    }

    void setWheelZooming(boolean wheelZooming) {
        boolean oldValue = this.wheelZooming;
        if (oldValue != wheelZooming) {
            this.wheelZooming = wheelZooming;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.wheelZooming", oldValue, this.wheelZooming);
        }
    }

    void setSmartZooming(boolean smartZooming) {
        boolean oldValue = this.smartZooming;
        if (oldValue != smartZooming) {
            this.smartZooming = smartZooming;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.smartZooming", oldValue, this.smartZooming);
        }
    }

    void setPrefferedSize(Dimension prefferedSize) {
        if (prefferedSize == null) {
            prefferedSize = DEFAULT_PREFFERED_SIZE;
        }
        this.setPrefferedWidth(prefferedSize.width);
        this.setPrefferedHeight(prefferedSize.height);
    }

    void setPrefferedWidth(int prefferedWidth) {
        int oldValue = this.prefferedWidth;
        if (oldValue != prefferedWidth) {
            this.prefferedWidth = prefferedWidth;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.prefferedWidth", oldValue, this.prefferedWidth);
        }
    }

    void setPrefferedHeight(int prefferedHeight) {
        int oldValue = this.prefferedHeight;
        if (oldValue != prefferedHeight) {
            this.prefferedHeight = prefferedHeight;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.prefferedHeight", oldValue, this.prefferedHeight);
        }
    }

    @Override
    public void inject(ZoomOptions options) {
        this.setWheelZooming(options.isWheelZooming());
        this.setSmartZooming(options.isSmartZooming());
        this.setPrefferedSize(options.getPrefferedSize());
    }

    @Override
    public boolean setOption(String name, Object value) {
        if ("Editor.Zoom.wheelZooming".equals(name)) {
            this.setWheelZooming((Boolean)value);
        } else if ("Editor.Zoom.smartZooming".equals(name)) {
            this.setSmartZooming((Boolean)value);
        } else if ("Editor.Zoom.prefferedWidth".equals(name)) {
            this.setPrefferedWidth((Integer)value);
        } else if ("Editor.Zoom.prefferedHeight".equals(name)) {
            this.setPrefferedHeight((Integer)value);
        } else {
            return false;
        }
        return true;
    }

    public void readExternal(Element element) {
        this.setWheelZooming(JDOMExternalizer.readBoolean((Element)element, (String)"Editor.Zoom.wheelZooming"));
        this.setSmartZooming(JDOMExternalizer.readBoolean((Element)element, (String)"Editor.Zoom.smartZooming"));
        this.setPrefferedWidth(JDOMExternalizer.readInteger((Element)element, (String)"Editor.Zoom.prefferedWidth", (int)ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.width));
        this.setPrefferedHeight(JDOMExternalizer.readInteger((Element)element, (String)"Editor.Zoom.prefferedHeight", (int)ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.height));
    }

    public void writeExternal(Element element) {
        JDOMExternalizer.write((Element)element, (String)"Editor.Zoom.wheelZooming", (boolean)this.wheelZooming);
        JDOMExternalizer.write((Element)element, (String)"Editor.Zoom.smartZooming", (boolean)this.smartZooming);
        JDOMExternalizer.write((Element)element, (String)"Editor.Zoom.prefferedWidth", (int)this.prefferedWidth);
        JDOMExternalizer.write((Element)element, (String)"Editor.Zoom.prefferedHeight", (int)this.prefferedHeight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZoomOptions)) {
            return false;
        }
        ZoomOptions otherOptions = (ZoomOptions)obj;
        Dimension prefferedSize = otherOptions.getPrefferedSize();
        return prefferedSize != null && this.prefferedHeight == prefferedSize.height && this.prefferedWidth == prefferedSize.width && this.smartZooming == otherOptions.isSmartZooming() && this.wheelZooming == otherOptions.isWheelZooming();
    }

    public int hashCode() {
        int result2 = this.wheelZooming ? 1 : 0;
        result2 = 29 * result2 + (this.smartZooming ? 1 : 0);
        result2 = 29 * result2 + this.prefferedWidth;
        result2 = 29 * result2 + this.prefferedHeight;
        return result2;
    }
}

