/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;

public class AuthLevel {
    public static final AuthLevel ANY = new AuthLevel(null, null);
    public static final AuthLevel TOKEN = new AuthLevel(null, GithubAuthData.AuthType.TOKEN);
    public static final AuthLevel BASIC = new AuthLevel(null, GithubAuthData.AuthType.BASIC);
    public static final AuthLevel LOGGED = new AuthLevel(null, null){

        @Override
        public boolean accepts(@NotNull GithubAuthData auth) {
            if (auth == null) {
                1.$$$reportNull$$$0(0);
            }
            return auth.getAuthType() != GithubAuthData.AuthType.ANONYMOUS;
        }

        @Override
        public String toString() {
            return "Not anonymous";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/AuthLevel$1", "accepts"));
        }
    };
    @Nullable
    private final String myHost;
    @Nullable
    private final GithubAuthData.AuthType myAuthType;

    @NotNull
    public static AuthLevel basicOnetime(@NotNull String host) {
        if (host == null) {
            AuthLevel.$$$reportNull$$$0(0);
        }
        AuthLevel authLevel = new AuthLevel(host, GithubAuthData.AuthType.BASIC){

            @Override
            public boolean isOnetime() {
                return true;
            }
        };
        if (authLevel == null) {
            AuthLevel.$$$reportNull$$$0(1);
        }
        return authLevel;
    }

    private AuthLevel(@Nullable String host, @Nullable GithubAuthData.AuthType authType) {
        this.myHost = host;
        this.myAuthType = authType;
    }

    @Nullable
    public String getHost() {
        return this.myHost;
    }

    @Nullable
    public GithubAuthData.AuthType getAuthType() {
        return this.myAuthType;
    }

    public boolean accepts(@NotNull GithubAuthData auth) {
        if (auth == null) {
            AuthLevel.$$$reportNull$$$0(2);
        }
        if (this.myHost != null && !this.myHost.equals(auth.getHost())) {
            return false;
        }
        return this.myAuthType == null || this.myAuthType.equals((Object)auth.getAuthType());
    }

    public boolean isOnetime() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authType", (Object)this.myAuthType).add("host", (Object)this.myHost).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/AuthLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auth";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/AuthLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "basicOnetime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "basicOnetime";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

