/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.configurable.VcsManagerConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.GeneralSettingsPanel;
import org.jetbrains.idea.svn.NetworkSettingsPanel;
import org.jetbrains.idea.svn.PresentationSettingsPanel;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.dialogs.SshSettingsPanel;

public abstract class SvnConfigurable
extends ConfigurableBase<ConfigurableUi<SvnConfiguration>, SvnConfiguration> {
    public static final String DISPLAY_NAME = "Subversion";
    public static final String ID = VcsManagerConfigurable.getVcsConfigurableId((String)"Subversion");
    @NonNls
    private static final String HELP_ID = "project.propSubversion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Supplier<? extends ConfigurableUi<SvnConfiguration>> myUiSupplier;

    protected SvnConfigurable(@NotNull Project project, @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier) {
        if (project == null) {
            SvnConfigurable.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            SvnConfigurable.$$$reportNull$$$0(1);
        }
        if (uiSupplier == null) {
            SvnConfigurable.$$$reportNull$$$0(2);
        }
        this(project, ID + "." + displayName, displayName, uiSupplier, "project.propSubversion." + displayName);
    }

    protected SvnConfigurable(@NotNull Project project, @NotNull String id, @NotNull String displayName, @NotNull Supplier<? extends ConfigurableUi<SvnConfiguration>> uiSupplier, @NotNull String helpId) {
        if (project == null) {
            SvnConfigurable.$$$reportNull$$$0(3);
        }
        if (id == null) {
            SvnConfigurable.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            SvnConfigurable.$$$reportNull$$$0(5);
        }
        if (uiSupplier == null) {
            SvnConfigurable.$$$reportNull$$$0(6);
        }
        if (helpId == null) {
            SvnConfigurable.$$$reportNull$$$0(7);
        }
        super(id, displayName, helpId);
        this.myProject = project;
        this.myUiSupplier = uiSupplier;
    }

    protected ConfigurableUi<SvnConfiguration> createUi() {
        return this.myUiSupplier.get();
    }

    @NotNull
    protected SvnConfiguration getSettings() {
        SvnConfiguration svnConfiguration = SvnConfiguration.getInstance(this.myProject);
        if (svnConfiguration == null) {
            SvnConfigurable.$$$reportNull$$$0(8);
        }
        return svnConfiguration;
    }

    public static void selectConfigurationDirectory(@NotNull String path, @NotNull Consumer<String> dirConsumer, Project project, @Nullable Component component) {
        if (path == null) {
            SvnConfigurable.$$$reportNull$$$0(9);
        }
        if (dirConsumer == null) {
            SvnConfigurable.$$$reportNull$$$0(10);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0])).withDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
        path = "file://" + path.replace(File.separatorChar, '/');
        VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(path);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component, (Project)project, (VirtualFile)root);
        if (file == null) {
            return;
        }
        String resultPath = file.getPath().replace('/', File.separatorChar);
        dirConsumer.consume((Object)resultPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnConfigurable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectConfigurationDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Ssh
    extends SvnConfigurable {
        public Ssh(@NotNull Project project) {
            if (project == null) {
                Ssh.$$$reportNull$$$0(0);
            }
            super(project, "SSH", () -> {
                if (project == null) {
                    Ssh.$$$reportNull$$$0(1);
                }
                return new SshSettingsPanel(project);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable$Ssh";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Network
    extends SvnConfigurable {
        public Network(@NotNull Project project) {
            if (project == null) {
                Network.$$$reportNull$$$0(0);
            }
            super(project, "Network", () -> {
                if (project == null) {
                    Network.$$$reportNull$$$0(1);
                }
                return new NetworkSettingsPanel(project);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable$Network";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Presentation
    extends SvnConfigurable {
        public Presentation(@NotNull Project project) {
            if (project == null) {
                Presentation.$$$reportNull$$$0(0);
            }
            super(project, "Presentation", () -> {
                if (project == null) {
                    Presentation.$$$reportNull$$$0(1);
                }
                return new PresentationSettingsPanel(project);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable$Presentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class General
    extends SvnConfigurable {
        public General(@NotNull Project project) {
            if (project == null) {
                General.$$$reportNull$$$0(0);
            }
            super(project, ID, SvnConfigurable.DISPLAY_NAME, () -> {
                if (project == null) {
                    General.$$$reportNull$$$0(1);
                }
                return new GeneralSettingsPanel(project);
            }, SvnConfigurable.HELP_ID);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/SvnConfigurable$General";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

