# coding=utf-8
from __future__ import unicode_literals


from .. import Provider as DateTimeProvider


class Provider(DateTimeProvider):
    DAY_NAMES = {
        '0': 'السبت',
        '1': 'الأحد',
        '2': 'الإثنين',
        '3': 'الثلاثاء',
        '4': 'الأربعاء',
        '5': 'الخميس',
        '6': 'الجمعة',
    }

    MONTH_NAMES = {
        '01': 'كانون الثّاني',
        '02': 'شباط',
        '03': 'آذار',
        '04': 'نيسان',
        '05': 'أيّار',
        '06': 'حزيران',
        '07': 'تمّوز',
        '08': 'آب',
        '09': 'أيلول',
        '10': 'تشرين الأول',
        '11': 'تشرين الثاني',
        '12': 'كانون الأول'
    }

    centuries = [
        'الأول', 'الثاني', 'الثالث', 'الرابع', 'الخامس', 'السادس',
        'السابع', 'الثامن', 'التاسع', 'العاشر', 'الحادي عشر',
        'الثاني عشر', 'الثالث عشر', 'الرابع عشر', 'الخامس عشر',
        'السادس عشر', 'الثامن عشر', 'التاسع عشر', 'العشرين',
        'الحادي والعشرين', 'الثاني والعشرين',
    ]

    countries = [
        {'timezones': ['أوروب/أندورا'], 'code': 'AD', 'continent': 'أوروبا', 'name': 'أندورا', 'capital': 'أندورا لا فيلا'},
        {'timezones': ['آسيا/كابل'], 'code': 'AF', 'continent': 'آسيا', 'name': 'أفغانستان', 'capital': 'كابل'},
        {'timezones': ['أمريكا/أنتيغوا'], 'code': 'AG', 'continent': 'أمريكا الشمالية', 'name': 'أنتيغوا وباربودا', 'capital': "سانت جونز"},
        {'timezones': ['أوروبا/تيرانا'], 'code': 'AL', 'continent': 'أوروبا', 'name': 'ألبانيا', 'capital': 'تيرانا'},
        {'timezones': ['آسيا/يريفان'], 'code': 'AM', 'continent': 'آسيا', 'name': 'أرمينيا', 'capital': 'يريفان'},
        {'timezones': ['إفريقيا/لواندا'], 'code': 'AO', 'continent': 'إفريقيا', 'name': 'أنغولا', 'capital': 'لواندا'},
        {'timezones': ['أمريكا/الأرجنتين/بوينس_آيرس', 'أمريكا/الأرجنتين/Cordoba', 'أمريكا/الأرجنتين/خوخوي', 'أمريكا/الأرجنتين/توكومان', 'أمريكا/الأرجنتين/كاتاماركا', 'أمريكا/الأرجنتين/لا_ريوخا', 'أمريكا/الأرجنتين/سان_خوان', 'أمريكا/الأرجنتين/مندوزا', 'أمريكا/الأرجنتين/ريو_غاليغوس', 'أمريكا/الأرجنتين/أوشوايا'], 'code': 'AR', 'continent': 'أمريكا الجنوبية', 'name': 'الأرجنتين', 'capital': 'بوينس آيرس'},
        {'timezones': ['أوروبا/النمسا'], 'code': 'AT', 'continent': 'أوروبا', 'name': 'النمسا', 'capital': 'فيينا'},
        {'timezones': ['أستراليا/لورد_هاو', 'أستراليا/هوبارت', 'أستراليا/كري', 'أستراليا/ملبورن', 'أستراليا/سدني', 'أستراليا/بروكن_هل', 'أستراليا/بريزبن', 'أستراليا/ليندمان', 'أستراليا/أديلايد', 'أستراليا/داروين', 'أستراليا/برث'], 'code': 'AU', 'continent': 'أوقيانوسيا', 'name': 'أستراليا', 'capital': 'كانبرا'},
        {'timezones': ['آسيا/باكو'], 'code': 'AZ', 'continent': 'آسيا', 'name': 'أذربيجان', 'capital': 'باكو'},
        {'timezones': ['أمريكا/باربادوس'], 'code': 'BB', 'continent': 'أمريكا الشمالية', 'name': 'باربادوس', 'capital': 'بريدج تاون'},
        {'timezones': ['آسيا/دكا'], 'code': 'BD', 'continent': 'آسيا', 'name': 'بنغلادش', 'capital': 'دكا'},
        {'timezones': ['أوروبا/بروكسل'], 'code': 'BE', 'continent': 'أوروبا', 'name': 'بلجيكا', 'capital': 'بروكسل'},
        {'timezones': ['إفريقيا/واغادوغو'], 'code': 'BF', 'continent': 'إفريقيا', 'name': 'بوركينا فاسو', 'capital': 'واغادوغو'},
        {'timezones': ['أوروبا/صوفيا'], 'code': 'BG', 'continent': 'أوروبا', 'name': 'بلغاريا', 'capital': 'صوفيا'},
        {'timezones': ['آسيا/البحرين'], 'code': 'BH', 'continent': 'آسيا', 'name': 'البحرين', 'capital': 'المنامة'},
        {'timezones': ['إفريقيا/بوجمبورا'], 'code': 'BI', 'continent': 'إفريقيا', 'name': 'بوروندي', 'capital': 'بوجمبورا'},
        {'timezones': ['إفريقيا/بورتو نوفو'], 'code': 'BJ', 'continent': 'إفريقيا', 'name': 'بنين', 'capital': 'بورتو نوفو'},
        {'timezones': ['آسيا/بروناي'], 'code': 'BN', 'continent': 'آسيا', 'name': 'اتحاد بروناي (دار السلام)', 'capital': 'بندر سري بكاوان'},
        {'timezones': ['أمريكا/لاباز'], 'code': 'BO', 'continent': 'أمريكا الجنوبية', 'name': 'بوليفيا', 'capital': 'سوكري'},
        {'timezones': ['أمريكا/نورونها', 'أمريكا/بليم','أمريكا/فورتاليزا', 'أمريكا/ريسيفي', 'أمريكا/أراغوينا', 'أمريكا/ماسايو', 'أمريكا/باهيا', 'أمريكا/ساو_باولو', 'أمريكا/كامبو_غراندي', 'أمريكا/كويابا', 'أمريكا/بورتو_فاليو', 'أمريكا/بوا_فيستا', 'أمريكا/ماناوس', 'أمريكا/إيرونيبي', 'أمريكا/ريو_برانكو'], 'code': 'BR', 'continent': 'أمريكا الجنوبية', 'name': 'البرازيل', 'capital': 'برازيليا'},
        {'timezones': ['أمريكا/ناساو'], 'code': 'BS', 'continent': 'أمريكا الشمالية', 'name': 'باهاماس', 'capital': 'ناساو'},
        {'timezones': ['آسيا/تيمفو'], 'code': 'BT', 'continent': 'آسيا', 'name': 'بوتان', 'capital': 'تيمفو'},
        {'timezones': ['إفريقيا/غابورون'], 'code': 'BW', 'continent': 'إفريقيا', 'name': 'بوتسوانا', 'capital': 'غابورون'},
        {'timezones': ['أوروبا/مينسك'], 'code': 'BY', 'continent': 'أوروبا', 'name': 'روسيا البيضاء', 'capital': 'مينسك'},
        {'timezones': ['أمريكا/بليز'], 'code': 'BZ', 'continent': 'أمريكا الشمالية', 'name': 'بليز', 'capital': 'بلموبان'},
        {'timezones': ['أمريكا/سينت_جونز', 'أمريكا/هاليفاكس', 'أمريكا/جليس_باي', 'أمريكا/مونكتون', 'أمريكا/جووس_باي', 'أمريكا/بلانك_سابلون', 'أمريكا/مونتريال', 'أمريكا/تورونتو', 'أمريكا/نيبيغون', 'أمريكا/ثاندر_باي', 'أمريكا/بانغيرتانغ', 'أمريكا/إيكواليوت', 'أمريكا/أتيكوكان', 'أمريكا/رانكن_إنلت', 'أمريكا/وينيبيغ', 'أمريكا/رايني_ريفر', 'أمريكا/كامبريدج_باي', 'أمريكا/ريجينا', 'أمريكا/سويفت_كارنت', 'أمريكا/إدمونتون', 'أمريكا/يلو_نايف', 'أمريكا/إنوفك', 'أمريكا/دوسن_كريك', 'أمريكا/فانكوفر', 'أمريكا/وايت_هورس', 'أمريكا/داوسون'], 'code': 'CA', 'continent': 'أمريكا الشمالية', 'name': 'كندا', 'capital': 'أوتاوا'},
        {'timezones': ['إفريقيا/كينشاسا', 'إفريقيا/لوبومباشي'], 'code': 'CD', 'continent': 'إفريقيا', 'name': 'جمهورية الكونغو الديمقراطية', 'capital': 'كينشاسا'},
        {'timezones': ['إفريقيا/برازافيل'], 'code': 'CG', 'continent': 'إفريقيا', 'name': 'جمهورية الكونغو', 'capital': 'برازافيل'},
        {'timezones': ['إفريقيا/أبيدجان'], 'code': 'CI', 'continent': 'إفريقيا', 'name': "ساحل العاج", 'capital': 'ياموسوكرو'},
        {'timezones': ['أمريكا/سانتياغو', 'المحيط_الهاديء/جزيرة_القيامة'], 'code': 'CL', 'continent': 'أمريكا الجنوبية', 'name': 'تشيلي', 'capital': 'سانتياغو'},
        {'timezones': ['إفريقيا/دوالا'], 'code': 'CM', 'continent': 'إفريقيا', 'name': 'الكاميرون', 'capital': 'ياوندي'},
        {'timezones': ['آسيا/شانغهاي', 'آسيا/هاربن', 'آسيا/تشونغتشينغ', 'آسيا/أورومتشي', 'آسيا/كاشغر'], 'code': 'CN', 'continent': 'آسيا', 'name': "جمهورية الصين الشعبية", 'capital': 'بكين'},
        {'timezones': ['أمريكا/بوغوتا'], 'code': 'CO', 'continent': 'أمريكا الجنوبية', 'name': 'كولومبيا', 'capital': 'بوغوتا'},
        {'timezones': ['أمريكا/كوستاريكا'], 'code': 'CR', 'continent': 'أمريكا الشمالية', 'name': 'كوستاريكا', 'capital': 'سان خوسيه'},
        {'timezones': ['أمريكا/هافانا'], 'code': 'CU', 'continent': 'أمريكا الشمالية', 'name': 'كوبا', 'capital': 'هافانا'},
        {'timezones': ['الأطلنطي/الرأس_الأخضر'], 'code': 'CV', 'continent': 'إفريقيا', 'name': 'جمهورية الرأس الأخضر', 'capital': 'برايا'},
        {'timezones': ['آسيا/نيقوسيا'], 'code': 'CY', 'continent': 'آسيا', 'name': 'قبرص', 'capital': 'نيقوسيا'},
        {'timezones': ['أوروبا/براغ'], 'code': 'CZ', 'continent': 'أوروبا', 'name': 'جمهورية التشيك', 'capital': 'براغ'},
        {'timezones': ['أوروبا/برلين'], 'code': 'DE', 'continent': 'أوروبا', 'name': 'ألمانيا', 'capital': 'برلين'},
        {'timezones': ['إفريقيا/جيبوتي'], 'code': 'DJ', 'continent': 'إفريقيا', 'name': 'جيبوتي', 'capital': 'جيبوتي'},
        {'timezones': ['أوروبا/كوبنهاغن'], 'code': 'DK', 'continent': 'أوروبا', 'name': 'الدنمارك', 'capital': 'كوبنهاغن'},
        {'timezones': ['أمريكا/دومينيكا'], 'code': 'DM', 'continent': 'أمريكا الشمالية', 'name': 'دومينيكا', 'capital': 'روسياو'},
        {'timezones': ['أمريكا/سانتو_دومينغو'], 'code': 'DO', 'continent': 'أمريكا الشمالية', 'name': 'جمهورية الدومينيكان', 'capital': 'سانتو دومينغو'},
        {'timezones': ['أمريكا/غواياكيل', 'المحيط_الهاديء/أرخبيل_غالاباغوس'], 'code': 'EC', 'continent': 'أمريكا الجنوبية', 'name': 'الإكوادور', 'capital': 'كيتو'},
        {'timezones': ['أوروبا/تالين'], 'code': 'EE', 'continent': 'أوروبا', 'name': 'إستونيا', 'capital': 'تالين'},
        {'timezones': ['إفريقيا/القاهرة'], 'code': 'EG', 'continent': 'إفريقيا', 'name': 'مصر', 'capital': 'القاهرة'},
        {'timezones': ['إفريقيا/أسمرة'], 'code': 'ER', 'continent': 'إفريقيا', 'name': 'إرتيريا', 'capital': 'أسمرة'},
        {'timezones': ['إفريقيا/أديس أبابا'], 'code': 'ET', 'continent': 'إفريقيا', 'name': 'إثيوبيا', 'capital': 'أديس أبابا'},
        {'timezones': ['أوروبا/هلسنكي'], 'code': 'FI', 'continent': 'أوروبا', 'name': 'فنلندا', 'capital': 'هلسنكي'},
        {'timezones': ['المحيط_الهاديء/فيجي'], 'code': 'FJ', 'continent': 'أوقيانوسيا', 'name': 'فيجي', 'capital': 'سوفا'},
        {'timezones': ['أوروبا/باريس'], 'code': 'FR', 'continent': 'أوروبا', 'name': 'فرنسا', 'capital': 'باريس'},
        {'timezones': ['إفريقيا/ليبرفيل'], 'code': 'GA', 'continent': 'إفريقيا', 'name': 'الغابون', 'capital': 'ليبرفيل'},
        {'timezones': ['آسيا/تبليسي'], 'code': 'GE', 'continent': 'آسيا', 'name': 'جورجيا', 'capital': 'تبليسي'},
        {'timezones': ['إفريقيا/أكرا'], 'code': 'GH', 'continent': 'إفريقيا', 'name': 'غانا', 'capital': 'أكرا'},
        {'timezones': ['إفريقيا/بانجول'], 'code': 'GM', 'continent': 'إفريقيا', 'name': 'غامبيا', 'capital': 'بانجول'},
        {'timezones': ['إفريقيا/كوناكري'], 'code': 'GN', 'continent': 'إفريقيا', 'name': 'غينيا', 'capital': 'كوناكري'},
        {'timezones': ['أوروبا/أثينا'], 'code': 'GR', 'continent': 'أوروبا', 'name': 'اليونان', 'capital': 'أثينا'},
        {'timezones': ['أمريكا/غواتيمالا'], 'code': 'GT', 'continent': 'أمريكا الشمالية', 'name': 'غواتيمالا', 'capital': 'غواتيمالا سيتي'},
        {'timezones': ['أمريكا/غواتيمالا'], 'code': 'GT', 'continent': 'أمريكا الشمالية', 'name': 'هايتي', 'capital': 'بورت أو برانس'},
        {'timezones': ['إفريقيا/بيساو'], 'code': 'GW', 'continent': 'إفريقيا', 'name': 'غينيا بيساو', 'capital': 'بيساو'},
        {'timezones': ['أمريكا/غيانا'], 'code': 'GY', 'continent': 'أمريكا الجنوبية', 'name': 'غيانا', 'capital': 'جورج تاون'},
        {'timezones': ['أمريكا/تيجوسيجالبا'], 'code': 'HN', 'continent': 'أمريكا الشمالية', 'name': 'هندوراس', 'capital': 'تيجوسيجالبا'},
        {'timezones': ['أوروبا/بودابست'], 'code': 'HU', 'continent': 'أوروبا', 'name': 'هنغاريا', 'capital': 'بودابست'},
        {'timezones': ['آسيا/جاكرتا', 'آسيا/بونتياناك', 'آسيا/ماكاسار', 'آسيا/جايابورا'], 'code': 'ID', 'continent': 'آسيا', 'name': 'إندونسيا', 'capital': 'جاكرتا'},
        {'timezones': ['أوروبا/دبلن'], 'code': 'IE', 'continent': 'أوروبا', 'name': 'إيرلندا', 'capital': 'دبلن'},
        {'timezones': ['آسيا/القدس'], 'code': 'IL', 'continent': 'آسيا', 'name': 'فلسطين', 'capital': 'القدس'},
        {'timezones': ['آسيا/كالكتا'], 'code': 'IN', 'continent': 'آسيا', 'name': 'الهند', 'capital': 'نيو دلهي'},
        {'timezones': ['آسيا/بغداد'], 'code': 'IQ', 'continent': 'آسيا', 'name': 'العراق', 'capital': 'بغداد'},
        {'timezones': ['آسيا/طهران'], 'code': 'IR', 'continent': 'آسيا', 'name': 'إيران', 'capital': 'طهران'},
        {'timezones': ['الأطلنطي/ريكيافيك'], 'code': 'IS', 'continent': 'أوروبا', 'name': 'آيسلندا', 'capital': 'ريكيافيك'},
        {'timezones': ['أوروبا/روما'], 'code': 'IT', 'continent': 'أوروبا', 'name': 'إيطاليا', 'capital': 'روما'},
        {'timezones': ['أمريكا/جامايكا'], 'code': 'JM', 'continent': 'أمريكا الشمالية', 'name': 'جامايكا', 'capital': 'كينغستون'},
        {'timezones': ['آسيا/عمّان'], 'code': 'JO', 'continent': 'آسيا', 'name': 'الأردن', 'capital': 'عمّان'},
        {'timezones': ['آسيا/طوكيو'], 'code': 'JP', 'continent': 'آسيا', 'name': 'اليابان', 'capital': 'طوكيو'},
        {'timezones': ['إفريقيا/نيروبي'], 'code': 'KE', 'continent': 'إفريقيا', 'name': 'كينيا', 'capital': 'نيروبي'},
        {'timezones': ['آسيا/بشكيك'], 'code': 'KG', 'continent': 'آسيا', 'name': 'قيرغيزستان', 'capital': 'بشكيك'},
        {'timezones': ['المحيط_الهاديء/تاراوا', 'المحيط_الهاديء/إيديربيري', 'المحيط_الهاديء/كريتيماتي'], 'code': 'KI', 'continent': 'أوقيانوسيا', 'name': 'كيريباتي', 'capital': 'جنوب تاراوا'},
        {'timezones': ['آسيا/بيونغ_يانغ'], 'code': 'KP', 'continent': 'آسيا', 'name': 'كوريا الشمالية', 'capital': 'بيونغ يانغ'},
        {'timezones': ['آسيا/سيؤول'], 'code': 'KR', 'continent': 'آسيا', 'name': '؛كوريا الجنوبية', 'capital': 'سيؤول'},
        {'timezones': ['آسيا/الكويت'], 'code': 'KW', 'continent': 'آسيا', 'name': 'الكويت', 'capital': 'الكويت'},
        {'timezones': ['آسيا/بيروت'], 'code': 'LB', 'continent': 'آسيا', 'name': 'لبنان', 'capital': 'بيروت'},
        {'timezones': ['أوروبا/فادوز'], 'code': 'LI', 'continent': 'أوروبا', 'name': 'ليختنشتاين', 'capital': 'فادوز'},
        {'timezones': ['إفريقيا/مونروفيا'], 'code': 'LR', 'continent': 'إفريقيا', 'name': 'ليبيريا', 'capital': 'مونروفيا'},
        {'timezones': ['إفريقيا/ماسيرو'], 'code': 'LS', 'continent': 'إفريقيا', 'name': 'ليسوتو', 'capital': 'ماسيرو'},
        {'timezones': ['أوروبا/فيلنيوس'], 'code': 'LT', 'continent': 'أوروبا', 'name': 'ليتوانيا', 'capital': 'فيلنيوس'},
        {'timezones': ['أوروبا/لوكسمبرغ'], 'code': 'LU', 'continent': 'أوروبا', 'name': 'لوكسمبرغ', 'capital': 'لوكسمبرغ سيتي'},
        {'timezones': ['أوروبا/ربيغ'], 'code': 'LV', 'continent': 'أوروبا', 'name': 'لاتفيا', 'capital': 'ربيغ'},
        {'timezones': ['إفريقيا/طرابلس'], 'code': 'LY', 'continent': 'إفريقيا', 'name': 'ليبيا', 'capital': 'طرابلس'},
        {'timezones': ['الهندي/أنتاناناريفو'], 'code': 'MG', 'continent': 'إفريقيا', 'name': 'مدغشقر', 'capital': 'أنتاناناريفو'},
        {'timezones': ['المحيط_الهاديء/ماجورو', 'المحيط_الهاديء/كواجلين_أتول'], 'code': 'MH', 'continent': 'أوقيانوسيا', 'name': 'جزر مارشال', 'capital': 'ماجورو'},
        {'timezones': ['أوروبا/سكوبيه'], 'code': 'MK', 'continent': 'أوروبا', 'name': 'جمهورية مقدونيا', 'capital': 'سكوبيه'},
        {'timezones': ['إفريقيا/باماكو'], 'code': 'ML', 'continent': 'إفريقيا', 'name': 'مالي', 'capital': 'باماكو'},
        {'timezones': ['آسيا/رانغون'], 'code': 'MM', 'continent': 'آسيا', 'name': 'ميانمار', 'capital': 'نايبيداو'},
        {'timezones': ['آسيا/أولان_باتور', 'آسيا/Hovd', 'آسيا/تشويبالسان'], 'code': 'MN', 'continent': 'آسيا', 'name': 'مانغوليا', 'capital': 'أولان باتور'},
        {'timezones': ['إفريقيا/نواكشط'], 'code': 'MR', 'continent': 'إفريقيا', 'name': 'موريتانيا', 'capital': 'نواكشط'},
        {'timezones': ['أوروبا/مالطا'], 'code': 'MT', 'continent': 'أوروبا', 'name': 'مالطا', 'capital': 'فاليتا'},
        {'timezones': ['الهندي/موريشيوس'], 'code': 'MU', 'continent': 'إفريقيا', 'name': 'موريشيوس', 'capital': 'بور لويس'},
        {'timezones': ['الهندي/جزر_المالديف'], 'code': 'MV', 'continent': 'آسيا', 'name': 'جمهورية المالديف', 'capital': 'ماليه'},
        {'timezones': ['إفريقيا/بلانتاير'], 'code': 'MW', 'continent': 'إفريقيا', 'name': 'ملاوي', 'capital': 'ليلونغوي'},
        {'timezones': ['أمريكا/ميكسيكو_سيتي', 'أمريكا/كانكون', 'أمريكا/ميرديا', 'أمريكا/مونتيري', 'أمريكا/مازاتلان', 'أمريكا/شيواوا', 'أمريكا/ارموسييو_سونورا', 'أمريكا/تيخوانا'], 'code': 'MX', 'continent': 'أمريكا الشمالية', 'name': 'المكسيك', 'capital': 'ميكسيكو سيتي§'},
        {'timezones': ['آسيا/كوالا_لامبور', 'آسيا/Kuching'], 'code': 'MY', 'continent': 'آسيا', 'name': 'ماليزيا', 'capital': 'كوالا لامبور'},
        {'timezones': ['إفريقيا/مابوتو'], 'code': 'MZ', 'continent': 'إفريقيا', 'name': 'موزمبيق', 'capital': 'مابوتو'},
        {'timezones': ['إفريقيا/ويندهوك'], 'code': 'NA', 'continent': 'إفريقيا', 'name': 'ناميبيا', 'capital': 'ويندهوك'},
        {'timezones': ['إفريقيا/نيامي'], 'code': 'NE', 'continent': 'إفريقيا', 'name': 'النيجر', 'capital': 'نيامي'},
        {'timezones': ['إفريقيا/لاغوس'], 'code': 'NG', 'continent': 'إفريقيا', 'name': 'نيجيريا', 'capital': 'أبوجا'},
        {'timezones': ['أمريكا/ماناغوا'], 'code': 'NI', 'continent': 'أمريكا الشمالية', 'name': 'نيكاراغوا', 'capital': 'ماناغوا'},
        {'timezones': ['أوروبا/أمستردام'], 'code': 'NL', 'continent': 'أوروبا', 'name': 'هولندا', 'capital': 'أمستردام'},
        {'timezones': ['أوروبا/أوسلو'], 'code': 'NO', 'continent': 'أوروبا', 'name': 'النرويج', 'capital': 'أوسلو'},
        {'timezones': ['آسيا/كاتماندو'], 'code': 'NP', 'continent': 'آسيا', 'name': 'النيبال', 'capital': 'كاتماندو'},
        {'timezones': ['المحيط_الهاديء/ناورو'], 'code': 'NR', 'continent': 'أوقيانوسيا', 'name': 'ناورو', 'capital': 'يارين'},
        {'timezones': ['المحيط_الهاديء/أوكلاند', 'المحيط_الهاديء/تشاتهام'], 'code': 'NZ', 'continent': 'أوقيانوسيا', 'name': 'نيوزيلاندا', 'capital': 'ويلينغتون'},
        {'timezones': ['آسيا/مسقط'], 'code': 'OM', 'continent': 'آسيا', 'name': 'عمان', 'capital': 'مسقط'},
        {'timezones': ['أمريكا/بنما'], 'code': 'PA', 'continent': 'أمريكا الشمالية', 'name': 'بنما', 'capital': 'بنما'},
        {'timezones': ['أمريكا/ليما'], 'code': 'PE', 'continent': 'أمريكا الجنوبية', 'name': 'البيرو', 'capital': 'ليما'},
        {'timezones': ['المحيط_الهاديء/بورت_مورسبي'], 'code': 'PG', 'continent': 'أوقيانوسيا', 'name': 'بابوا غينيا الجديدة', 'capital': 'بورت مورسبي'},
        {'timezones': ['آسيا/مانيلا'], 'code': 'PH', 'continent': 'آسيا', 'name': 'الفيليبين', 'capital': 'مانيلا'},
        {'timezones': ['آسيا/كاراتشي'], 'code': 'PK', 'continent': 'آسيا', 'name': 'باكستان', 'capital': 'إسلام أباد'},
        {'timezones': ['أوروبا/وارسو'], 'code': 'PL', 'continent': 'أوروبا', 'name': 'بولندا', 'capital': 'وارسو'},
        {'timezones': ['أوروبا/لشبونة', 'الأطلنطي/ماديرا', 'الأطلنطي/الأزور'], 'code': 'PT', 'continent': 'أوروبا', 'name': 'البرتغال', 'capital': 'لشبونة'},
        {'timezones': ['المحيط_الهاديء/بالاو'], 'code': 'PW', 'continent': 'أوقيانوسيا', 'name': 'بالاو', 'capital': 'نجيرولمد'},
        {'timezones': ['أمريكا/أسونسيون'], 'code': 'PY', 'continent': 'أمريكا الجنوبية', 'name': 'بابرغوي', 'capital': 'أسونسيون'},
        {'timezones': ['آسيا/قطر'], 'code': 'QA', 'continent': 'آسيا', 'name': 'قطر', 'capital': 'الدوحة'},
        {'timezones': ['أوروبا/بوخارست'], 'code': 'RO', 'continent': 'أوروبا', 'name': 'رومانيا', 'capital': 'بوخارست'},
        {'timezones': ['أوروبا/كالينينغراد', 'أوروبا/موسكو', 'أوروبا/Volgograd', 'أوروبا/سمارة', 'آسيا/يكاترينبورغ', 'آسيا/أومسك', 'آسيا/نوفوسيبيرسك', 'آسيا/كراسنوياسك', 'آسيا/إروتسك', 'آسيا/ياكوتسك', 'آسيا/فالديفوستوك', 'آسيا/ساخالن', 'آسيا/ماغادان', 'آسيا/كامشتكا', 'آسيا/أنادير'], 'code': 'RU', 'continent': 'أوروبا', 'name': 'روسيا', 'capital': 'موسكو'},
        {'timezones': ['إفريقيا/كيغالي'], 'code': 'RW', 'continent': 'إفريقيا', 'name': 'رواندا', 'capital': 'كيغالي'},
        {'timezones': ['آسيا/الرياض'], 'code': 'SA', 'continent': 'آسيا', 'name': 'المملكة العربية السعودية', 'capital': 'الرياض'},
        {'timezones': ['المحيط_الهاديء/غوادالكانال'], 'code': 'SB', 'continent': 'أوقيانوسيا', 'name': 'جزر سولمون', 'capital': 'هونيارا'},
        {'timezones': ['الهندي/ماهي'], 'code': 'SC', 'continent': 'إفريقيا', 'name': 'سيشل', 'capital': 'فيكتوريا'},
        {'timezones': ['إفريقيا/الخرطوم'], 'code': 'SD', 'continent': 'إفريقيا', 'name': 'السودان', 'capital': 'الخرطوم'},
        {'timezones': ['أوروبا/ستوكهولم'], 'code': 'SE', 'continent':'أوروبا', 'name': 'السويد', 'capital': 'ستوكهولم'},
        {'timezones': ['آسيا/سنغافورة'], 'code': 'SG', 'continent': 'آسيا', 'name': 'سنغافورة', 'capital': 'سنغافورة'},
        {'timezones': ['أوروبا/ليوبليانا'], 'code': 'SI', 'continent': 'أوروبا', 'name': 'سلوفانيا', 'capital': 'ليوبليانا'},
        {'timezones': ['أوروبا/براتيسلافا'], 'code': 'SK', 'continent': 'أوروبا', 'name': 'سلوفاكيا', 'capital': 'براتيسلافا'},
        {'timezones': ['إفريقيا/فريتاون'], 'code': 'SL', 'continent': 'إفريقيا', 'name': 'سيراليون', 'capital': 'فريتاون'},
        {'timezones': ['أوروبا/سان_مارينو'], 'code': 'SM', 'continent': 'أوروبا', 'name': 'جمهورية سان مارينو', 'capital': 'سان مارينو'},
        {'timezones': ['إفريقيا/داكار'], 'code': 'SN', 'continent': 'إفريقيا', 'name': 'السنغال', 'capital': 'داكار'},
        {'timezones': ['إفريقيا/مقديشو'], 'code': 'SO', 'continent': 'إفريقيا', 'name': 'الصومال', 'capital': 'مقديشو'},
        {'timezones': ['أمريكا/باراماريبو'], 'code': 'SR', 'continent': 'أمريكا الجنوبية', 'name': 'Suriname', 'capital': 'باراماريبو'},
        {'timezones': ['إفريقيا/ساو_تومي'], 'code': 'ST', 'continent': 'إفريقيا', 'name': ' ساو تومي وبرينسيب', 'capital': 'ساو تومي'},
        {'timezones': ['آسيا/دممشق'], 'code': 'SY', 'continent': 'آسيا', 'name': 'سوريا', 'capital': 'دمشق'},
        {'timezones': ['إفريقيا/لومي'], 'code': 'TG', 'continent': 'إفريقيا', 'name': 'توغو', 'capital': 'لومي'},
        {'timezones': ['آسيا/بانغوك'], 'code': 'TH', 'continent': 'آسيا', 'name': 'تايلند', 'capital': 'بناغوك'},
        {'timezones': ['آسيا/دوشنبه'], 'code': 'TJ', 'continent': 'آسيا', 'name': 'طاجكيستان', 'capital': 'دوشنبه'},
        {'timezones': ['آسيا/عشق_آباد'], 'code': 'TM', 'continent': 'آسيا', 'name': 'تركمانستان', 'capital': 'عشق آباد'},
        {'timezones': ['إفريقيا/تونس'], 'code': 'TN', 'continent': 'إفريقيا', 'name': 'تونس', 'capital': 'تونس'},
        {'timezones': ['المحيط_الهاديء/تونغاتابو'], 'code': 'TO', 'continent': 'أوقيانوسيا', 'name': 'تونغا', 'capital': 'نوكو ألوفا'},
        {'timezones': ['أوروبا/إسطنبول'], 'code': 'TR', 'continent': 'آسيا', 'name': 'تركيا', 'capital': 'أنقرة'},
        {'timezones': ['أمريكا/بورت_أوف_سبين'], 'code': 'TT', 'continent': 'أمريكا الشمالية', 'name': 'ترينيداد وتوباغو', 'capital': 'بورت أوف سبين'},
        {'timezones': ['المحيط_الهاديء/فونافوتي'], 'code': 'TV', 'continent': 'أوقيانوسيا', 'name': 'توفالو', 'capital': 'فونافوتي'},
        {'timezones': ['إفريقيا/دار_السلام'], 'code': 'TZ', 'continent': 'إفريقيا', 'name': 'تانزانيا', 'capital': 'دودوما'},
        {'timezones': ['أوروبا/كييف', 'أوروبا/أوجهورود', 'أوروبا/زاباروجيا', 'أوروبا/سيمفروبول'], 'code': 'UA', 'continent': 'أوروبا', 'name': 'أوكرانيا', 'capital': 'كييف'},
        {'timezones': ['إفريقيا/كامبالا'], 'code': 'UG', 'continent': 'إفريقيا', 'name': 'أوغندا', 'capital': 'كامبالا'},
        {'timezones': ['أمريكا/نيويورك', 'أمريكا/ديترويت', 'أمريكا/كنتاكي/لويسفيل', 'أمريكا/كنتاكي/مونتيسللو', 'أمريكا/إنديانا/إنديانابولس', 'أمريكا/إنديانا/مارنغو', 'أمريكا/إنديانا/نوكس', 'أمريكا/إنديانا/فيفاي', 'أمريكا/شيكاغو', 'أمريكا/إنديانا/فانسان', 'أمريكا/إنديانا/بيترزبيرغ', 'أمريكا/مينومني', 'أمريكا/نورث_داكوتا/سينتر', 'أمريكا/نورث_داكوتا/نيو_سالم', 'أمريكا/دنفر', 'أمريكا/بويسي', 'أمريكا/شيبروك', 'أمريكا/فينيكس', 'أمريكا/لوس_أنجيلوس', 'أمريكا/أنكوريج', 'أمريكا/جونو', 'أمريكا/ياكوتات', 'أمريكا/نوم', 'أمريكا/أداك', 'المحيط_الهاديء/هونولولو'], 'code': 'US', 'continent': 'أمريكا الشمالية', 'name': 'الولايات المتحدة الأمريكية', 'capital': 'واشنطن'},
        {'timezones': ['أمريكا/مونتفيدو'], 'code': 'UY', 'continent': 'أمريكا الجنوبية', 'name': 'أوروغواي', 'capital': 'مونتفيدو'},
        {'timezones': ['آسيا/سمرقند', 'آسيا/طشقند'], 'code': 'UZ', 'continent': 'آسيا', 'name': 'أوزبكستان', 'capital': 'طشقند'},
        {'timezones': ['أوروبا/الفاتيكان'], 'code': 'VA', 'continent': 'أوروبا', 'name': 'الفاتيكان', 'capital': 'الفاتيكان'},
        {'timezones': ['أمريكا/كاركاس'], 'code': 'VE', 'continent': 'أمريكا الجنوبية', 'name': 'فنزويلا', 'capital': 'كاركاس'},
        {'timezones': ['آسيا/سايغون'], 'code': 'VN', 'continent': 'آسيا', 'name': 'فيتنام', 'capital': 'هانوي'},
        {'timezones': ['المحيط_الهاديء/أيفاتي'], 'code': 'VU', 'continent': 'أوقيانوسيا', 'name': 'فانواتو', 'capital': 'بورت فيلا'},
        {'timezones': ['آسيا/عدن'], 'code': 'YE', 'continent': 'آسيا', 'name': 'اليمن', 'capital': "صنعاء"},
        {'timezones': ['إفريقيا/لوساكا'], 'code': 'ZM', 'continent': 'إفريقيا', 'name': 'زامبيا', 'capital': 'لوساكا'},
        {'timezones': ['إفريقيا/هراري'], 'code': 'ZW', 'continent': 'إفريقيا', 'name': 'زيمبابوي', 'capital': 'هراري'},
        {'timezones': ['إفريقيا/الجزائر'], 'code': 'DZ', 'continent': 'إفريقيا', 'name': 'الجزائر', 'capital': 'الجزائر'},
        {'timezones': ['أوروبا/سراييفو'], 'code': 'BA', 'continent': 'أوروبا', 'name': 'البوسنة والهرسك', 'capital': 'سراييفو'},
        {'timezones': ['آسيا/بنوم_بنه'], 'code': 'KH', 'continent': 'آسيا', 'name': 'كمبوديا', 'capital': 'بنوم بنه'},
        {'timezones': ['إفريقيا/بانغي'], 'code': 'CF', 'continent': 'إفريقيا', 'name': 'جمهورية أفريقيا الوسطى', 'capital': 'بانغي'},
        {'timezones': ['إفريقيا/نجامينا'], 'code': 'TD', 'continent': 'إفريقيا', 'name': 'تشاد', 'capital': "نجامينا"},
        {'timezones': ['الهندي/كومورو'], 'code': 'KM', 'continent': 'إفريقيا', 'name': 'جزر القمر', 'capital': 'موروني'},
        {'timezones': ['أوروبا/زغرب'], 'code': 'HR', 'continent': 'أوروبا', 'name': 'كرواتيا', 'capital': 'زغرب'},
        {'timezones': ['آسيا/ديلي'], 'code': 'TL', 'continent': 'آسيا', 'name': 'تيمور الشرقية', 'capital': 'ديلي'},
        {'timezones': ['أمريكا/السلفادور'], 'code': 'SV', 'continent': 'أمريكا الشمالية', 'name': 'السلفادور', 'capital': 'سان سلفادور'},
        {'timezones': ['إفريقيا/مالابو'], 'code': 'GQ', 'continent': 'إفريقيا', 'name': 'غينيا الاستوائية', 'capital': 'مالابو'},
        {'timezones': ['أمريكا/غرينادا'], 'code': 'GD', 'continent': 'أمريكا الشمالية', 'name': 'غرينادا', 'capital': "سانت جورجز"},
        {'timezones': ['آسيا/ألماتي', 'آسيا/كيزيلوردا',  'آسيا/أقتوبي', 'آسيا/أقتاو', 'آسيا/أورال'], 'code': 'KZ', 'continent': 'آسيا', 'name': 'كازاخستان', 'capital': 'أستانة'},
        {'timezones': ['آسيا/فيينتيان'], 'code': 'LA', 'continent': 'آسيا', 'name': 'لاوس', 'capital': 'فيينتيان'},
        {'timezones': ['المحيط_الهاديء/تشوك', 'المحيط_الهاديء/بونابي', 'المحيط_الهاديء/كورساي'], 'code': 'FM', 'continent': 'أوقيانوسيا', 'name': 'ولايات ميكرونيسيا المتحدة', 'capital': 'باليكير'},
        {'timezones': ['أوروبا/كيشيناو'], 'code': 'MD', 'continent': 'أوروبا', 'name': 'مولدافيا', 'capital': 'كيشيناو'},
        {'timezones': ['أوروبا/موناكو'], 'code': 'MC', 'continent': 'أوروبا', 'name': 'موناكو', 'capital': 'موناكو'},
        {'timezones': ['أوروبا/بودغوريتسا'], 'code': 'ME', 'continent': 'أوروبا', 'name': 'الجبل الأسود', 'capital': 'بودغوريتسا'},
        {'timezones': ['إفريقيا/الدار_البيضاء'], 'code': 'MA', 'continent': 'إفريقيا', 'name': 'المغرب', 'capital': 'الرباط'},
        {'timezones': ['أمريكا/سانت_كيتس'], 'code': 'KN', 'continent': 'أمريكا الشمالية', 'name': 'سانت كيتس ونيفيس', 'capital': 'باستير'},
        {'timezones': ['أمريكا/سانت_لوسيا'], 'code': 'LC', 'continent': 'أمريكا الشمالية', 'name': 'سانت لوسيا', 'capital': 'كاستريس'},
        {'timezones': ['أمريكا/سينت_فينسينت'], 'code': 'VC', 'continent': 'أمريكا الشمالية', 'name': 'سانت فينسنت والغرينادين', 'capital': 'كينغستاون'},
        {'timezones': ['المحيط_الهاديء/أبيا'], 'code': 'WS', 'continent': 'أوقيانوسيا', 'name': 'ساموا', 'capital': 'أبيا'},
        {'timezones': ['أوروبا/بلغراد'], 'code': 'RS', 'continent': 'أوروبا', 'name': 'صربيا', 'capital': 'بلغراد'},
        {'timezones': ['إفريقيا/جوهانسبرغ'], 'code': 'ZA', 'continent': 'إفريقيا', 'name': 'جنوب إفريقيا', 'capital': 'بريتوريا'},
        {'timezones': ['أوروبا/مدريد', 'إفريقيا/سبتة', 'الأطلنطي/الكناري'], 'code': 'ES', 'continent': 'أوروبا', 'name': 'إسبانيا', 'capital': 'مدريد'},
        {'timezones': ['آسيا/كولمبو'], 'code': 'LK', 'continent': 'آسيا', 'name': 'سريلانكا', 'capital': 'سري جاياواردنابورا كوتي'},
        {'timezones': ['إفريقيا/مبابان'], 'code': 'SZ', 'continent': 'إفريقيا', 'name': 'سوازيلاند', 'capital': 'مبابان'},
        {'timezones': ['أوروبا/زيورخ'], 'code': 'CH', 'continent': 'أوروبا', 'name': 'سويسرا', 'capital': 'برن'},
        {'timezones': ['آسيا/دبي'], 'code': 'AE', 'continent': 'آسيا', 'name': 'الإمارات العربية المتحدة', 'capital': 'أبو ظبي'},
        {'timezones': ['أوروبا/لندن'], 'code': 'GB', 'continent': 'أوروبا', 'name': 'المملكة المتحدة', 'capital': 'لندن'},
    ]

    AM_PM = {
        'AM': 'ص',
        'PM': 'م',
    }

    def month_name(self):
        month = self.date('%m')
        return self.MONTH_NAMES[month]

    def am_pm(self):
        date = self.date('%p')
        return self.AM_PM[date]

    def day_of_week(self):
        day = self.date('%w')
        return self.DAY_NAMES[day]
