/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.util.SecurityUtil;
import jogamp.common.os.DynamicLinkerImpl;

public final class WindowsDynamicLinkerImpl
extends DynamicLinkerImpl {
    private static native int FreeLibrary(long var0);

    private static native int GetLastError();

    private static native long GetProcAddressA(long var0, String var2);

    private static native long LoadLibraryW(String var0);

    @Override
    public final long openLibraryLocal(String string, boolean bl) throws SecurityException {
        return this.openLibraryGlobal(string, bl);
    }

    @Override
    public final long openLibraryGlobal(String string, boolean bl) throws SecurityException {
        SecurityUtil.checkLinkPermission(string);
        long l = WindowsDynamicLinkerImpl.LoadLibraryW(string);
        if (0L != l) {
            this.incrLibRefCount(l, string);
        } else if (DEBUG || bl) {
            int n = WindowsDynamicLinkerImpl.GetLastError();
            System.err.println("LoadLibraryW \"" + string + "\" failed, error code: 0x" + Integer.toHexString(n) + ", " + n);
        }
        return l;
    }

    @Override
    public final long lookupSymbolGlobal(String string) throws SecurityException {
        SecurityUtil.checkAllLinkPermission();
        if (DEBUG_LOOKUP) {
            System.err.println("lookupSymbolGlobal: Not supported on Windows");
        }
        return 0L;
    }

    @Override
    public final long lookupSymbol(long l, String string) throws IllegalArgumentException {
        if (null == this.getLibRef(l)) {
            throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l) + " unknown.");
        }
        String string2 = string;
        long l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
        if (0L == l2) {
            for (int i = 0; 0L == l2 && i <= 12; ++i) {
                string2 = string + "@" + i * 4;
                l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
            }
        }
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(l) + ", " + string + ") -> " + string2 + ", 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    @Override
    public final void closeLibrary(long l) throws IllegalArgumentException {
        if (null == this.decrLibRefCount(l)) {
            throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l) + " unknown.");
        }
        WindowsDynamicLinkerImpl.FreeLibrary(l);
    }

    @Override
    public final String getLastError() {
        int n = WindowsDynamicLinkerImpl.GetLastError();
        return "Last error: 0x" + Integer.toHexString(n) + " (" + n + ")";
    }
}

