#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cassava
version: 0.5.1.0
id: cassava-0.5.1.0-Kqu5CgeKi1R71yUdIH0q2e
key: cassava-0.5.1.0-Kqu5CgeKi1R71yUdIH0q2e
license: BSD3
copyright: (c) 2012 Johan Tibell
           (c) 2012 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: hvr@gnu.org
homepage: https://github.com/hvr/cassava
synopsis: A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.
    .
    @cassava@'\''s API includes support for
    .
    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")
    .
    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:
    .
    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"
    .
    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.
category: Text, Web, CSV
author: Johan Tibell
exposed: True
indefinite: False
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming
hidden-modules: Data.Csv.Conversion Data.Csv.Conversion.Internal
                Data.Csv.Encoding Data.Csv.Types Data.Csv.Util
abi: 61480493ad70f4b4d9c52897ed2d764c
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/cassava-0.5.1.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/cassava-0.5.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/cassava-0.5.1.0
hs-libraries: HScassava-0.5.1.0-Kqu5CgeKi1R71yUdIH0q2e
depends:
    array-0.5.2.0 attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm
    base-4.10.0.0 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    Only-0.1-8seUdbp2vgr6LSAP9MSfSU
    text-short-0.1.1-JcL3O9DvaGM5S9a5VHyIup
abi-depends: array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm=08dd59974100c688bef2cfbf42e32e82
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q=1fbe9fca72112f81835ace86a6280857
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             Only-0.1-8seUdbp2vgr6LSAP9MSfSU=1fc4f7e179145d58169e7c3c5a35fe38
             text-short-0.1.1-JcL3O9DvaGM5S9a5VHyIup=8431d62b4955ec8778c44f3a8033f92e
haddock-interfaces: /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html: /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

