/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConstants;
import gnu.inet.imap.IMAPException;
import gnu.inet.imap.IMAPResponse;
import gnu.inet.imap.IMAPResponseTokenizer;
import gnu.inet.imap.ListEntry;
import gnu.inet.imap.MailboxStatus;
import gnu.inet.imap.MessageSetTokenizer;
import gnu.inet.imap.MessageStatus;
import gnu.inet.imap.Namespaces;
import gnu.inet.imap.Quota;
import gnu.inet.imap.UIDPlusHandler;
import gnu.inet.imap.UTF7imap;
import gnu.inet.util.BASE64;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.EmptyX509TrustManager;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslCramMD5;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslLogin;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.SaslPlain;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class IMAPConnection
implements IMAPConstants {
    public static final Level IMAP_TRACE = new TraceLevel("imap");
    protected static final String TAG_PREFIX = "A";
    protected static final String US_ASCII = "US-ASCII";
    protected static final int DEFAULT_PORT = 143;
    protected static final int DEFAULT_SSL_PORT = 993;
    public static final Logger logger = Logger.getLogger("gnu.inet.imap");
    protected Socket socket;
    protected IMAPResponseTokenizer in;
    protected CRLFOutputStream out;
    protected List asyncResponses;
    private List alerts;
    private int tagIndex = 0;
    private boolean ansiDebug = false;

    public IMAPConnection(String string) throws UnknownHostException, IOException {
        this(string, -1, 0, 0, false, null);
    }

    public IMAPConnection(String string, int n) throws UnknownHostException, IOException {
        this(string, n, 0, 0, false, null);
    }

    public IMAPConnection(String string, int n, int n2, int n3) throws UnknownHostException, IOException {
        this(string, n, n2, n3, false, null);
    }

    public IMAPConnection(String string, int n, TrustManager trustManager) throws UnknownHostException, IOException {
        this(string, n, 0, 0, true, trustManager);
    }

    public IMAPConnection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager) throws UnknownHostException, IOException {
        Object object;
        Object object2;
        if (n < 0) {
            n = bl ? 993 : 143;
        }
        try {
            this.socket = new Socket();
            object2 = new InetSocketAddress(string, n);
            if (n2 > 0) {
                this.socket.connect((SocketAddress)object2, n2);
            } else {
                this.socket.connect((SocketAddress)object2);
            }
            if (n3 > 0) {
                this.socket.setSoTimeout(n3);
            }
            if (bl) {
                object = this.getSSLSocketFactory(trustManager);
                SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.socket, string, n, true);
                String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                sSLSocket.setEnabledProtocols(stringArray);
                sSLSocket.setUseClientMode(true);
                sSLSocket.startHandshake();
                this.socket = sSLSocket;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            IOException iOException = new IOException();
            iOException.initCause(generalSecurityException);
            throw iOException;
        }
        object2 = this.socket.getInputStream();
        object2 = new BufferedInputStream((InputStream)object2);
        this.in = new IMAPResponseTokenizer((InputStream)object2);
        object = this.socket.getOutputStream();
        object = new BufferedOutputStream((OutputStream)object);
        this.out = new CRLFOutputStream((OutputStream)object);
        this.asyncResponses = new ArrayList();
        this.alerts = new ArrayList();
    }

    public void setAnsiDebug(boolean bl) {
        this.ansiDebug = bl;
    }

    protected String newTag() {
        return TAG_PREFIX + ++this.tagIndex;
    }

    protected void sendCommand(String string, String string2) throws IOException {
        logger.log(IMAP_TRACE, "> " + string + " " + string2);
        this.out.write(string + ' ' + string2);
        this.out.writeln();
        this.out.flush();
    }

    public boolean invokeSimpleCommand(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        this.sendCommand(string3, string);
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    protected IMAPResponse readResponse() throws IOException {
        IMAPResponse iMAPResponse = this.in.next();
        if (iMAPResponse == null) {
            logger.log(IMAP_TRACE, "<EOF");
            throw new EOFException();
        }
        if (this.ansiDebug) {
            logger.log(IMAP_TRACE, "< " + iMAPResponse.toANSIString());
        } else {
            logger.log(IMAP_TRACE, "< " + iMAPResponse.toString());
        }
        return iMAPResponse;
    }

    private void processAlerts(IMAPResponse iMAPResponse) {
        List list = iMAPResponse.getResponseCode();
        if (list != null && list.contains("ALERT")) {
            this.alerts.add(iMAPResponse.getText());
        }
    }

    public boolean alertsPending() {
        return this.alerts.size() > 0;
    }

    public String[] getAlerts() {
        String[] stringArray = new String[this.alerts.size()];
        this.alerts.toArray(stringArray);
        this.alerts.clear();
        return stringArray;
    }

    public List capability() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "CAPABILITY");
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (string2.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string == "OK") {
                    if (arrayList.size() == 0) {
                        this.addTokens(arrayList, iMAPResponse.getText());
                    }
                    return arrayList;
                }
                throw new IMAPException(string, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if (string == "CAPABILITY") {
                this.addTokens(arrayList, iMAPResponse.getText());
                continue;
            }
            if (string == "OK") {
                int n;
                List list = iMAPResponse.getResponseCode();
                int n2 = n = list == null ? 0 : list.size();
                if (n > 0 && "CAPABILITY".equals(list.get(0))) {
                    int n3 = 1;
                    while (true) {
                        if (n3 >= n) continue block0;
                        String string3 = (String)list.get(n3);
                        if (!arrayList.contains(string3)) {
                            arrayList.add(string3);
                        }
                        ++n3;
                    }
                }
                this.asyncResponses.add(iMAPResponse);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    private void addTokens(List list, String string) {
        String string2;
        int n = 0;
        int n2 = string.indexOf(32);
        while (n2 != -1) {
            string2 = string.substring(n, n2);
            if (!list.contains(string2)) {
                list.add(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf(32, n);
        }
        string2 = string.substring(n);
        if (string2.length() > 0 && !list.contains(string2)) {
            list.add(string2);
        }
    }

    public MailboxStatus noop() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "NOOP");
        boolean bl = false;
        MailboxStatus mailboxStatus = new MailboxStatus();
        Iterator iterator = this.asyncResponses.iterator();
        while (true) {
            if (iterator.hasNext()) {
                iMAPResponse = (IMAPResponse)iterator.next();
                iterator.remove();
            } else {
                iMAPResponse = this.readResponse();
            }
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            bl = bl || this.updateMailboxStatus(mailboxStatus, string, iMAPResponse);
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                return bl ? mailboxStatus : null;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager trustManager) throws GeneralSecurityException {
        if (trustManager == null) {
            trustManager = new EmptyX509TrustManager();
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
        sSLContext.init(null, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    public boolean starttls() throws IOException {
        return this.starttls(new EmptyX509TrustManager());
    }

    public boolean starttls(TrustManager trustManager) throws IOException {
        try {
            String[] stringArray;
            Object object;
            SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory(trustManager);
            String string = this.socket.getInetAddress().getHostName();
            int n = this.socket.getPort();
            String string2 = this.newTag();
            this.sendCommand(string2, "STARTTLS");
            while (true) {
                if (((IMAPResponse)(object = this.readResponse())).isTagged() && string2.equals(((IMAPResponse)object).getTag())) {
                    this.processAlerts((IMAPResponse)object);
                    stringArray = ((IMAPResponse)object).getID();
                    if (stringArray == "OK") break;
                    if (stringArray != "BAD") continue;
                    return false;
                }
                this.asyncResponses.add(object);
            }
            object = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
            stringArray = new String[]{"TLSv1", "SSLv3"};
            ((SSLSocket)object).setEnabledProtocols(stringArray);
            ((SSLSocket)object).setUseClientMode(true);
            ((SSLSocket)object).startHandshake();
            InputStream inputStream = ((Socket)object).getInputStream();
            inputStream = new BufferedInputStream(inputStream);
            this.in = new IMAPResponseTokenizer(inputStream);
            OutputStream outputStream = ((Socket)object).getOutputStream();
            outputStream = new BufferedOutputStream(outputStream);
            this.out = new CRLFOutputStream(outputStream);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            return false;
        }
    }

    public boolean login(String string, String string2) throws IOException {
        return this.invokeSimpleCommand("LOGIN " + IMAPConnection.quote(string) + ' ' + IMAPConnection.quote(string2));
    }

    public boolean authenticate(String string, String string2, String string3) throws IOException {
        try {
            String[] stringArray = new String[]{string};
            SaslCallbackHandler saslCallbackHandler = new SaslCallbackHandler(string2, string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("gnu.crypto.sasl.username", string2);
            hashMap.put("gnu.crypto.sasl.password", string3);
            SaslClient saslClient = Sasl.createSaslClient(stringArray, null, "imap", this.socket.getInetAddress().getHostName(), hashMap, saslCallbackHandler);
            if (saslClient == null) {
                if ("LOGIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslLogin(string2, string3);
                } else if ("PLAIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslPlain(string2, string3);
                } else if ("CRAM-MD5".equalsIgnoreCase(string)) {
                    saslClient = new SaslCramMD5(string2, string3);
                } else {
                    logger.log(IMAP_TRACE, string + " not available");
                    return false;
                }
            }
            StringBuffer stringBuffer = new StringBuffer("AUTHENTICATE");
            stringBuffer.append(' ');
            stringBuffer.append(string);
            String string4 = this.newTag();
            this.sendCommand(string4, stringBuffer.toString());
            while (true) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                IMAPResponse iMAPResponse;
                if (string4.equals((iMAPResponse = this.readResponse()).getTag())) {
                    this.processAlerts(iMAPResponse);
                    object4 = iMAPResponse.getID();
                    if (object4 == "OK") {
                        object3 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                        if ("auth-int".equalsIgnoreCase((String)object3) || "auth-conf".equalsIgnoreCase((String)object3)) {
                            object2 = this.socket.getInputStream();
                            object2 = new BufferedInputStream((InputStream)object2);
                            object2 = new SaslInputStream(saslClient, (InputStream)object2);
                            this.in = new IMAPResponseTokenizer((InputStream)object2);
                            object = this.socket.getOutputStream();
                            object = new BufferedOutputStream((OutputStream)object);
                            object = new SaslOutputStream(saslClient, (OutputStream)object);
                            this.out = new CRLFOutputStream((OutputStream)object);
                        }
                        return true;
                    }
                    if (object4 == "NO") {
                        return false;
                    }
                    if (object4 != "BAD") continue;
                    throw new IMAPException((String)object4, iMAPResponse.getText());
                }
                if (iMAPResponse.isContinuation()) {
                    try {
                        object4 = iMAPResponse.getText().getBytes(US_ASCII);
                        object3 = BASE64.decode((byte[])object4);
                        object2 = saslClient.evaluateChallenge((byte[])object3);
                        object = BASE64.encode(object2);
                        this.out.write((byte[])object);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> " + new String((byte[])object, US_ASCII));
                    }
                    catch (SaslException saslException) {
                        this.out.write(42);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> *");
                    }
                    continue;
                }
                this.asyncResponses.add(iMAPResponse);
            }
        }
        catch (SaslException saslException) {
            logger.log(IMAP_TRACE, saslException.getMessage(), saslException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            logger.log(IMAP_TRACE, runtimeException.getMessage(), runtimeException);
            return false;
        }
    }

    public void logout() throws IOException {
        String string = this.newTag();
        this.sendCommand(string, "LOGOUT");
        while (true) {
            IMAPResponse iMAPResponse;
            if ((iMAPResponse = this.readResponse()).isTagged() && string.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                String string2 = iMAPResponse.getID();
                if (string2 == "OK") {
                    this.socket.close();
                    return;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            this.asyncResponses.add(iMAPResponse);
        }
    }

    public MailboxStatus select(String string) throws IOException {
        return this.selectImpl(string, "SELECT");
    }

    public MailboxStatus examine(String string) throws IOException {
        return this.selectImpl(string, "EXAMINE");
    }

    protected MailboxStatus selectImpl(String string, String string2) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        this.sendCommand(string4, string2 + ' ' + IMAPConnection.quote(UTF7imap.encode(string)));
        MailboxStatus mailboxStatus = new MailboxStatus();
        mailboxStatus.select = true;
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (this.updateMailboxStatus(mailboxStatus, string3, iMAPResponse)) continue;
            this.asyncResponses.add(iMAPResponse);
        }
        if (string4.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string3 == "OK") {
                List list = iMAPResponse.getResponseCode();
                if (list != null && list.size() > 0 && list.get(0) == "READ-WRITE") {
                    mailboxStatus.readWrite = true;
                }
                return mailboxStatus;
            }
            throw new IMAPException(string3, iMAPResponse.getText());
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    protected boolean updateMailboxStatus(MailboxStatus mailboxStatus, String string, IMAPResponse iMAPResponse) throws IOException {
        if (string == "OK") {
            boolean bl = false;
            List list = iMAPResponse.getResponseCode();
            int n = list == null ? 0 : list.size();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (!(e instanceof String)) continue;
                String string2 = (String)e;
                if (i + 1 >= n) continue;
                Object e2 = list.get(i + 1);
                if (e2 instanceof String) {
                    String string3 = (String)e2;
                    try {
                        if (string2 == "UNSEEN") {
                            mailboxStatus.firstUnreadMessage = Integer.parseInt(string3);
                            ++i;
                            bl = true;
                            continue;
                        }
                        if (string2 != "UIDVALIDITY") continue;
                        mailboxStatus.uidValidity = Integer.parseInt(string3);
                        ++i;
                        bl = true;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException("Illegal " + string2 + " value: " + string3);
                    }
                }
                if (!(e2 instanceof List) || string2 != "PERMANENTFLAGS") continue;
                mailboxStatus.permanentFlags = (List)e2;
                ++i;
                bl = true;
            }
            return bl;
        }
        if (string == "EXISTS") {
            mailboxStatus.messageCount = iMAPResponse.getCount();
            return true;
        }
        if (string == "RECENT") {
            mailboxStatus.newMessageCount = iMAPResponse.getCount();
            return true;
        }
        if (string == "FLAGS") {
            mailboxStatus.flags = iMAPResponse.getResponseCode();
            return true;
        }
        return false;
    }

    public boolean create(String string) throws IOException {
        return this.invokeSimpleCommand("CREATE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean delete(String string) throws IOException {
        return this.invokeSimpleCommand("DELETE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean rename(String string, String string2) throws IOException {
        return this.invokeSimpleCommand("RENAME " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + IMAPConnection.quote(UTF7imap.encode(string2)));
    }

    public boolean subscribe(String string) throws IOException {
        return this.invokeSimpleCommand("SUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean unsubscribe(String string) throws IOException {
        return this.invokeSimpleCommand("UNSUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public ListEntry[] list(String string, String string2) throws IOException {
        return this.listImpl("LIST", string, string2);
    }

    public ListEntry[] lsub(String string, String string2) throws IOException {
        return this.listImpl("LSUB", string, string2);
    }

    protected ListEntry[] listImpl(String string, String string2, String string3) throws IOException {
        ListEntry[] listEntryArray;
        String string4;
        IMAPResponse iMAPResponse;
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string5 = this.newTag();
        this.sendCommand(string5, string + ' ' + IMAPConnection.quote(UTF7imap.encode(string2)) + ' ' + IMAPConnection.quote(UTF7imap.encode(string3)));
        ArrayList<ListEntry> arrayList = new ArrayList<ListEntry>();
        while (true) {
            iMAPResponse = this.readResponse();
            string4 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string4.equals(string)) {
                int n;
                listEntryArray = iMAPResponse.getResponseCode();
                String string6 = iMAPResponse.getText();
                int n2 = listEntryArray == null ? 0 : listEntryArray.size();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (n = 0; n < n2; ++n) {
                    String string7 = (String)listEntryArray.get(n);
                    if (string7.equalsIgnoreCase("\\Noinferiors")) {
                        bl = true;
                        continue;
                    }
                    if (string7.equalsIgnoreCase("\\Noselect")) {
                        bl2 = true;
                        continue;
                    }
                    if (string7.equalsIgnoreCase("\\Marked")) {
                        bl3 = true;
                        continue;
                    }
                    if (!string7.equalsIgnoreCase("\\Unmarked")) continue;
                    bl4 = true;
                }
                n = string6.indexOf(32);
                char c = '\u0000';
                String string8 = string6.substring(0, n);
                if (!string8.equalsIgnoreCase("NIL")) {
                    c = IMAPConnection.stripQuotes(string8).charAt(0);
                }
                String string9 = IMAPConnection.stripQuotes(string6.substring(n + 1));
                string9 = UTF7imap.decode(string9);
                ListEntry listEntry = new ListEntry(string9, c, bl, bl2, bl3, bl4);
                arrayList.add(listEntry);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string5.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string4 == "OK") {
                listEntryArray = new ListEntry[arrayList.size()];
                arrayList.toArray(listEntryArray);
                return listEntryArray;
            }
            throw new IMAPException(string4, iMAPResponse.getText());
        }
        throw new IMAPException(string4, iMAPResponse.getText());
    }

    public MailboxStatus status(String string, String[] stringArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("STATUS").append(' ').append(IMAPConnection.quote(UTF7imap.encode(string))).append(' ').append('(');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(')');
        this.sendCommand(string3, stringBuffer.toString());
        MailboxStatus mailboxStatus = new MailboxStatus();
        block3: while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string2 == "STATUS") {
                List list = iMAPResponse.getResponseCode();
                int n = list == null ? 0 : list.size() - 1;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block3;
                    try {
                        String string4 = ((String)list.get(n2)).intern();
                        int n3 = Integer.parseInt((String)list.get(n2 + 1));
                        if (string4 == "MESSAGES") {
                            mailboxStatus.messageCount = n3;
                        } else if (string4 == "RECENT") {
                            mailboxStatus.newMessageCount = n3;
                        } else if (string4 == "UIDNEXT") {
                            mailboxStatus.uidNext = n3;
                        } else if (string4 == "UIDVALIDITY") {
                            mailboxStatus.uidValidity = n3;
                        } else if (string4 == "UNSEEN") {
                            mailboxStatus.firstUnreadMessage = n3;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IMAPException(string2, "Invalid code: " + list);
                    }
                    n2 += 2;
                }
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string3.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string2 == "OK") {
                return mailboxStatus;
            }
            throw new IMAPException(string2, iMAPResponse.getText());
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public boolean append(String string, String[] stringArray, byte[] byArray) throws IOException {
        return this.append(string, stringArray, byArray, null);
    }

    public boolean append(String string, String[] stringArray, byte[] byArray, UIDPlusHandler uIDPlusHandler) throws IOException {
        String string2;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("APPEND").append(' ').append(IMAPConnection.quote(UTF7imap.encode(string))).append(' ');
        if (stringArray != null) {
            stringBuffer.append('(');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(')');
            stringBuffer.append(' ');
        }
        stringBuffer.append('{');
        stringBuffer.append(byArray.length);
        stringBuffer.append('}');
        this.sendCommand(string3, stringBuffer.toString());
        IMAPResponse iMAPResponse = this.readResponse();
        if (!iMAPResponse.isContinuation()) {
            throw new IMAPException(iMAPResponse.getID(), iMAPResponse.getText());
        }
        this.out.write(byArray);
        this.out.writeln();
        this.out.flush();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    if (uIDPlusHandler != null) {
                        this.processUIDPlus(iMAPResponse.getResponseCode(), uIDPlusHandler);
                    }
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    void processUIDPlus(List list, UIDPlusHandler uIDPlusHandler) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof String) {
                long l;
                if ("APPENDUID".equals(e) && i < n - 2) {
                    l = Long.parseLong((String)list.get(i + 1));
                    long l2 = Long.parseLong((String)list.get(i + 2));
                    uIDPlusHandler.appenduid(l, l2);
                    continue;
                }
                if (!"COPYUID".equals(e) || i >= n - 3) continue;
                l = Long.parseLong((String)list.get(i + 1));
                MessageSetTokenizer messageSetTokenizer = new MessageSetTokenizer((String)list.get(i + 2));
                MessageSetTokenizer messageSetTokenizer2 = new MessageSetTokenizer((String)list.get(i + 3));
                while (messageSetTokenizer.hasNext()) {
                    long l3 = (Long)messageSetTokenizer.next();
                    long l4 = (Long)messageSetTokenizer2.next();
                    uIDPlusHandler.copyuid(l, l3, l4);
                }
                continue;
            }
            this.processUIDPlus((List)e, uIDPlusHandler);
        }
    }

    public void check() throws IOException {
        this.invokeSimpleCommand("CHECK");
    }

    public boolean close() throws IOException {
        return this.invokeSimpleCommand("CLOSE");
    }

    public int[] expunge() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "EXPUNGE");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string == "EXPUNGE") {
                arrayList.add(new Integer(iMAPResponse.getCount()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                int n = arrayList.size();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                return nArray;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    public int[] search(String string, String[] stringArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("SEARCH");
        stringBuffer.append(' ');
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        this.sendCommand(string3, stringBuffer.toString());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string2 == "SEARCH") {
                String string4 = iMAPResponse.getText();
                if (string4 == null) continue;
                try {
                    int n = string4.indexOf(32);
                    while (n != -1) {
                        arrayList.add(new Integer(string4.substring(0, n)));
                        string4 = string4.substring(n + 1);
                        n = string4.indexOf(32);
                    }
                    arrayList.add(new Integer(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IMAPException(string2, "Expecting number: " + string4);
                }
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string3.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string2 == "OK") {
                int n = arrayList.size();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                return nArray;
            }
            throw new IMAPException(string2, iMAPResponse.getText());
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public MessageStatus fetch(int n, String[] stringArray) throws IOException {
        String string = n == -1 ? "*" : Integer.toString(n);
        return this.fetchImpl("FETCH", string, stringArray)[0];
    }

    public MessageStatus[] fetch(int n, int n2, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n == -1 ? 42 : n);
        stringBuffer.append(':');
        stringBuffer.append(n2 == -1 ? 42 : n2);
        return this.fetchImpl("FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus[] fetch(int[] nArray, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return this.fetchImpl("FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus uidFetch(long l, String[] stringArray) throws IOException {
        String string = l == -1L ? "*" : Long.toString(l);
        return this.fetchImpl("UID FETCH", string, stringArray)[0];
    }

    public MessageStatus[] uidFetch(long l, long l2, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l == -1L ? 42L : l);
        stringBuffer.append(':');
        stringBuffer.append(l2 == -1L ? 42L : l2);
        return this.fetchImpl("UID FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus[] uidFetch(long[] lArray, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(lArray[i]);
        }
        return this.fetchImpl("UID FETCH", stringBuffer.toString(), stringArray);
    }

    private MessageStatus[] fetchImpl(String string, String string2, String[] stringArray) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append('(');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(')');
        this.sendCommand(string4, stringBuffer.toString());
        ArrayList<MessageStatus> arrayList = new ArrayList<MessageStatus>();
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string3 == "FETCH") {
                int n = iMAPResponse.getCount();
                List list = iMAPResponse.getResponseCode();
                MessageStatus messageStatus = new MessageStatus(n, list);
                arrayList.add(messageStatus);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string4.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string3 == "OK") {
                MessageStatus[] messageStatusArray = new MessageStatus[arrayList.size()];
                arrayList.toArray(messageStatusArray);
                return messageStatusArray;
            }
            throw new IMAPException(string3, iMAPResponse.getText());
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    public MessageStatus store(int n, String string, String[] stringArray) throws IOException {
        String string2 = n == -1 ? "*" : Integer.toString(n);
        return this.storeImpl("STORE", string2, string, stringArray)[0];
    }

    public MessageStatus[] store(int n, int n2, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n == -1 ? 42 : n);
        stringBuffer.append(':');
        stringBuffer.append(n2 == -1 ? 42 : n2);
        return this.storeImpl("STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus[] store(int[] nArray, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return this.storeImpl("STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus uidStore(long l, String string, String[] stringArray) throws IOException {
        String string2 = l == -1L ? "*" : Long.toString(l);
        return this.storeImpl("UID STORE", string2, string, stringArray)[0];
    }

    public MessageStatus[] uidStore(long l, long l2, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l == -1L ? 42L : l);
        stringBuffer.append(':');
        stringBuffer.append(l2 == -1L ? 42L : l2);
        return this.storeImpl("UID STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus[] uidStore(long[] lArray, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(lArray[i]);
        }
        return this.storeImpl("UID STORE", stringBuffer.toString(), string, stringArray);
    }

    private MessageStatus[] storeImpl(String string, String string2, String string3, String[] stringArray) throws IOException {
        String string4;
        IMAPResponse iMAPResponse;
        String string5 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(string3);
        stringBuffer.append(' ');
        stringBuffer.append('(');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(')');
        this.sendCommand(string5, stringBuffer.toString());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (true) {
            Object object;
            iMAPResponse = this.readResponse();
            string4 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            int n = iMAPResponse.getCount();
            List list = iMAPResponse.getResponseCode();
            if (string4 == "FETCH") {
                object = new MessageStatus(n, list);
                arrayList.add(object);
                continue;
            }
            if (string4 == "FETCH FLAGS") {
                object = new ArrayList();
                object.add("FLAGS");
                object.add(list);
                MessageStatus messageStatus = new MessageStatus(n, (List)object);
                arrayList.add(messageStatus);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string5.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string4 == "OK") {
                MessageStatus[] messageStatusArray = new MessageStatus[arrayList.size()];
                arrayList.toArray(messageStatusArray);
                return messageStatusArray;
            }
            throw new IMAPException(string4, iMAPResponse.getText());
        }
        throw new IMAPException(string4, iMAPResponse.getText());
    }

    public boolean copy(int[] nArray, String string) throws IOException {
        return this.copy(nArray, string, null);
    }

    public boolean copy(int[] nArray, String string, UIDPlusHandler uIDPlusHandler) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        if (nArray == null || nArray.length < 1) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer("COPY").append(' ');
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(' ').append(IMAPConnection.quote(UTF7imap.encode(string)));
        String string3 = this.newTag();
        this.sendCommand(string3, stringBuffer.toString());
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    if (uIDPlusHandler != null) {
                        this.processUIDPlus(iMAPResponse.getResponseCode(), uIDPlusHandler);
                    }
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Namespaces namespace() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "NAMESPACE");
        Namespaces namespaces = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (string2.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string == "OK") {
                    return namespaces;
                }
                throw new IMAPException(string, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("NAMESPACE".equals(iMAPResponse.getID())) {
                namespaces = new Namespaces(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    public boolean setacl(String string, String string2, int n) throws IOException {
        String string3 = "SETACL " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2) + ' ' + this.rightsToString(n);
        return this.invokeSimpleCommand(string3);
    }

    public boolean deleteacl(String string, String string2) throws IOException {
        String string3 = "DELETEACL " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2);
        return this.invokeSimpleCommand(string3);
    }

    public Map getacl(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        this.sendCommand(string3, "GETACL " + IMAPConnection.quote(UTF7imap.encode(string)));
        TreeMap treeMap = new TreeMap();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return treeMap;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("ACL".equals(iMAPResponse.getID())) {
                String string4 = iMAPResponse.getText();
                List list = this.parseACL(string4, 1);
                String string5 = (String)list.get(2);
                treeMap.put(list.get(1), new Integer(this.stringToRights(string5)));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public int listrights(String string, String string2) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        String string5 = "LISTRIGHTS " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2);
        this.sendCommand(string4, string5);
        int n = -1;
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (string4.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string3 == "OK") {
                    return n;
                }
                if (string3 == "NO") {
                    return -1;
                }
                throw new IMAPException(string3, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("LISTRIGHTS".equals(iMAPResponse.getID())) {
                String string6 = iMAPResponse.getText();
                List list = this.parseACL(string6, 1);
                n = this.stringToRights((String)list.get(2));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    public int myrights(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "MYRIGHTS " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        int n = -1;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return n;
                }
                if (string2 == "NO") {
                    return -1;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("MYRIGHTS".equals(iMAPResponse.getID())) {
                String string5 = iMAPResponse.getText();
                List list = this.parseACL(string5, 0);
                n = this.stringToRights((String)list.get(2));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    private String rightsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('l');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('r');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('w');
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append('i');
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append('p');
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append('c');
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append('d');
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append('a');
        }
        return stringBuffer.toString();
    }

    private int stringToRights(String string) {
        int n = 0;
        int n2 = string.length();
        block11: for (int i = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case 'l': {
                    n |= 1;
                    continue block11;
                }
                case 'r': {
                    n |= 2;
                    continue block11;
                }
                case 's': {
                    n |= 4;
                    continue block11;
                }
                case 'w': {
                    n |= 8;
                    continue block11;
                }
                case 'i': {
                    n |= 0x10;
                    continue block11;
                }
                case 'p': {
                    n |= 0x20;
                    continue block11;
                }
                case 'c': {
                    n |= 0x40;
                    continue block11;
                }
                case 'd': {
                    n |= 0x80;
                    continue block11;
                }
                case 'a': {
                    n |= 0x100;
                }
            }
        }
        return n;
    }

    private List parseACL(String string, int n) {
        int n2 = string.length();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    bl = !bl;
                    continue block4;
                }
                case ' ': {
                    if (bl || arrayList.size() > n) {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    arrayList.add(UTF7imap.decode(stringBuffer.toString()));
                    stringBuffer.setLength(0);
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    public Quota setquota(String string, Quota.Resource[] resourceArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        StringBuffer stringBuffer = new StringBuffer();
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(resourceArray[i].toString());
            }
        }
        String string3 = this.newTag();
        String string4 = "SETQUOTA " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + stringBuffer.toString();
        this.sendCommand(string3, string4);
        Quota quota = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return quota;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                quota = new Quota(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Quota getquota(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "GETQUOTA " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        Quota quota = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return quota;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                quota = new Quota(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Quota[] getquotaroot(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "GETQUOTAROOT " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        ArrayList<Quota> arrayList = new ArrayList<Quota>();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    Quota[] quotaArray = new Quota[arrayList.size()];
                    arrayList.toArray(quotaArray);
                    return quotaArray;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                arrayList.add(new Quota(iMAPResponse.getText()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public int[] uidExpunge(long l, long l2) throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("UID EXPUNGE");
        stringBuffer.append(' ');
        stringBuffer.append(l);
        stringBuffer.append(':');
        stringBuffer.append(l2);
        this.sendCommand(string2, stringBuffer.toString());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string == "EXPUNGE") {
                arrayList.add(new Integer(iMAPResponse.getCount()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                int n = arrayList.size();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                return nArray;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    static String stripQuotes(String string) {
        int n;
        if (string.charAt(0) == '\"' && string.charAt((n = string.length()) - 1) == '\"') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    static String quote(String string) {
        if (string.length() == 0 || string.indexOf(32) != -1 || string.indexOf(37) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }
}

