#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: jose
version: 0.6.0.3
id: jose-0.6.0.3-IckWB3vo7i0BCHjUlcDoeb
key: jose-0.6.0.3-IckWB3vo7i0BCHjUlcDoeb
license: Apache-2.0
copyright: Copyright (C) 2013, 2014, 2015, 2016, 2017  Fraser Tweedale
maintainer: frase@frase.id.au
homepage: https://github.com/frasertweedale/hs-jose
synopsis: Javascript Object Signing and Encryption and JSON Web Token library
description:
    .
    An implementation of the Javascript Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519) formats.
    .
    The JSON Web Signature (JWS; RFC 7515) implementation is complete.
    .
    EdDSA signatures (RFC 8037) are supported (Ed25519 only).
    .
    JWK Thumbprint (RFC 7638) is supported (requires /aeson/ >= 0.10).
    .
    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.
    .
    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.
category: Cryptography
author: Fraser Tweedale
exposed: True
indefinite: False
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT
hidden-modules: Crypto.JOSE.TH Crypto.JOSE.Types.Internal
                Crypto.JOSE.Types.Orphans
abi: 5c0d8ec266e2b3cf69153ef05423b10a
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/jose-0.6.0.3
library-dirs: /usr/lib/ghc-8.2.1/site-local/jose-0.6.0.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/jose-0.6.0.3
hs-libraries: HSjose-0.6.0.3-IckWB3vo7i0BCHjUlcDoeb
depends:
    base-4.10.0.0 attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm
    base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm
    concise-0.1.0.0-F3DX3JMFymHIwc7a0rbYVD containers-0.5.10.2
    cryptonite-0.24-ELENUw6Chsl82ACxm0cgXp
    lens-4.15.4-BVNSGosFkEc34U2t4uFumn
    memory-0.14.8-BAg3DtPwumR3TQfKUohmeR
    monad-time-0.2-87TQCV3wNpH91r1vLr0r7Q
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP template-haskell-2.12.0.0
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    bytestring-0.10.8.2 text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    time-1.8.0.2 network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK
    QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX
    quickcheck-instances-0.3.16-LeXGXWc1Sov3fkkaL3Jmgi
    x509-1.7.2-BkUsBex4pvBdlJA0fUJWS
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm=08dd59974100c688bef2cfbf42e32e82
             base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm=d31f9783df40d231323e9ab91d44fa81
             concise-0.1.0.0-F3DX3JMFymHIwc7a0rbYVD=5841c9b42ba7a795c3df29e100e12716
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             cryptonite-0.24-ELENUw6Chsl82ACxm0cgXp=d36853e10cf2a0c9b1a6796b9ffe1717
             lens-4.15.4-BVNSGosFkEc34U2t4uFumn=09df9ebd42f546ab4bf6120bba6d71c5
             memory-0.14.8-BAg3DtPwumR3TQfKUohmeR=b78231a975bde8739839c13c0576fe77
             monad-time-0.2-87TQCV3wNpH91r1vLr0r7Q=ab6482eb876ca859c84756bab8e946e3
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq=61053bde0c5cda47d1a123db05d36888
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK=83774d660ce535b1c7a882f242c5fec6
             QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX=698e905b23be91d72fd87efbe66c208e
             quickcheck-instances-0.3.16-LeXGXWc1Sov3fkkaL3Jmgi=7c3c4496922a4b8d324040da335f0570
             x509-1.7.2-BkUsBex4pvBdlJA0fUJWS=b145bd8477827e4ef45b9ac4229441ac
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
haddock-interfaces: /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html: /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

