#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.2.2
id: tamarin-prover-term-1.2.2-E7t9u7QnWmD1bQUA1Lyhy1
key: tamarin-prover-term-1.2.2-E7t9u7QnWmD1bQUA1Lyhy1
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
indefinite: False
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
abi: a8f7591145758075cde4c8a07fc4d5ab
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tamarin-prover-term-1.2.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/tamarin-prover-term-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tamarin-prover-term-1.2.2
hs-libraries: HStamarin-prover-term-1.2.2-E7t9u7QnWmD1bQUA1Lyhy1
depends:
    HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3
    attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm base-4.10.0.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 process-1.6.1.0
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    tamarin-prover-utils-1.2.2-LVjJJ7aC5vc3QABo3RoZz1
abi-depends: HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3=403e14f0201c382f502c00d4ca640d0c
             attoparsec-0.13.2.0-CjTw1SIXl7j4WJB8EsmBPm=08dd59974100c688bef2cfbf42e32e82
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             dlist-0.8.0.3-8XCsMwviZunHg7vFDzvN5q=97435ce23ff4e4560f559d3afbbee81e
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             tamarin-prover-utils-1.2.2-LVjJJ7aC5vc3QABo3RoZz1=e2fb01d51fee8a9252a28a2396837eb8
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

