/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.load.Library;

public class FFIService
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        if (!runtime.getInstanceConfig().isNativeEnabled()) {
            throw runtime.newLoadError("Native API access is disabled");
        }
        if (!Platform.getPlatform().isSupported()) {
            throw runtime.newLoadError("Unsupported platform: " + Platform.getPlatform().getName());
        }
        RubyModule ffi2 = runtime.defineModule("FFI");
        try {
            Factory.getInstance().init(runtime, ffi2);
        }
        catch (Exception e) {
            throw runtime.newLoadError("Could not load FFI Provider: " + e.getLocalizedMessage() + " See http://jira.codehaus.org/browse/JRUBY-4583");
        }
    }
}

