/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_dz extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0f58\u0f7d\u0f66\u0f0b\u0f40\u0f7c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MSK",
               "\u0f58\u0f7d\u0f66\u0f0b\u0f40\u0f7c\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MSD",
               "\u0f58\u0f7d\u0f66\u0f0b\u0f40\u0f7c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0f47\u0f0b\u0f54\u0f71\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "JST",
               "\u0f47\u0f0b\u0f54\u0f71\u0f53\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "JDT",
               "\u0f47\u0f0b\u0f54\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0f54\u0f0b\u0f40\u0f72\u0f0b\u0f66\u0f84\u0f4f\u0f71\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PKT",
               "\u0f54\u0f0b\u0f40\u0f72\u0f0b\u0f66\u0f84\u0f4f\u0f71\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PKST",
               "\u0f54\u0f0b\u0f40\u0f72\u0f0b\u0f66\u0f84\u0f4f\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PKT",
            };
        final String[] Magadan = new String[] {
               "\u0f58\u0f0b\u0f42\u0fb7\u0f0b\u0f51\u0f71\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MAGT",
               "\u0f58\u0f0b\u0f42\u0fb7\u0f0b\u0f51\u0f71\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MAGST",
               "\u0f58\u0f0b\u0f42\u0fb7\u0f0b\u0f51\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACWST",
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACWDT",
               "\u0f56\u0f74\u0f66\u0f0b\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CET",
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CEST",
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0f66\u0f0b\u0f41\u0f0b\u0f63\u0f72\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SAKT",
               "\u0f66\u0f0b\u0f41\u0f0b\u0f63\u0f72\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SAKST",
               "\u0f66\u0f0b\u0f41\u0f0b\u0f63\u0f72\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u0f54\u0f0b\u0f62\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f60\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PYT",
               "\u0f54\u0f0b\u0f62\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f60\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PYST",
               "\u0f54\u0f0b\u0f62\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f60\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EST",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EDT",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ET",
            };
        final String[] New_Zealand = new String[] {
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NZST",
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NZDT",
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62\u0f0b\u0f42\u0fb1\u0f72\u0f0b\u0f62\u0f92\u0fb1\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0f61\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f40\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YAKT",
               "\u0f61\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f40\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YAKST",
               "\u0f61\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f40\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f64\u0f71\u0f66\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MUT",
               "\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f64\u0f71\u0f66\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MUST",
               "\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f64\u0f71\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EET",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EEST",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f55\u0f60\u0f74\u0f53\u0f4c\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NST",
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f55\u0f60\u0f74\u0f53\u0f4c\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NDT",
               "\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f55\u0f60\u0f74\u0f53\u0f4c\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0f68\u0f55\u0f0b\u0f42\u0f0b\u0f53\u0f72\u0f0b\u0f66\u0f84\u0f4f\u0f71\u0f53\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ART",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ARST",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0f68\u0f7a\u0f4a\u0f0b\u0f63\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f40\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AST",
               "\u0f68\u0f7a\u0f4a\u0f0b\u0f63\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f40\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ADT",
               "\u0f68\u0f7a\u0f4a\u0f0b\u0f63\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f40\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "\u0f56\u0fb7\u0f7c\u0f0b\u0f63\u0f72\u0f0b\u0f56\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0f54\u0f60\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f51\u0f44\u0f0b\u0f58\u0f72\u0f0b\u0f40\u0f72\u0f0b\u0f63\u0f71\u0f7c\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PMST",
               "\u0f54\u0f60\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f51\u0f44\u0f0b\u0f58\u0f72\u0f0b\u0f40\u0f72\u0f0b\u0f63\u0f71\u0f7c\u0f53\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PMDT",
               "\u0f54\u0f60\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f51\u0f44\u0f0b\u0f58\u0f72\u0f0b\u0f40\u0f72\u0f0b\u0f63\u0f71\u0f7c\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f7c\u0f0b\u0f45\u0f71\u0f60\u0f72\u0f0b\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0f61\u0f7a\u0f0b\u0f40\u0f0b\u0f4f\u0f7a\u0f0b\u0f62\u0f72\u0f53\u0f0b\u0f56\u0f62\u0f42\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YEKT",
               "\u0f61\u0f7a\u0f0b\u0f40\u0f0b\u0f4f\u0f7a\u0f0b\u0f62\u0f72\u0f53\u0f0b\u0f56\u0f62\u0f42\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YEKST",
               "\u0f61\u0f7a\u0f0b\u0f40\u0f0b\u0f4f\u0f7a\u0f0b\u0f62\u0f72\u0f53\u0f0b\u0f56\u0f62\u0f42\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0f58\u0f71\u0f63\u0f0b\u0f51\u0f72\u0f56\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Israel = new String[] {
               "\u0f68\u0f72\u0f66\u0f0b\u0f62\u0f7a\u0f63\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IST",
               "\u0f68\u0f72\u0f66\u0f0b\u0f62\u0f7a\u0f63\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IDT",
               "\u0f68\u0f72\u0f66\u0f0b\u0f62\u0f7a\u0f63\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Africa_Southern = new String[] {
               "\u0f63\u0fb7\u0f7c\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Omsk = new String[] {
               "\u0f68\u0f7c\u0f58\u0f66\u0f40\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "OMST",
               "\u0f68\u0f7c\u0f58\u0f66\u0f40\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "OMSST",
               "\u0f68\u0f7c\u0f58\u0f66\u0f40\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0f66\u0f7a\u0f0b\u0f64\u0f71\u0f63\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0f61\u0f74\u0f0b\u0f62\u0f74\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f71\u0f60\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "UYT",
               "\u0f61\u0f74\u0f0b\u0f62\u0f74\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f71\u0f60\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "UYST",
               "\u0f61\u0f74\u0f0b\u0f62\u0f74\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f71\u0f60\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0f53\u0f7a\u0f0b\u0f54\u0f71\u0f63\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] America_Central = new String[] {
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CST",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CDT",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CT",
            };
        final String[] Falkland = new String[] {
               "\u0f55\u0f63\u0f40\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f66\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FKT",
               "\u0f55\u0f63\u0f40\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f66\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FKST",
               "\u0f55\u0f63\u0f40\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FKT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0f53\u0f7c\u0f0b\u0f56\u0f7c\u0f0b\u0f66\u0f72\u0f0b\u0f56\u0f72\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NOVT",
               "\u0f53\u0f7c\u0f0b\u0f56\u0f7c\u0f0b\u0f66\u0f72\u0f0b\u0f56\u0f72\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NOVST",
               "\u0f53\u0f7c\u0f0b\u0f56\u0f7c\u0f0b\u0f66\u0f72\u0f0b\u0f56\u0f72\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "NOVT",
            };
        final String[] Azores = new String[] {
               "\u0f68\u0f7a\u0f0b\u0f5b\u0f7c\u0f62\u0f66\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZOT",
               "\u0f68\u0f7a\u0f0b\u0f5b\u0f7c\u0f62\u0f66\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZOST",
               "\u0f68\u0f7a\u0f0b\u0f5b\u0f7c\u0f62\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZOT",
            };
        final String[] Bhutan = new String[] {
               "\u0f60\u0f56\u0fb2\u0f74\u0f42\u0f0b\u0f61\u0f74\u0f63\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0f66\u0f74\u0f0b\u0f62\u0f72\u0f0b\u0f53\u0f71\u0f58\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0f40\u0f62\u0f66\u0f72\u0f0b\u0f53\u0f7c\u0f0b\u0f61\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KRAT",
               "\u0f40\u0f62\u0f66\u0f72\u0f0b\u0f53\u0f7c\u0f0b\u0f61\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KRAST",
               "\u0f40\u0f62\u0f66\u0f72\u0f0b\u0f53\u0f7c\u0f0b\u0f61\u0f62\u0f66\u0f40\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KRAT",
            };
        final String[] Christmas = new String[] {
               "\u0f41\u0f72\u0f0b\u0f62\u0f72\u0f66\u0f9f\u0f0b\u0f58\u0f7a\u0f66\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0f68\u0f7a\u0f0b\u0f58\u0f0b\u0f5b\u0f71\u0f7c\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMT",
               "\u0f68\u0f7a\u0f0b\u0f58\u0f0b\u0f5b\u0f71\u0f7c\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMST",
               "\u0f68\u0f7a\u0f0b\u0f58\u0f0b\u0f5b\u0f71\u0f7c\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMT",
            };
        final String[] Reunion = new String[] {
               "\u0f62\u0f72\u0f0b\u0f61\u0f74\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Argentina = new String[] {
               "\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ART",
               "\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ARST",
               "\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ART",
            };
        final String[] Galapagos = new String[] {
               "\u0f42\u0f0b\u0f63\u0f0b\u0f54\u0f0b\u0f42\u0f7c\u0f66\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Venezuela = new String[] {
               "\u0f56\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f5b\u0f74\u0f0b\u0f5d\u0f7a\u0f0b\u0f63\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0f67\u0f0b\u0f5d\u0f60\u0f72\u0f0b-\u0f68\u0f7a\u0f0b\u0f63\u0f72\u0f60\u0f74\u0f0b\u0f64\u0f7a\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "HAST",
               "\u0f67\u0f0b\u0f5d\u0f60\u0f72\u0f0b-\u0f68\u0f7a\u0f0b\u0f63\u0f72\u0f60\u0f74\u0f0b\u0f64\u0f7a\u0f53\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "HADT",
               "\u0f67\u0f0b\u0f5d\u0f60\u0f72\u0f0b-\u0f68\u0f7a\u0f0b\u0f63\u0f72\u0f60\u0f74\u0f0b\u0f64\u0f7a\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACST",
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACDT",
               "\u0f51\u0f56\u0f74\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f54\u0f7a\u0f0b\u0f66\u0f72\u0f0b\u0f55\u0f72\u0f42\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PST",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f54\u0f7a\u0f0b\u0f66\u0f72\u0f0b\u0f55\u0f72\u0f42\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PDT",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f54\u0f7a\u0f0b\u0f66\u0f72\u0f0b\u0f55\u0f72\u0f42\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WET",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WEST",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f61\u0f74\u0f0b\u0f62\u0f7c\u0f0b\u0f54\u0f7a\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0f40\u0f7a\u0f54\u0f0b\u0f56\u0f71\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CVT",
               "\u0f40\u0f7a\u0f54\u0f0b\u0f56\u0f71\u0f4c\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CVST",
               "\u0f40\u0f7a\u0f54\u0f0b\u0f56\u0f71\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CVT",
            };
        final String[] Guyana = new String[] {
               "\u0f42\u0f74\u0f0b\u0f61\u0f0b\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0f68\u0f0b\u0f5b\u0f62\u0f0b\u0f56\u0fb7\u0f60\u0f72\u0f0b\u0f47\u0f71\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZT",
               "\u0f68\u0f0b\u0f5b\u0f62\u0f0b\u0f56\u0fb7\u0f60\u0f72\u0f0b\u0f47\u0f71\u0f53\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZST",
               "\u0f68\u0f0b\u0f5b\u0f62\u0f0b\u0f56\u0fb7\u0f60\u0f72\u0f0b\u0f47\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AZT",
            };
        final String[] Cuba = new String[] {
               "\u0f40\u0f72\u0f60\u0f74\u0f0b\u0f56\u0fb7\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CST",
               "\u0f40\u0f72\u0f60\u0f74\u0f0b\u0f56\u0fb7\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CDT",
               "\u0f40\u0f72\u0f60\u0f74\u0f0b\u0f56\u0fb7\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WAT",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WAST",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f5d\u0f72\u0f46\u0f0b\u0f63\u0f74\u0f0b\u0f61\u0f7c\u0f51\u0f0b\u0f54\u0f60\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Iran = new String[] {
               "\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRST",
               "\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f53\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRDT",
               "\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0f68\u0f72\u0f66\u0f72\u0f0b\u0f4a\u0f62\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EAST",
               "\u0f68\u0f72\u0f66\u0f72\u0f0b\u0f4a\u0f62\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EASST",
               "\u0f68\u0f72\u0f66\u0f72\u0f0b\u0f4a\u0f62\u0f0b\u0f68\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EAST",
            };
        final String[] Bangladesh = new String[] {
               "\u0f56\u0f44\u0f92\u0f0b\u0f63\u0f0b\u0f51\u0f7a\u0f64\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BDT",
               "\u0f56\u0f44\u0f92\u0f0b\u0f63\u0f0b\u0f51\u0f7a\u0f64\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BDST",
               "\u0f56\u0f44\u0f92\u0f0b\u0f63\u0f0b\u0f51\u0f7a\u0f64\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u0f54\u0f0b\u0f62\u0f74\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PET",
               "\u0f54\u0f0b\u0f62\u0f74\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PEST",
               "\u0f54\u0f0b\u0f62\u0f74\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WGT",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WGST",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0f68\u0f7a\u0f0b\u0f40\u0f74\u0f0b\u0f4c\u0f7d\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EGT",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EGST",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0f42\u0f71\u0f63\u0f55\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KST",
               "\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KDT",
               "\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AWST",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AWDT",
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AWT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AEST",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AEDT",
               "\u0f64\u0f62\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0f55\u0f72\u0f62\u0f7a\u0f53\u0f45\u0f0b\u0f42\u0f72\u0f0b\u0f61\u0f0b\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0f40\u0f7c\u0f0b\u0f63\u0f7c\u0f58\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "COT",
               "\u0f40\u0f7c\u0f0b\u0f63\u0f7c\u0f58\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "COST",
               "\u0f40\u0f7c\u0f0b\u0f63\u0f7c\u0f58\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0f45\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CLT",
               "\u0f45\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CLST",
               "\u0f45\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CLT",
            };
        final String[] America_Mountain = new String[] {
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f58\u0f60\u0f74\u0f0b\u0f4a\u0f7a\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MST",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f58\u0f60\u0f74\u0f0b\u0f4a\u0f7a\u0f53\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MDT",
               "\u0f56\u0fb1\u0f44\u0f0b\u0f68\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f0b\u0f58\u0f60\u0f74\u0f0b\u0f4a\u0f7a\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u0f68\u0f0b\u0f62\u0f7a\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f53\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AST",
               "\u0f68\u0f0b\u0f62\u0f7a\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "ADT",
               "\u0f68\u0f0b\u0f62\u0f7a\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0f68\u0f0b\u0f63\u0f66\u0f72\u0f0b\u0f40\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AKST",
               "\u0f68\u0f0b\u0f63\u0f66\u0f72\u0f0b\u0f40\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AKDT",
               "\u0f68\u0f0b\u0f63\u0f66\u0f72\u0f0b\u0f40\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0f56\u0f0b\u0f63\u0f0b\u0f4c\u0f72\u0f0b\u0f56\u0f7c\u0f66\u0f72\u0f0b\u0f4f\u0f7c\u0f40\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "VLAT",
               "\u0f56\u0f0b\u0f63\u0f0b\u0f4c\u0f72\u0f0b\u0f56\u0f7c\u0f66\u0f72\u0f0b\u0f4f\u0f7c\u0f40\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "VLAST",
               "\u0f56\u0f0b\u0f63\u0f0b\u0f4c\u0f72\u0f0b\u0f56\u0f7c\u0f66\u0f72\u0f0b\u0f4f\u0f7c\u0f40\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "VLAT",
            };
        final String[] Irkutsk = new String[] {
               "\u0f68\u0f62\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRKT",
               "\u0f68\u0f62\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRKST",
               "\u0f68\u0f62\u0f0b\u0f40\u0f74\u0f59\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u0f47\u0f7d\u0f0b\u0f47\u0f71\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GET",
               "\u0f47\u0f7d\u0f0b\u0f47\u0f71\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GEST",
               "\u0f47\u0f7d\u0f0b\u0f47\u0f71\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "GET",
            };
        final String[] Noronha = new String[] {
               "\u0f55\u0f62\u0f0b\u0f53\u0f7a\u0f53\u0f0b\u0f4c\u0f7c\u0f0b \u0f4c\u0f72\u0f0b \u0f53\u0f7c\u0f0b\u0f62\u0f71\u0f7c\u0f53\u0f0b\u0f67\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FNT",
               "\u0f55\u0f62\u0f0b\u0f53\u0f7a\u0f53\u0f0b\u0f4c\u0f7c\u0f0b \u0f4c\u0f72\u0f0b \u0f53\u0f7c\u0f0b\u0f62\u0f71\u0f7c\u0f53\u0f0b\u0f67\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FNST",
               "\u0f55\u0f62\u0f0b\u0f53\u0f7a\u0f53\u0f0b\u0f4c\u0f7c\u0f0b \u0f4c\u0f72\u0f0b \u0f53\u0f7c\u0f0b\u0f62\u0f71\u0f7c\u0f53\u0f0b\u0f67\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "FNT",
            };
        final String[] Brasilia = new String[] {
               "\u0f56\u0fb2\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BRT",
               "\u0f56\u0fb2\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BRST",
               "\u0f56\u0fb2\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0f62\u0f92\u0fb1\u0f0b\u0f53\u0f42\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CST",
               "\u0f62\u0f92\u0fb1\u0f0b\u0f53\u0f42\u0f0b\u0f49\u0f72\u0f53\u0f0b\u0f66\u0fb2\u0f74\u0f44\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CDT",
               "\u0f62\u0f92\u0fb1\u0f0b\u0f53\u0f42\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0f68\u0f62\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f0b\u0f5a\u0f51\u0f0b\u0f63\u0fa1\u0f53\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMT",
               "\u0f68\u0f62\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMST",
               "\u0f68\u0f62\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "AMT",
            };
        final String[] India = new String[] {
               "\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f5d\u0f72\u0f46\u0f0b\u0f63\u0f74\u0f0b\u0f61\u0f7c\u0f51\u0f0b\u0f54\u0f60\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
                    "GMT",
                    "\u0f56\u0fb2\u0f71\u0f72\u0f0b\u0f4a\u0f72\u0f64\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Europe/Dublin",
                new String[] {
                    "\u0f42\u0f72\u0f62\u0f72\u0f53\u0f0b\u0f5d\u0f72\u0f46\u0f0b\u0f63\u0f74\u0f0b\u0f61\u0f7c\u0f51\u0f0b\u0f54\u0f60\u0f72\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
                    "GMT",
                    "\u0f68\u0f71\u0f0b\u0f61\u0f62\u0f72\u0f64\u0f0b\u0f56\u0fb1\u0f71\u0f62\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
