<TeXmacs|1.0.1.18>

<style|<tuple|tmdoc|maxima>>

<\body>
  <\expand|tmdoc-title>
    Utilizzare sessioni di Maxima in <TeXmacs>
  </expand>

  <name|Maxima>  un popolare sistema di computer algebra. Si pu scaricare
  le distribuzioni pi aggiornate dei codici sorgenti e binari da

  <\verbatim>
    \ \ \ \ http://maxima.sf.net
  </verbatim>

  La procedura di installazione dai sorgenti  ancora piuttosto instabile,
  pertanto raccomandiamo di usare le distribuzioni binarie o i pacchetti rpm.
  Qui di seguito  riportata un esempio di sessione, che si inizia usando
  <apply|menu|Insert|Session|Maxima>:

  <\session|maxima|default>
    <\output>
      GCL (GNU Common Lisp) \ Version(2.4.4) g@ \ 2 17 15:25:31 CST 2003

      Licensed under GNU Library General Public License

      Contains Enhancements by W. Schelter

      Maxima 5.9.0 http://maxima.sourceforge.net

      Distributed under the GNU Public License. See the file COPYING.

      Dedicated to the memory of William Schelter.

      This is a development version of Maxima. The function bug_report()

      provides bug reporting information.

      \;
    </output>

    <\input|<\with|color|red>
      (C1) <with|color|black|>
    </with>>
      f(x):=x+sin(x)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D1) <with|color|black|>>f<left|(>x<right|)>:=x+sin
        x>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C2) <with|color|black|>
    </with>>
      diff(f(x),x)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D2) <with|color|black|>>cos x+1>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C3) <with|color|black|>
    </with>>
      integrate(f(x),x)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D3) <with|color|black|>><frac|x<rsup|2>|2>-cos
        x>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C4) <with|color|black|>
    </with>>
      plot2d(f(x),[x,-10,10]);
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D4) <with|color|black|>>0>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C5) <with|color|black|>
    </with>>
      \;
    </input>
  </session>

  Il grafico prodotto in <verbatim|<with|color|red|(C4)>> viene visualizzato
  in una finestra popup, al di fuori del foglio di lavoro. Per inserire il
  grafico nel proprio documento <TeXmacs>, si deve salvarlo come file
  postscript o catturare l'immagine e usare <apply|menu|Insert|Image>:

  <\expand|big-figure>
    <postscript|<tuple|<raw_data|%!PS-Adobe-3.0 EPSF-3.0\n%%Creator: GIMP
    PostScript file plugin V 1.12 by Peter Kirchgessner\n%%Title:
    /home/cchuang/3.eps\n%%CreationDate: Thu Jul 10 06:51:35
    2003\n%%DocumentData: Clean7Bit\n%%LanguageLevel: 2\n%%Pages:
    1\n%%BoundingBox: 14 14 533 547\n%%EndComments\n%%BeginProlog\n% Use own
    dictionary to avoid conflicts\n10 dict begin\n%%EndProlog\n%%Page: 1 1\n%
    Translate for offset\n14.173228 14.173228 translate\n% Translate to begin
    of first scanline\n0.000000 532.000000 translate\n518.000000 -532.000000
    scale\n% Image geometry\n518 532 8\n% Transformation matrix\n[ 518 0 0
    532 0 0 ]\n% Strings to hold RGB-samples per scanline\n/rstr 518 string
    def\n/gstr 518 string def\n/bstr 518 string def\n{currentfile
    /ASCII85Decode filter /RunLengthDecode filter rstr readstring
    pop}\n{currentfile /ASCII85Decode filter /RunLengthDecode filter gstr
    readstring pop}\n{currentfile /ASCII85Decode filter /RunLengthDecode
    filter bstr readstring pop}\ntrue 3\n%%BeginData: \ \ \ \ \ \ \ 68492
    ASCII Bytes\ncolorimage\nrH!MiJH16$JcPdkJ,~\>\nrH!MiJH16$JcPdkJ,~\>\nrH!MiJH16$JcPdkJ,~\>\ns3UcGoD\\g*JcC\<$JcEjl!5H_Wrr\<*"d!u~\>\ns3UcGoD\\g*JcC\<$JcEjl!5H_Wrr\<*"d!u~\>\ns3UcGoD\\g*JcC\<$JcEjl!5H_Wrr\<*"d!u~\>\n!RLi9eUc;&eq)DoecEP:nC@QinC@Qio%!d?rr@Q~\>\n!RLi9eUc;&eq)DoecEP:nC@QinC@Qio%!d?rr@Q~\>\n!RLi9eUc;&eq)DoecEP:nC@QinC@Qio%!d?rr@Q~\>\n!RLi9e:H/$eUc8meH*G8nC7KgnC7Kgn^IX?!!%N~\>\n!RLi9e:H/$eUc8meH*G8nC7KgnC7Kgn^IX?!!%N~\>\n!RLi9e:H/$eUc8meH*G8nC7KgnC7Kgn^IX?!!%N~\>\n!\<E/hdt-#"e:H,ke,d\>6nC.EenC.Een^IO\<!!%N~\>\n!\<E/hdt-#"e:H,ke,d\>6nC.EenC.Een^IO\<!!%N~\>\n!\<E/hdt-#"e:H,ke,d\>6nC.EenC.Een^IO\<!!%N~\>\n!\<E/hdf%Vrd)XH+dfIeCo@!]akL0FRmF)-^a3jb4!7(Dh!7Cem!7Leo!6scWs3Lepd/MG\\df@[E\ndt-!6dfI54nC%?crR1Lor6kVorR1^urR1^urR1`G!!%N~\>\n!\<E/hdf%Vrd)XH+dfIeCo@!]akL0FRmF)-^a3jb4!7(Dh!7Cem!7Leo!6scWs3Lepd/MG\\df@[E\ndt-!6dfI54nC%?crR1Lor6kVorR1^urR1^urR1`G!!%N~\>\n!\<E/hdf%Vrd)XH+dfIeCo@!]akL0FRmF)-^a3jb4!7(Dh!7Cem!7Leo!6scWs3Lepd/MG\\df@[E\ndt-!6dfI54nC%?crR1Lor6kVorR1^urR1^urR1`G!!%N~\>\n!\<E0!dJnjrdJnjtdJhPsX00+6TD?n:^4ju-dK71aS,C\\8bg5_*!KYXsdKHqd]r/@\<dK7aaVtnaJ\n`/M%7Y,9Up^T3jsdK.S\<pX0DST$*54\\\\ceC`iA[Z!md@6J^T+tld\>gKddYZadf.YgKDj3tdf.Ym\nKE'?tKDj0urr@Q~\>\n!\<E0!dJnjrdJnjtdJhPsX00+6TD?n:^4ju-dK71aS,C\\8bg5_*!KYXsdKHqd]r/@\<dK7aaVtnaJ\n`/M%7Y,9Up^T3jsdK.S\<pX0DST$*54\\\\ceC`iA[Z!md@6J^T+tld\>gKddYZadf.YgKDj3tdf.Ym\nKE'?tKDj0urr@Q~\>\n!\<E0!dJnjrdJnjtdJhPsX00+6TD?n:^4ju-dK71aS,C\\8bg5_*!KYXsdKHqd]r/@\<dK7aaVtnaJ\n`/M%7Y,9Up^T3jsdK.S\<pX0DST$*54\\\\ceC`iA[Z!md@6J^T+tld\>gKddYZadf.YgKDj3tdf.Ym\nKE'?tKDj0urr@Q~\>\n!s&AJd/AUqd/AUrd/VJo_P7%W!4)CI!L_=-d/qY7RJbG5W6+JT!2K#1!PbK1d/fZ]rQtY_VteX\>\nRf:\\\<Z+&-,a-lVJ!N=-7d0e*ed?VV\\d*^7c_"5qS_P_t4J^Nf2!Pd%Od/VMmd.`1kd/VMmd.`1k\nciO.HJ,~\>\n!s&AJd/AUqd/AUrd/VJo_P7%W!4)CI!L_=-d/qY7RJbG5W6+JT!2K#1!PbK1d/fZ]rQtY_VteX\>\nRf:\\\<Z+&-,a-lVJ!N=-7d0e*ed?VV\\d*^7c_"5qS_P_t4J^Nf2!Pd%Od/VMmd.`1kd/VMmd.`1k\nciO.HJ,~\>\n!s&AJd/AUqd/AUrd/VJo_P7%W!4)CI!L_=-d/qY7RJbG5W6+JT!2K#1!PbK1d/fZ]rQtY_VteX\>\nRf:\\\<Z+&-,a-lVJ!N=-7d0e*ed?VV\\d*^7c_"5qS_P_t4J^Nf2!Pd%Od/VMmd.`1kd/VMmd.`1k\nciO.HJ,~\>\n!s&AIchrFqchrFpci;\>n`fS7\<ck*pp\\BiOKS'Ja`cd:%b\\?`sKciBI4cjRmkKsJ5)d*U+KZGHOe\n"N/\<uYK6^i!5\\T["OFZb^!HN$!Q_nPcj-#ad*T\\@\\u,8L!1No6!NEg4ciBI3cjS12[DC5:a/4Qr\n\\A@se"IRN.[^uIb!R84Tciqb.cEt%+rm2:q\\[nZbd*K;2_9gQ\>\\]:nq^;PTLJ^F8?!Pd"Nci;Ak\nchE(jci;AjchW4kcN4%GJ,~\>\n!s&AIchrFqchrFpci;\>n`fS7\<ck*pp\\BiOKS'Ja`cd:%b\\?`sKciBI4cjRmkKsJ5)d*U+KZGHOe\n"N/\<uYK6^i!5\\T["OFZb^!HN$!Q_nPcj-#ad*T\\@\\u,8L!1No6!NEg4ciBI3cjS12[DC5:a/4Qr\n\\A@se"IRN.[^uIb!R84Tciqb.cEt%+rm2:q\\[nZbd*K;2_9gQ\>\\]:nq^;PTLJ^F8?!Pd"Nci;Ak\nchE(jci;AjchW4kcN4%GJ,~\>\n!s&AIchrFqchrFpci;\>n`fS7\<ck*pp\\BiOKS'Ja`cd:%b\\?`sKciBI4cjRmkKsJ5)d*U+KZGHOe\n"N/\<uYK6^i!5\\T["OFZb^!HN$!Q_nPcj-#ad*T\\@\\u,8L!1No6!NEg4ciBI3cjS12[DC5:a/4Qr\n\\A@se"IRN.[^uIb!R84Tciqb.cEt%+rm2:q\\[nZbd*K;2_9gQ\>\\]:nq^;PTLJ^F8?!Pd"Nci;Ak\nchE(jci;AjchW4kcN4%GJ,~\>\n!\<E0!cM)ticMl--]p"qqcHjh6\\&tk^cd/)`[%jtRc_/,"Z+0bY!1\<]1!MRU5cO6D^cEXn*`K."0\n[[m3\>"JrlZ^SpkP$-o``cd/c.cF'PEcNKZI\\$)t5cN'@2cNL&\\cEX\\ScN0`\\p\<O&7`O)YVcd04s\nR/YDN]8E`)X0BprY.i2hVU*Sa_ToElcbQR,SBn^jJ^8nnqTf2Wcg]6[ci22iKDEdmKDj*qchu)c\nKDWpprr@Q~\>\n!\<E0!cM)ticMl--]p"qqcHjh6\\&tk^cd/)`[%jtRc_/,"Z+0bY!1\<]1!MRU5cO6D^cEXn*`K."0\n[[m3\>"JrlZ^SpkP$-o``cd/c.cF'PEcNKZI\\$)t5cN'@2cNL&\\cEX\\ScN0`\\p\<O&7`O)YVcd04s\nR/YDN]8E`)X0BprY.i2hVU*Sa_ToElcbQR,SBn^jJ^8nnqTf2Wcg]6[ci22iKDEdmKDj*qchu)c\nKDWpprr@Q~\>\n!\<E0!cM)ticMl--]p"qqcHjh6\\&tk^cd/)`[%jtRc_/,"Z+0bY!1\<]1!MRU5cO6D^cEXn*`K."0\n[[m3\>"JrlZ^SpkP$-o``cd/c.cF'PEcNKZI\\$)t5cN'@2cNL&\\cEX\\ScN0`\\p\<O&7`O)YVcd04s\nR/YDN]8E`)X0BprY.i2hVU*Sa_ToElcbQR,SBn^jJ^8nnqTf2Wcg]6[ci22iKDEdmKDj*qchu)c\nKDWpprr@Q~\>\n!\<E/uc2!"ic2Golc+fd\>c,H@Qc3p)acG$7&^nSfe_jUJK!1\<]0!MIL4c4%L_`Po`_cH`E!cHa]0\nc30cFaNhp%c3h[o_9U?DVU!K(V\>/=;R**YMc2a72c2k_ZrltM2rltP;a7dd]W3+14\\c'eRR/P;?\nR*O!lVp\<2WcHa;'cG6CXc3K`^c(3(@agZiHJ^4):!PcqLc2Z)gblEClblECpc2Z)ec23.jblRhE\nJ,~\>\n!\<E/uc2!"ic2Golc+fd\>c,H@Qc3p)acG$7&^nSfe_jUJK!1\<]0!MIL4c4%L_`Po`_cH`E!cHa]0\nc30cFaNhp%c3h[o_9U?DVU!K(V\>/=;R**YMc2a72c2k_ZrltM2rltP;a7dd]W3+14\\c'eRR/P;?\nR*O!lVp\<2WcHa;'cG6CXc3K`^c(3(@agZiHJ^4):!PcqLc2Z)gblEClblECpc2Z)ec23.jblRhE\nJ,~\>\n!\<E/uc2!"ic2Golc+fd\>c,H@Qc3p)acG$7&^nSfe_jUJK!1\<]0!MIL4c4%L_`Po`_cH`E!cHa]0\nc30cFaNhp%c3h[o_9U?DVU!K(V\>/=;R**YMc2a72c2k_ZrltM2rltP;a7dd]W3+14\\c'eRR/P;?\nR*O!lVp\<2WcHa;'cG6CXc3K`^c(3(@agZiHJ^4):!PcqLc2Z)gblEClblECpc2Z)ec23.jblRhE\nJ,~\>\n!\<E/tbkm%ibl\>og^\<HT$".[3?WVapFR`s$iVp2ZIrk8BLrQP\>0r6588`r=3`[\\j&\<"N&F.WkA#L\n"O"*CQF-G3!lM4crlkVVY0G5-V\>/:8RJG)-R/Y\>2Za'MS"e!TZc(N)MblkJGc'Z*@blF.0bmp/d\nc+^("\\?=*$_55D_Z2VuQREWpI]!8]SJ^&bjq98rTc2Gl^KD`snc2PoeKDE^kKDj$oc2Gl^KD`po\nrr@Q~\>\n!\<E/tbkm%ibl\>og^\<HT$".[3?WVapFR`s$iVp2ZIrk8BLrQP\>0r6588`r=3`[\\j&\<"N&F.WkA#L\n"O"*CQF-G3!lM4crlkVVY0G5-V\>/:8RJG)-R/Y\>2Za'MS"e!TZc(N)MblkJGc'Z*@blF.0bmp/d\nc+^("\\?=*$_55D_Z2VuQREWpI]!8]SJ^&bjq98rTc2Gl^KD`snc2PoeKDE^kKDj$oc2Gl^KD`po\nrr@Q~\>\n!\<E/tbkm%ibl\>og^\<HT$".[3?WVapFR`s$iVp2ZIrk8BLrQP\>0r6588`r=3`[\\j&\<"N&F.WkA#L\n"O"*CQF-G3!lM4crlkVVY0G5-V\>/:8RJG)-R/Y\>2Za'MS"e!TZc(N)MblkJGc'Z*@blF.0bmp/d\nc+^("\\?=*$_55D_Z2VuQREWpI]!8]SJ^&bjq98rTc2Gl^KD`snc2PoeKDE^kKDj$oc2Gl^KD`po\nrr@Q~\>\n!\<E/sbPd(ibQ#ce[]KJP'r8afRENgua3;brbKRVsbeommbfmQpbQ+"-bRU;`be)'9R`iq!\\'3'q\n]CsGP`js=;bEVhH!QqMCbQkf)`Lb;t^ngbL!1\<T+!13]/"i7"YbfcLTbQOTVbe)'obQPhNb`p*F\nbQ+".bScelbeBsu`Lb;t^nf2jUs.'+S'9*UX2U@FJ]r\\hq9/lSbl5f[KDj!nbl5ccKDE[jKDj!n\nbl5f[KDisorr@Q~\>\n!\<E/sbPd(ibQ#ce[]KJP'r8afRENgua3;brbKRVsbeommbfmQpbQ+"-bRU;`be)'9R`iq!\\'3'q\n]CsGP`js=;bEVhH!QqMCbQkf)`Lb;t^ngbL!1\<T+!13]/"i7"YbfcLTbQOTVbe)'obQPhNb`p*F\nbQ+".bScelbeBsu`Lb;t^nf2jUs.'+S'9*UX2U@FJ]r\\hq9/lSbl5f[KDj!nbl5ccKDE[jKDj!n\nbl5f[KDisorr@Q~\>\n!\<E/sbPd(ibQ#ce[]KJP'r8afRENgua3;brbKRVsbeommbfmQpbQ+"-bRU;`be)'9R`iq!\\'3'q\n]CsGP`js=;bEVhH!QqMCbQkf)`Lb;t^ngbL!1\<T+!13]/"i7"YbfcLTbQOTVbe)'obQPhNb`p*F\nbQ+".bScelbeBsu`Lb;t^nf2jUs.'+S'9*UX2U@FJ]r\\hq9/lSbl5f[KDj!nbl5ccKDE[jKDj!n\nbl5f[KDisorr@Q~\>\n!\<E/rb5[+ib5]X.b,D)?V5;AYZ_"A#[`cRK\\'(b;`lkKPVkq,Nah"R0[(lU`&$q_(Yfk4lRAZmq\nbJ076`:h@WW2mD+Xng-K[@!SXQ^u=CY,AJ!R/+o-]o'&9rlY_l\\u^^p^WXg&Xh(@BrlYDMR]3Od\nb9kB1bGED*b.P$=]"cG(MS@95QH%+NVlun`bKI#i\\u!*`bIXq$Tn1C\<bP96]^WZW!pOiFes3(Da\n!/(*i!/(6ms3(DarIb-mrIb'k!WN.M~\>\n!\<E/rb5[+ib5]X.b,D)?V5;AYZ_"A#[`cRK\\'(b;`lkKPVkq,Nah"R0[(lU`&$q_(Yfk4lRAZmq\nbJ076`:h@WW2mD+Xng-K[@!SXQ^u=CY,AJ!R/+o-]o'&9rlY_l\\u^^p^WXg&Xh(@BrlYDMR]3Od\nb9kB1bGED*b.P$=]"cG(MS@95QH%+NVlun`bKI#i\\u!*`bIXq$Tn1C\<bP96]^WZW!pOiFes3(Da\n!/(*i!/(6ms3(DarIb-mrIb'k!WN.M~\>\n!\<E/rb5[+ib5]X.b,D)?V5;AYZ_"A#[`cRK\\'(b;`lkKPVkq,Nah"R0[(lU`&$q_(Yfk4lRAZmq\nbJ076`:h@WW2mD+Xng-K[@!SXQ^u=CY,AJ!R/+o-]o'&9rlY_l\\u^^p^WXg&Xh(@BrlYDMR]3Od\nb9kB1bGED*b.P$=]"cG(MS@95QH%+NVlun`bKI#i\\u!*`bIXq$Tn1C\<bP96]^WZW!pOiFes3(Da\n!/(*i!/(6ms3(DarIb-mrIb'k!WN.M~\>\n!\<E/hao0?`ahc!qaooi&aND[)aT0K_aoBKda25s@b59\<Zb5]HZaooc%ai_d)an\<dXahc!lb59\<[\naofZ%aN"%urQ5&]qoSi[!lr*ur6#&Yp\<!N[b/qfKqoJi\\rlG/_rlP2_"3/:#`r=*^a2#grb5]Qa\nb/o4WJ]dc1!PceUan^SeaoBN^an^SeaoBN^ao@"lao@"kaT;DAJ,~\>\n!\<E/hao0?`ahc!qaooi&aND[)aT0K_aoBKda25s@b59\<Zb5]HZaooc%ai_d)an\<dXahc!lb59\<[\naofZ%aN"%urQ5&]qoSi[!lr*ur6#&Yp\<!N[b/qfKqoJi\\rlG/_rlP2_"3/:#`r=*^a2#grb5]Qa\nb/o4WJ]dc1!PceUan^SeaoBN^an^SeaoBN^ao@"lao@"kaT;DAJ,~\>\n!\<E/hao0?`ahc!qaooi&aND[)aT0K_aoBKda25s@b59\<Zb5]HZaooc%ai_d)an\<dXahc!lb59\<[\naofZ%aN"%urQ5&]qoSi[!lr*ur6#&Yp\<!N[b/qfKqoJi\\rlG/_rlP2_"3/:#`r=*^a2#grb5]Qa\nb/o4WJ]dc1!PceUan^SeaoBN^an^SeaoBN^ao@"lao@"kaT;DAJ,~\>\n!\<E/haFVHaaaqRUaT9/unAtXOnAtXOnAkY1!.Y~\>\n!\<E/haFVHaaaqRUaT9/unAtXOnAtXOnAkY1!.Y~\>\n!\<E/haFVHaaaqRUaT9/unAtXOnAtXOnAkY1!.Y~\>\n!\<E/ha+;\<_aFVFSa8s&snAkRMnAkRMnAbS0!.Y~\>\n!\<E/ha+;\<_aFVFSa8s&snAkRMnAkRMnAbS0!.Y~\>\n!\<E/ha+;\<_aFVFSa8s&snAkRMnAkRMnAbS0!.Y~\>\n!\<E/h`du0]a+;:Q`rWrqnAbLKnAbLKnAYM/!.Y~\>\n!\<E/h`du0]a+;:Q`rWrqnAbLKnAbLKnAYM/!.Y~\>\n!\<E/h`du0]a+;:Q`rWrqnAbLKnAbLKnAYM/!.Y~\>\n!\<E/h`IZ$[`du.O`W\<ionAYFInAYFInAPG.!.Y~\>\n!\<E/h`IZ$[`du.O`W\<ionAYFInAYFInAPG.!.Y~\>\n!\<E/h`IZ$[`du.O`W\<ionAYFInAYFInAPG.!.Y~\>\n!!%RkJTHB`JTLd2!!%N~\>\n!!%RkJTHB`JTLd2!!%N~\>\n!!%RkJTHB`JTLd2!!%N~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+13$s+gUXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrrN3#s8E#qs8E#ts8E#qs8E#qs8E#us82lsrr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrrN3#s8E#qs8E#ts8E#qs8E#qs8E#us82lsrr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrrN3#s8E#qs8E#ts8E#qs8E#qs8E#us82lsrr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJtrrW9$rrE&u!!)ut!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#\nJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJtrrW9$rrE&u!!)ut!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#\nJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJtrrW9$rrE&u!!)ut!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#\nJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJtrrW9$rrDlp!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#JcCQ+\n"`s_+k&UNQ~\>\n!\<E0!joBJtrrW9$rrDlp!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#JcCQ+\n"`s_+k&UNQ~\>\n!\<E0!joBJtrrW9$rrDlp!!*#u!W`6#rr2rurVlitrr2rurVlitrr3$"rrDoq!!%TM^&J)#JcCQ+\n"`s_+k&UNQ~\>\n!\<E0!joBJurr\<&urrW9$!!)orrW)uu!!*#u!!)ut!!*#u!!)ut!!*#u!\<E/u!;uis!.k0arrAI\<\ns+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urrW9$!!)orrW)uu!!*#u!!)ut!!*#u!!)ut!!*#u!\<E/u!;uis!.k0arrAI\<\ns+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urrW9$!!)orrW)uu!!*#u!!)ut!!*#u!!)ut!!*#u!\<E/u!;uis!.k0arrAI\<\ns+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&us8N*!rr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&us8N*!rr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&us8N*!rr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<2uu!;uis!\<)ot!.k0a\nrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<3!"!\<3&urr\<&trr\<%M\ns1\\L5R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<3!"!\<3&urr\<&trr\<%M\ns1\\L5R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJurr\<&urr\<&urr\<&trr\<&urrN3#!\<2uu!\<)ot!\<2uu!\<)ot!\<3!"!\<3&urr\<&trr\<%M\ns1\\L5R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&us8E#trrN3#s8E#ts8E#trrN3#s8E#trrN3#s8E#ts8E#srr\<%Ms1SF4R=YBo\nrrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&us8E#trrN3#s8E#ts8E#trrN3#s8E#trrN3#s8E#ts8E#srr\<%Ms1SF4R=YBo\nrrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&us8E#trrN3#s8E#ts8E#trrN3#s8E#trrN3#s8E#ts8E#srr\<%Ms1SF4R=YBo\nrrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&`rr\<&`rr\<%Ms1SF4R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&`rr\<&`rr\<%Ms1SF4R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJtrr\<&`rr\<&`rr\<%Ms1SF4R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrr\<&brr\<&`rr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrr\<&brr\<&`rr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJsrr\<&brr\<&`rr\<%Ms1J@3R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCCs8)fQrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCCs8)fQrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus!!)ut!!)or!!%TM_#FD&JcEUen,V,@"`s_+k&UNQ~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus!!)ut!!)or!!%TM_#FD&JcEUen,V,@"`s_+k&UNQ~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus!!)ut!!)or!!%TM_#FD&JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJ\\rr\<&trs&Q(rrE*!!!)ut!!*#u!!)ip!!%TM_\>aM'JcEdjquFe;"`s_+k&UNQ~\>\n!\<E0!joBJ\\rr\<&trs&Q(rrE*!!!)ut!!*#u!!)ip!!%TM_\>aM'JcEdjquFe;"`s_+k&UNQ~\>\n!\<E0!joBJ\\rr\<&trs&Q(rrE*!!!)ut!!*#u!!)ip!!%TM_\>aM'JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJ\\rr\<&qrriE&rrE'!rr2rurr3$"rrE#t!W`6#q#:\<orVlitJcF*s!1AE\<bQ%J?_uBm]\ns5rHb!.Y~\>\n!\<E0!joBJ\\rr\<&qrriE&rrE'!rr2rurr3$"rrE#t!W`6#q#:\<orVlitJcF*s!1AE\<bQ%J?_uBm]\ns5rHb!.Y~\>\n!\<E0!joBJ\\rr\<&qrriE&rrE'!rr2rurr3$"rrE#t!W`6#q#:\<orVlitJcF*s!1AE\<M#RX"s5rHb\n!.Y~\>\n!\<E0!joBJ[s8N)srriE&rrE'!rr3'#s8N)urrW9$rrE&u!!)ut!!)ut!s&B$!.k0rrrAI\<s3:TC\n!5JO;F8tCbEr^^~\>\n!\<E0!joBJ[s8N)srriE&rrE'!rr3'#s8N)urrW9$rrE&u!!)ut!!)ut!s&B$!.k0rrrAI\<s3:TC\n!5JO;F8tCbEr^^~\>\n!\<E0!joBJ[s8N)srriE&rrE'!rr3'#s8N)urrW9$rrE&u!!)ut!!)ut!s&B$!.k0rrrAI\<s+p[Y\nF8tCbEr^^~\>\n!\<E0!joBJYs8N)ursSo-rrE*!!\<\<'!s8N)ts8N)trr\<&trr\<&ss8N(Ms3CWER=YCas8N)3rrmKD\nk2p^bJ,~\>\n!\<E0!joBJYs8N)ursSo-rrE*!!\<\<'!s8N)ts8N)trr\<&trr\<&ss8N(Ms3CWER=YCas8N)3rrmKD\nk2p^bJ,~\>\n!\<E0!joBJYs8N)ursSo-rrE*!!\<\<'!s8N)ts8N)trr\<&trr\<&ss8N(Ms3CWER=YBorrmKDk2p^b\nJ,~\>\n!\<E0!joBJWrrrK'rrE*!!\<3!%!\<3'!rrE#trrE#t!W`9#quH`rrr@WMcMmm4JcF-trrBY1"`s_+\nk&UNQ~\>\n!\<E0!joBJWrrrK'rrE*!!\<3!%!\<3'!rrE#trrE#t!W`9#quH`rrr@WMcMmm4JcF-trrBY1"`s_+\nk&UNQ~\>\n!\<E0!joBJWrrrK'rrE*!!\<3!%!\<3'!rrE#trrE#t!W`9#quH`rrr@WMcMmm4JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBJps7-0frr\<&trrrK'rrE*!!\<3!%!\<3'!rrE&u!s&B$!\<2uu!\<)ot!\<)p"!\<\<'!JcF'r\n!1AE\<df0:I\\Gl_Rs5rHb!.Y~\>\n!\<E0!joBJps7-0frr\<&trrrK'rrE*!!\<3!%!\<3'!rrE&u!s&B$!\<2uu!\<)ot!\<)p"!\<\<'!JcF'r\n!1AE\<df0:I\\Gl_Rs5rHb!.Y~\>\n!\<E0!joBJ\\rr\<&trrrK'rrE*!!\<3!%!\<3'!rrE&u!s&B$!\<2uu!\<)ot!\<)p"!\<\<'!JcF'r!1AE\<\nM#RX"s5rHb!.Y~\>\n!\<E0!joBJ\\rr\<&trrrK'rrE*!!\<)rt!\<\<'$!\<\<'!rVls"s8N)trr\<&urr\<&trr\<%Ms3UcGR=YCf\ns8N).rrmKDk2p^bJ,~\>\n!\<E0!joBJ\\rr\<&trrrK'rrE*!!\<)rt!\<\<'$!\<\<'!rVls"s8N)trr\<&urr\<&trr\<%Ms3UcGR=YCf\ns8N).rrmKDk2p^bJ,~\>\n!\<E0!joBJ\\rr\<&trrrK'rrE*!!\<)rt!\<\<'$!\<\<'!rVls"s8N)trr\<&urr\<&trr\<%Ms3UcGR=YBo\nrrmKDk2p^bJ,~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus"p"]'!\<\<'!rVls"s8N)prr\<&trr\<%Ms3UcGR=YCgs8N)-rrmKD\nk2p^bJ,~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus"p"]'!\<\<'!rVls"s8N)prr\<&trr\<%Ms3UcGR=YCgs8N)-rrmKD\nk2p^bJ,~\>\n!\<E0!joBJ[s8;rsrrW9$rrDus"p"]'!\<\<'!rVls"s8N)prr\<&trr\<%Ms3UcGR=YBorrmKDk2p^b\nJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YChrr\<&+rrmKDk2p^bJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YChrr\<&+rrmKDk2p^bJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YCirr\<&*rrmKDk2p^bJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YCirr\<&*rrmKDk2p^bJ,~\>\n!\<E0!joBJGrr\<&prr\<%Ms2"^8R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJFrr\<&rrr\<%Ms1nX7R=YCjs8N)*rrmKDk2p^bJ,~\>\n!\<E0!joBJFrr\<&rrr\<%Ms1nX7R=YCjs8N)*rrmKDk2p^bJ,~\>\n!\<E0!joBJFrr\<&rrr\<%Ms1nX7R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCks8N))rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCks8N))rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCkrr\<&(rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCkrr\<&(rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YClrr\<&'rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YClrr\<&'rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCmrr\<&&rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCmrr\<&&rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCnrr\<&%rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCnrr\<&%rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCorr\<&$rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCorr\<&$rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCprr\<&#rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCprr\<&#rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCqrr\<&"rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCqrr\<&"rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCqrr\<&"rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCqrr\<&"rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCrrr\<&!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCrrr\<&!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCrrr\<&!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCrrr\<&!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCsrr\<%urrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCsrr\<%urrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCtrr\<%trrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCtrr\<%trrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCurr\<%srrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YCurr\<%srrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD!rr\<%rrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD!rr\<%rrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD"rr\<%qrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD"rr\<%qrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD"rr\<%qrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD"rr\<%qrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD#rr\<%prrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD#rr\<%prrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD#rr\<%prrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD#rr\<%prrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD$rr\<%orrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD$rr\<%orrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD$rr\<%orrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD$rr\<%orrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD%rr\<%nrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD%rr\<%nrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD%rr\<%nrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD%rr\<%nrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD&rr\<%mrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD&rr\<%mrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD&rr\<%mrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD&rr\<%mrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD'rr\<%lrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD'rr\<%lrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD(rr\<%krrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD(rr\<%krrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD)s8N(krrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD)s8N(krrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD)rr\<%jrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD)rr\<%jrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD*rr\<%irrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD*rr\<%irrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD*rr\<%irrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD*rr\<%irrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD+rr\<%hrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD+rr\<%hrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD+rr\<%hrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD+rr\<%hrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD,rr\<%grrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD-rr\<%frrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD-rr\<%frrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD-rr\<%frrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD-rr\<%frrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD.rr\<%errmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD.rr\<%errmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD.rr\<%errmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD.rr\<%errmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD/rr\<%drrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD/rr\<%drrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD0s8N(drrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD0s8N(drrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD0rr\<%crrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD0rr\<%crrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD1rr\<%brrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD1rr\<%brrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD1rr\<%brrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD1rr\<%brrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD2rr\<%arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD2rr\<%arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD2rr\<%arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD2rr\<%arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD3rr\<%`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD3rr\<%`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD3rr\<%`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD3rr\<%`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD4s8N(`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD4s8N(`rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD4rr\<%_rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD4rr\<%_rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5s8N(_rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5s8N(_rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5rr\<%^rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5rr\<%^rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5rr\<%^rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD5rr\<%^rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD6rr\<%]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD6rr\<%]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD6rr\<%]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD6rr\<%]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD7rr\<%\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD7rr\<%\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD7rr\<%\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD7rr\<%\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD8s8N(\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD8s8N(\\rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD8rr\<%[rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD8rr\<%[rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9s8N([rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9s8N([rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9rr\<%ZrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9rr\<%ZrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9rr\<%ZrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD9rr\<%ZrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD:rr\<%YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD:rr\<%YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD:rr\<%YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD:rr\<%YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD;rr\<%XrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD;rr\<%XrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD;rr\<%XrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD;rr\<%XrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD\<rr\<%WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YD\<rr\<%WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YA\>rr\<%WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YA\>rr\<%WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YA=rr@rV"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YA=rr@rV"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YA\<!/^^ZF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YA\<!/^^ZF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YA\<!/^^ZF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YA\<!/^^ZF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=bG=!/UXYF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=bG=!/UXYF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=bG=!/UXYF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=bG=!/UXYF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=kM\>!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=kM\>!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=kM\>!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=kM\>!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=tV?!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=tV?!/LRXF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=tS?!/CLWF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=tS?!/CLWF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>(\\@!/CLWF8tCbEr^^~\>\n!\<E0!joBIRs+11MR\>(\\@!/CLWF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>(Y@!/:FVF8tCbEr^^~\>\n!\<E0!joBIRs+11MR\>(Y@!/:FVF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>(Y@!/:FVF8tCbEr^^~\>\n!\<E0!joBIRs+11MR\>(Y@!/:FVF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>1_A!/1@UF8tCbEr^^~\>\n!\<E0!joBIRs+11MR\>1_A!/1@UF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>1_A!/1@UF8tCbEr^^~\>\n!\<E0!joBIRs+11MR\>1_A!/1@UF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0`!0I3\\!/(:TF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm0`!0I3\\!/(:TF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm0`!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm-c!0$pX!/(:TF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!0$pX!/(:TF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!.k00rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm-c!0.!Y!.t4SF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!0.!Y!.t4SF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!.k00rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm-c!07*Z!.t4SF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!07*Z!.t4SF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm-c!.k00rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0a!0R9]!.k.RF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm0a!0R9]!.k.RF8tCbEr^^~\>\n!\<E0!joBIRs+11MRJm0a!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMRJQp`!0dE_!.k.Ss)\\5&k&UNQ~\>\n!\<E0!joBIRs+LFMRJQp`!0dE_!.k.Ss)\\5&k&UNQ~\>\n!\<E0!joBIRs+LFMRJQp`!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJHj_!0dE_!.k.Ss)\\5&k&UNQ~\>\n!\<E0!joBIRs+11MRJHj_!0dE_!.k.Ss)\\5&k&UNQ~\>\n!\<E0!joBIRs+11MRJHj_!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!\<)ot!0mK`!.k1MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!\<)ot!0mK`!.k1MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!\<)ot!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0a!0dE_!.k1MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0a!0dE_!.k1MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0a!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>h.G!.k1LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>h.G!.k1LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>h.G!.k1LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>h.G!.k1LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>q4H!.k1KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR\>q4H!.k1KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?%=I!.k1KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?%=I!.k1KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?%:I!.k1JrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?%:I!.k1JrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?.@J!.k1IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?.@J!.k1IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?.@J!.k1IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?.@J!.k1IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?7FK!.k1HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?7FK!.k1HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?7FK!.k1HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?7FK!.k1HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?@LL!.k1GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?@LL!.k1GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?@LL!.k1GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?@LL!.k1GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?IRM!.k1FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?IRM!.k1FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?R[N!.k1FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?R[N!.k1FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?RXN!.k1ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?RXN!.k1ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?[^O!.k1DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?[^O!.k1DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?mjQ!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?mjQ!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?mjQ!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?mjQ!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@!pR!.k1ArrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@!pR!.k1ArrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@+!S!.k1@rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@+!S!.k1@rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4'T!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4'T!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@=-U!.k1\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@=-U!.k1\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@F3V!.k1=rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@F3V!.k1=rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@O9W!.k1\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@O9W!.k1\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@XBX!.k1\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@XBX!.k1\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@aHY!.k1;rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@aHY!.k1;rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@aEY!.k1:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@aEY!.k1:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@jKZ!.k19rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@jKZ!.k19rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA'Z\\!.k18rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA'Z\\!.k18rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA0`]!.k17rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA0`]!.k17rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA9c^!.k15rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA9c^!.k15rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRAKr`!.k14rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRAKr`!.k14rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA^)b!.k12rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRA^)b!.k12rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRAp5d!.k10rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRAp5d!.k10rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRB-Ae!.k1/rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRB-Ae!.k1/rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRBHSg!.k1-rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRBHSg!.k1-rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRBlkj!.k1*rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRBlkj!.k1*rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRCE4o!.k1%rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRCE4o!.k1%rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MREY]s!.k1!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MREY]s!.k1!rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MREtp3!.k0arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MREtp3!.k0arrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRF2'7!.k0]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRF2'7!.k0]rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRFM99!.k0[rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRFM99!.k0[rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRF_E;!.k0YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRF_E;!.k0YrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRFhK=!.k0WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRFhK=!.k0WrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG%W?!.k0UrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG%W?!.k0UrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG.]@!.k0TrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG.]@!.k0TrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG7`A!.k0RrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG7`A!.k0RrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGIoC!.k0QrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGIoC!.k0QrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGRuD!.k0PrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGRuD!.k0PrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG\\&E!.k0OrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRG\\&E!.k0OrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGe)F!.k0MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGe)F!.k0MrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGn/G!.k0LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRGn/G!.k0LrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH"5H!.k0KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH"5H!.k0KrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH+;I!.k0JrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH+;I!.k0JrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH4AJ!.k0IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH4AJ!.k0IrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH=GK!.k0HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH=GK!.k0HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH=GK!.k0HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRH=GK!.k0HrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHFML!.k0GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHFML!.k0GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHFML!.k0GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHFML!.k0GrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHOSM!.k0FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHOSM!.k0FrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHXYN!.k0ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHXYN!.k0ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHXYN!.k0ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHXYN!.k0ErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHa_O!.k0DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHa_O!.k0DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHa_O!.k0DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHa_O!.k0DrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHjeP!.k0CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHjeP!.k0CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHskQ!.k0BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRHskQ!.k0BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI'tR!.k0BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI'tR!.k0BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI'qR!.k0ArrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI'qR!.k0ArrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI1"S!.k0@rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI1"S!.k0@rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI:(T!.k0?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI:(T!.k0?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI:(T!.k0?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI:(T!.k0?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIC.U!.k0\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIC.U!.k0\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIC.U!.k0\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIC.U!.k0\>rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIL4V!.k0=rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIL4V!.k0=rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIU:W!.k0\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIU:W!.k0\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI^CX!.k0\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI^CX!.k0\<rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI^@X!.k0;rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRI^@X!.k0;rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIgFY!.k0:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIgFY!.k0:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIgFY!.k0:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIgFY!.k0:rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIpLZ!.k09rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIpLZ!.k09rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIpLZ!.k09rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRIpLZ!.k09rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ$R[!.k08rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ-X\\!.k07rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ-X\\!.k07rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ-X\\!.k07rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ-X\\!.k07rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ6^]!.k06rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ6^]!.k06rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ6^]!.k06rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ6^]!.k06rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ?d^!.k05rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ?d^!.k05rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJHm_!.k05rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJHm_!.k05rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJHj_!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJHj_!.k04rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJQp`!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJQp`!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJQp`!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJQp`!.k03rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ[!a!20Ai!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ[!a!20Ai!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4*Q!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ[!a!20\>l!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJ[!a!20\>l!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4'T!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJd'b!2'8k!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJd'b!2'8k!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4'T!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJd'b!2'8k!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJd'b!2'8k!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4'T!.k1?rrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0c!2';i!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm0c!2';i!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4*R!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm-c!1Nof!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRJm-c!1Nof!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!6d!1Nof!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!6d!1Nof!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR?ddP!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!1s2j!\<)ot!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!1s2j!\<)ot!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@=-U!\<)ot!.k1CrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!1j/g!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MRK!3d!1j/g!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR@4*R!.k1BrrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11PRK*9eJcCZ."`s_+k&UNQ~\>\n!\<E0!joBIRs+11PRK*9eJcCZ."`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11PRK*9eJcCZ."`s_+k&UNQ~\>\n!\<E0!joBIRs+11PRK*9eJcCZ."`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11ORK!8\<s,-g[F8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJTrrAIRrrAIQrrJMfR/[/SQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIQrrJMfR/[/SQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIQrrAIRrrAIQrrAJErrmKDk2p^bJ,~\>\n!\<E0!joBJTrrAIRrrAIQrrJMfR/[/SQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIQrrJMfR/[/SQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIQrrAIRrrAIQrrAJErrmKDk2p^bJ,~\>\n!\<E0!joBK%s+-SkR/d5\<R\>[L4rrmKDk2p^bJ,~\>\n!\<E0!joBK%s+-SkR/d5\<R\>[L4rrmKDk2p^bJ,~\>\n!\<E0!joBK%s+-SkR/m8\<R\>[L4rrmKDk2p^bJ,~\>\n!\<E0!joBJTrrAIRrrAIQrr\<%crrAIQrrAJErrmKDk2p^bJ,~\>\n!\<E0!joBJTrrAIRrrAIQrr\<%crrAIQrrAJErrmKDk2p^bJ,~\>\n!\<E0!joBJTrrAIRrrAI\<s/Z/"R?mjQRG\\#JF8tCbEr^^~\>\n!\<E0!joBJTrrAIRrrAIRrrE+fQi@&RQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIRrrE+fQi@&RQN$rQhu\<k$s5rHb!.Y~\>\n!\<E0!joBJTrrAIRrrAIQrrAIRrrAIQrrAJErrmKDk2p^bJ,~\>\n!\<E0!joBIRs+C@O!!&F\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+C@O!!&F\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+C=Q!\<8I\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+C=Q!\<8I\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LCS!\<\<(eJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+LCS!\<\<(eJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LCS!\<\<(eJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+LCS!\<\<(eJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+UIQ!\<2uuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+UIQ!\<2uuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+UIQ!\<2uuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+UIQ!\<2uuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+^OR!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+^OR!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+^OR!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+^OR!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+gXS!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+gXS!\<)otR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+gUS!;uisR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+gUS!;uisR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p^T!;uisR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p^T!;uisR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p[T!;lcrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p[T!;lcrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p[T!;lcrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+p[T!;lcrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,$aU!;c]qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,$aU!;c]qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,$aU!;c]qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,$aU!;c]qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,-gV!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,-gV!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,-gV!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,-gV!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,6pW!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,6pW!;ZWpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,6mW!;QQoR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,6mW!;QQoR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,@!X!;QQoR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,@!X!;QQoR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,?sX!;HKnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,?sX!;HKnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,I$Y!;?EmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,I$Y!;?EmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,I$Y!;?EmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,I$Y!;?EmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,R*Z!;6?lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,R*Z!;6?lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,R*Z!;6?lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,R*Z!;6?lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,[0[!;-9kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,[0[!;-9kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,d9\\!;-9kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,d9\\!;-9kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,d6\\!;$3jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,d6\\!;$3jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,m?]!;$3jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,m?]!;$3jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,m\<]!:p-iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs,m\<]!:p-iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-!B^!:g'hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-!B^!:g'hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-!B^!:g'hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-!B^!:g'hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-*H_!:^!gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-*H_!:^!gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-*H_!:^!gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-*H_!:^!gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-3N`!:TpfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-3N`!:TpfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-\<Wa!:TpfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-\<Wa!:TpfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-\<Ta!:KjeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-\<Ta!:KjeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-E]b!:KjeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-E]b!:KjeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-EZb!:BddR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-EZb!:BddR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-N`c!:9^cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-N`c!:9^cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-N`c!:9^cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-N`c!:9^cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-Wfd!:0XbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-Wfd!:0XbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-Wfd!:0XbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-Wfd!:0XbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-`le!:'RaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-`le!:'RaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-irf!9sL`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-irf!9sL`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-s&g!9sL`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-s&g!9sL`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-s#g!9jF_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs-s#g!9jF_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.')h!9a@^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.')h!9a@^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.0/i!9X:]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.0/i!9X:]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.98j!9X:]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.98j!9X:]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.95j!9O4\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.95j!9O4\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.B;k!9F.[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.B;k!9F.[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.KAl!9=(ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.KAl!9=(ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.TJm!9=(ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.TJm!9=(ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.]Pn!94"YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.]Pn!94"YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.]Mn!9*qXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.]Mn!9*qXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.fSo!9!kWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs.fSo!9!kWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/#bq!8meVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/#bq!8meVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/,hr!8d_UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/,hr!8d_UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/5ns!8[YTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/5ns!8[YTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/\>qt!8IMRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/\>qt!8IMRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/Q,!!8@GQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/Q,!!8@GQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/Z2"!87APR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/Z2"!87APR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/l\>$!8%5NR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs/l\>$!8%5NR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0)J%!7q/MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0)J%!7q/MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0;V'!7_#KR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0;V'!7_#KR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0Mb*!7CfHR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0Mb*!7CfHR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0r%,!71ZFR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs0r%,!71ZFR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs2b6/!6kHCR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs2b6/!6kHCR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4%)@!5&72R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4%)@!5&72R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs475L!3cD&R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs475L!3cD&R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4IAN!3Q8$R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4IAN!3Q8$R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4[MP!3?,"R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4[MP!3?,"R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4mYR!3,tuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs4mYR!3,tuR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5*eU!2fbrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5*eU!2fbrR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5\<qW!2TVpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5\<qW!2TVpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5EtX!2BJnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5EtX!2BJnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5O%Y!29DmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5O%Y!29DmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5X+Z!20\>lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5X+Z!20\>lR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5a1[!2'8kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5a1[!2'8kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5j7\\!1s2jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5j7\\!1s2jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5s=]!1j,iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs5s=]!1j,iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6'C^!1a&hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6'C^!1a&hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs60I_!1WugR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs60I_!1WugR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs69O`!1NofR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs69O`!1NofR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6BXa!1NofR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6BXa!1NofR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6K^b!1EieR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6K^b!1EieR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6K[b!1\<cdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6K[b!1\<cdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6Tac!13]cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6Tac!13]cR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6]gd!1*WbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6]gd!1*WbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6]gd!1*WbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6]gd!1*WbR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6fme!1!QaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6fme!1!QaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6fme!1!QaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6fme!1!QaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6osf!0mK`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs6osf!0mK`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7$$g!0dE_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7$$g!0dE_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7--h!0dE_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7--h!0dE_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7-*h!0[?^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7-*h!0[?^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs760i!0R9]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs760i!0R9]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7?6j!0I3\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7?6j!0I3\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7?6j!0I3\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7?6j!0I3\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7H\<k!0@-[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7H\<k!0@-[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7H\<k!0@-[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7H\<k!0@-[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7QBl!07'ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7QBl!07'ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7ZHm!0.!YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7ZHm!0.!YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7cQn!0.!YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7cQn!0.!YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7cNn!0$pXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7cNn!0$pXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7lTo!/pjWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7lTo!/pjWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7lTo!/pjWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7lTo!/pjWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7uZp!/gdVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7uZp!/gdVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7uZp!/gdVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs7uZp!/gdVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!/^^UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!/^^UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!0$sUR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!0$sUR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!/^^UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8)`q!/^^UR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs82fr!/UXTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs82fr!/UXTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs82fr!/UXTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs82fr!/UXTR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8;ls!/LRSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8;ls!/LRSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8;ls!/LRSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8;ls!/LRSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8Drt!/CLRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8Drt!/CLRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8N&u!/CLRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8N&u!/CLRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8N#u!/:FQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8N#u!/:FQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8W*!!/1@PR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8W*!!/1@PR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8W*!!/1@PR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs8W*!!/1@PR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRrrN-"KDtq\>JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRrrN-"KDtq\>JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRrrN-"KDtq\>JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRrrN-"KDtq\>JcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRrr\<%NrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBISrr\<%MrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBISrr\<%MrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBISrr\<%MrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBISrr\<%MrrAI\<s+p[YF8tCbEr^^~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBITrr\<%MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBITrr\<%MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBITrr\<%MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBITrr\<%MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIUs8N(MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIUs8N(MrrN.fJcCQ+"`s_+k&UNQ~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIUrr\<%Ms8W*!R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIUrr\<%Ms8W*!R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIVs8N(Ms8W*!R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIVs8N(Ms8W*!R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIVrr\<%Ms8N#uR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIVrr\<%Ms8N#uR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIWrr\<%Ms8DrtR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIWrr\<%Ms8DrtR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIWrr\<%Ms8DrtR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIWrr\<%Ms8DrtR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIXrr\<%Ms8;lsR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIXrr\<%Ms8;lsR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIXrr\<%Ms8;lsR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIXrr\<%Ms8;lsR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIYrr\<%Ms82frR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIYrr\<%Ms82frR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIZs8N(Ms82frR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIZs8N(Ms82frR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIZrr\<%Ms8)`qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIZrr\<%Ms8)`qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[s8N(Ms8)`qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[s8N(Ms8)`qR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[rr\<%Ms7uZpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[rr\<%Ms7uZpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[rr\<%Ms7uZpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI[rr\<%Ms7uZpR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI\\rr\<%Ms7lToR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI\\rr\<%Ms7lToR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI\\rr\<%Ms7lToR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI\\rr\<%Ms7lToR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI]rr\<%Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI]rr\<%Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI]rr\<%Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI]rr\<%Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI^s8N(Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI^s8N(Ms7cNnR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI^rr\<%Ms7ZHmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI^rr\<%Ms7ZHmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_s8N(Ms7ZHmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_s8N(Ms7ZHmR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_rr\<%Ms7QBlR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_rr\<%Ms7QBlR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_rr\<%Ms7QBlR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI_rr\<%Ms7QBlR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI`rr\<%Ms7H\<kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI`rr\<%Ms7H\<kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI`rr\<%Ms7H\<kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBI`rr\<%Ms7H\<kR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIarr\<%Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIarr\<%Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIarr\<%Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIarr\<%Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIbs8N(Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIbs8N(Ms7?6jR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIbrr\<%Ms760iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIbrr\<%Ms760iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIcs8N(Ms760iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIcs8N(Ms760iR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIcrr\<%Ms7-*hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIcrr\<%Ms7-*hR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIdrr\<%Ms7$$gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIdrr\<%Ms7$$gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIdrr\<%Ms7$$gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIdrr\<%Ms7$$gR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIerr\<%Ms6osfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIerr\<%Ms6osfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIerr\<%Ms6osfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIerr\<%Ms6osfR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIfrr\<%Ms6fmeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIfrr\<%Ms6fmeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIgs8N(Ms6fmeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIgs8N(Ms6fmeR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIgrr\<%Ms6]gdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIgrr\<%Ms6]gdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIhs8N(Ms6]gdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIhs8N(Ms6]gdR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIhrr\<%Ms6TacR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIhrr\<%Ms6TacR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIirr\<%Ms6K[bR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIirr\<%Ms6K[bR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIirr\<%Ms6K[bR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIirr\<%Ms6K[bR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIjrr\<%Ms6BUaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIjrr\<%Ms6BUaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIjrr\<%Ms6BUaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIjrr\<%Ms6BUaR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIkrr\<%Ms69O`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIkrr\<%Ms69O`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIls8N(Ms69O`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIls8N(Ms69O`R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIlrr\<%Ms60I_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIlrr\<%Ms60I_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIms8N(Ms60I_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIms8N(Ms60I_R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBImrr\<%Ms6'C^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBImrr\<%Ms6'C^R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBInrr\<%Ms5s=]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBInrr\<%Ms5s=]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBInrr\<%Ms5s=]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBInrr\<%Ms5s=]R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIorr\<%Ms5j7\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIorr\<%Ms5j7\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIorr\<%Ms5j7\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIorr\<%Ms5j7\\R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIprr\<%Ms5a1[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIprr\<%Ms5a1[R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIqrr\<%Ms5X+ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIqrr\<%Ms5X+ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIrs8N(Ms5X+ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIrs8N(Ms5X+ZR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIrrr\<%Ms5O%YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIrrr\<%Ms5O%YR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIsrr\<%Ms5EtXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIsrr\<%Ms5EtXR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBItrr\<%Ms5\<nWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBItrr\<%Ms5\<nWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBItrr\<%Ms5\<nWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBItrr\<%Ms5\<nWR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIurr\<%Ms53hVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIurr\<%Ms53hVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIurr\<%Ms53hVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIurr\<%Ms53hVR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ!rr\<%Ms5*bUR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ!rr\<%Ms5*bUR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ"rr\<%Ms5!\\TR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ"rr\<%Ms5!\\TR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ#rr\<%Ms4mVSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ#rr\<%Ms4mVSR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ$rr\<%Ms4dPRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ$rr\<%Ms4dPRR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ%rr\<%Ms4[JQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ%rr\<%Ms4[JQR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ&rr\<%Ms4RDPR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ&rr\<%Ms4RDPR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ'rr\<%Ms4I\>OR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ'rr\<%Ms4I\>OR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ(rr\<%Ms4@8NR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ(rr\<%Ms4@8NR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ)rr\<%Ms472MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ)rr\<%Ms472MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ*rr\<%Ms4.,LR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ*rr\<%Ms4.,LR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ+rr\<%Ms4%&KR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ+rr\<%Ms4%&KR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ,rr\<%Ms3puJR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ,rr\<%Ms3puJR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ.s8N(Ms3goIR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ.s8N(Ms3goIR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ0s8N(Ms3UcGR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ0s8N(Ms3UcGR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ3s8E"Ls3CWER=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ3s8E"Ls3CWER=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ5s8E"Ls31KCR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ5s8E"Ls31KCR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ8s8;qKs2t?AR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ8s8;qKs2t?AR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ\<s82kJs2Y-\>R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJ\<s82kJs2Y-\>R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJMs6p#\>s2+d9R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJMs6p#\>s2+d9R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJTs7u_Hs0;S(R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBJTs7u_Hs0;S(R=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+LFMR=YBprrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<E0!joBIRs+11MR=YBorrmKDk2p^bJ,~\>\n!\<Be2PC`abrrAI\<s+p[YPJ!*C!!%N~\>\n!\<Be2PC`abrrAI\<s+p[YPJ!*C!!%N~\>\n!\<Be2PC`abrrAI\<s+p[YPJ!*C!!%N~\>\n!!)uU!0`!6Jc\>_\<JcCQ+"d@lW]TW\>G~\>\n!!)uU!0`!6Jc\>_\<JcCQ+"d@lW]TW\>G~\>\n!!)uU!0`!6Jc\>_\<JcCQ+"d@lW]TW\>G~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+11MR=YBorrnVE]Y'F.J,~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'W]E".Hs+13$s+gUXPMj*dP5p+~\>\n!\<D'V]^_2:F+JC`F/O'Z]^h6di;U@iP5p+~\>\n!\<D'V]^_2:F+JC`F/O'Z]^h6di;U@iP5p+~\>\n!\<D'V]^_2:F+JC`F/O'Z]^h6di;U@iP5p+~\>\n!ri8YrOha[!5*m_JcC\<$VuQ;Frk&;r!!%N~\>\n!ri8YrOha[!5*m_JcC\<$VuQ;Frk&;r!!%N~\>\n!ri8YrOha[!5*m_JcC\<$VuQ;Frk&;r!!%N~\>\n!p0L@n%8XaJ`_OGJ``lm!9!=Y!g\<TaJ,~\>\n!p0L@n%8XaJ`_OGJ``lm!9!=Y!g\<TaJ,~\>\n!p0L@n%8XaJ`_OGJ``lm!9!=Y!g\<TaJ,~\>\ns5j@_PEYOL!0_urJ`_OGVre!;n\\"mc!W_BFJ,~\>\ns5j@_PEYOL!0_urJ`_OGVre!;n\\"mc!W_BFJ,~\>\ns5j@_PEYOL!0_urJ`_OGVre!;n\\"mc!W_BFJ,~\>\nrcA)\>n\<8EEJTHB`VfMjNnWWtQrc\<S~\>\nrcA)\>n\<8EEJTHB`VfMjNnWWtQrc\<S~\>\nrcA)\>n\<8EEJTHB`VfMjNnWWtQrc\<S~\>\nJH16$JH16$qZ)-~\>\nJH16$JH16$qZ)-~\>\nJH16$JH16$qZ)-~\>\n%%EndData\nshowpage\n%%Trailer\nend\n%%EOF\n>|eps>|*.5|*.5||||>
  </expand|Un esempio di grafico prodotto da <name|Maxima>.>

  <apply|tmdoc-copyright|2003|Chu-Ching Huang, Lucia Gecchelin>

  <expand|tmdoc-license|Permission is granted to copy, distribute and/or
  modify this document under the terms of the GNU Free Documentation License,
  Version 1.1 or any later version published by the Free Software Foundation;
  with no Invariant Sections, with no Front-Cover Texts, and with no
  Back-Cover Texts. A copy of the license is included in the section entitled
  "GNU Free Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|page type|a4>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
    <associate|language|italian>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-10|<tuple|8.2|?>>
    <associate|toc-11|<tuple|8.3|?>>
    <associate|gly-1|<tuple|1|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|gly-2|<tuple|2|?>>
    <associate|toc-12|<tuple|8.4|?>>
    <associate|gly-3|<tuple|3|?>>
    <associate|toc-13|<tuple|8.5|?>>
    <associate|idx-3|<tuple|3|?>>
    <associate|gly-4|<tuple|4|?>>
    <associate|toc-14|<tuple|8.6|?>>
    <associate|idx-4|<tuple|7|?>>
    <associate|gly-5|<tuple|5|?>>
    <associate|toc-15|<tuple|8.7|?>>
    <associate|idx-5|<tuple|8|?>>
    <associate|gly-6|<tuple|6|?>>
    <associate|toc-16|<tuple|8.8|?>>
    <associate|gly-7|<tuple|7|?>>
    <associate|gly-8|<tuple|8|?>>
    <associate|gly-9|<tuple|9|?>>
    <associate|toc-1|<tuple|1|?>>
    <associate|toc-2|<tuple|2|?>>
    <associate|toc-3|<tuple|3|?>>
    <associate|toc-4|<tuple|4|?>>
    <associate|toc-5|<tuple|5|?>>
    <associate|toc-6|<tuple|6|?>>
    <associate|toc-7|<tuple|7|?>>
    <associate|toc-8|<tuple|8|?>>
    <associate|toc-9|<tuple|8.1|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|figure>
      <tuple|normal|A sample graph produced by <with|font
      shape|<quote|small-caps>|Maxima>.|<pageref|gly-1>>
    </associate>
    <\associate|idx>
      <tuple|<tuple|<with|font family|<quote|ss>|Testo>|<with|font
      family|<quote|ss>|Sessione>|<with|font
      family|<quote|ss>|Maxima>>|<pageref|idx-1>>

      <tuple|<tuple|<with|font family|<quote|ss>|Inserisci>|<with|font
      family|<quote|ss>|Immagine>>|<pageref|idx-2>>
    </associate>
  </collection>
</auxiliary>
