/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.extapi.psi.ASTDelegatePsiElement");
    private static final List EMPTY = Collections.emptyList();

    @Override
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile(this.getNode());
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        PsiElement parent2 = this;
        while (parent2 instanceof ASTDelegatePsiElement) {
            parent2 = parent2.getParent();
        }
        if (parent2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return (PsiManagerEx)parent2.getManager();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "getChildren"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result2.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    @Override
    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    @Override
    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    @Override
    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset2);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    @Override
    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    @Override
    public String getText() {
        return this.getNode().getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getNode().getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "textToCharArray"));
        }
        return cArray;
    }

    @Override
    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    @Override
    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/extapi/psi/ASTDelegatePsiElement", "getCopyableUserData"));
        }
        return this.getNode().getCopyableUserData(key);
    }

    @Override
    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/extapi/psi/ASTDelegatePsiElement", "putCopyableUserData"));
        }
        this.getNode().putCopyableUserData(key, value);
    }

    @Override
    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getNode().getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "getLanguage"));
        }
        return language;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(IElementType type2) {
        ASTNode node = this.getNode().findChildByType(type2);
        return (T)(node == null ? null : node.getPsi());
    }

    @Nullable
    protected <T extends PsiElement> T findLastChildByType(IElementType type2) {
        for (PsiElement child = this.getLastChild(); child != null; child = child.getPrevSibling()) {
            ASTNode node = child.getNode();
            if (node == null || node.getElementType() != type2) continue;
            return (T)child;
        }
        return null;
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(IElementType type2) {
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type2));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "findNotNullChildByType"));
        }
        return (T)psiElement;
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(TokenSet type2) {
        ASTNode node = this.getNode().findChildByType(type2);
        return (T)(node == null ? null : node.getPsi());
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(TokenSet type2) {
        PsiElement psiElement = (PsiElement)this.notNullChild(this.findChildByType(type2));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "findNotNullChildByType"));
        }
        return (T)psiElement;
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes.length == 0 ? null : nodes[0].getPsi();
    }

    @NotNull
    protected <T extends PsiElement> T[] findChildrenByType(IElementType elementType, Class<T> arrayClass) {
        PsiElement[] psiElementArray = ContainerUtil.map2Array(SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "findChildrenByType"));
        }
        return psiElementArray;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(TokenSet elementType) {
        ArrayList<PsiElement> result2 = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result2 == EMPTY) {
                result2 = new ArrayList<PsiElement>();
            }
            result2.add(child.getPsi());
        }
        return result2;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(IElementType elementType) {
        ArrayList<PsiElement> result2 = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (elementType != child.getElementType()) continue;
            if (result2 == EMPTY) {
                result2 = new ArrayList<PsiElement>();
            }
            result2.add(child.getPsi());
        }
        return result2;
    }

    @NotNull
    protected <T extends PsiElement> T[] findChildrenByType(TokenSet elementType, Class<T> arrayClass) {
        PsiElement[] psiElementArray = ContainerUtil.map2Array(this.getNode().getChildren(elementType), arrayClass, s -> s.getPsi());
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/ASTDelegatePsiElement", "findChildrenByType"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/extapi/psi/ASTDelegatePsiElement", "add"));
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/extapi/psi/ASTDelegatePsiElement", "addBefore"));
        }
        return this.addInnerBefore(element, anchor2);
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/extapi/psi/ASTDelegatePsiElement", "addAfter"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/extapi/psi/ASTDelegatePsiElement", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor2, Boolean before) {
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor2, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/extapi/psi/ASTDelegatePsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/extapi/psi/ASTDelegatePsiElement", "addRangeBefore"));
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable(this);
            ((ASTDelegatePsiElement)parent2).deleteChildInternal(this.getNode());
        } else if (parent2 instanceof CompositeElement) {
            CheckUtil.checkWritable(this);
            ((CompositeElement)((Object)parent2)).deleteChildInternal(this.getNode());
        } else if (parent2 instanceof PsiFile) {
            CheckUtil.checkWritable(this);
            parent2.deleteChildRange(this, this);
        } else {
            throw new UnsupportedOperationException(this.getClass().getName() + " under " + (parent2 == null ? "null" : parent2.getClass().getName()));
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/extapi/psi/ASTDelegatePsiElement", "deleteChildInternal"));
        }
        ((CompositeElement)this.getNode()).deleteChildInternal(child);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/extapi/psi/ASTDelegatePsiElement", "replace"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal(this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child.getNode(), newElement);
    }

    private ASTNode getAnchorNode(ASTNode anchor2, Boolean before) {
        ASTNode anchorBefore = anchor2 != null ? (before != false ? anchor2 : anchor2.getTreeNext()) : (before != null && before == false ? this.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }
}

