/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a$\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a-\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\t\u001a\u00020\u0004\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a+\u0010\t\u001a\u00020\u0004\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\n\u001a\u0002H\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"deserializeFromPlainText", "T", "", "str", "", "(Ljava/lang/String;)Ljava/lang/Object;", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "serializeToPlainText", "instance", "(Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/lang/String;", "kotlin-build-common"})
public final class SerializationUtilsKt {
    private static final <T> String serializeToPlainText(T instance) {
        Intrinsics.reifiedOperationMarker(4, "T");
        return SerializationUtilsKt.serializeToPlainText(instance, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> String serializeToPlainText(@NotNull T instance, @NotNull KClass<T> klass2) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        ArrayList<String> lines = new ArrayList<String>();
        for (KProperty1<T, ?> property : KClasses.getMemberProperties(klass2)) {
            Object value = property.get(instance);
            if (value == null) continue;
            lines.add("" + property.getName() + '=' + value);
        }
        return CollectionsKt.joinToString$default(lines, "\n", null, null, 0, null, null, 62, null);
    }

    private static final <T> T deserializeFromPlainText(String str) {
        Intrinsics.reifiedOperationMarker(4, "T");
        return SerializationUtilsKt.deserializeFromPlainText(str, Reflection.getOrCreateKotlinClass(Object.class));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T deserializeFromPlainText(@NotNull String str, @NotNull KClass<T> klass2) {
        Collection $receiver$iv;
        Iterator $receiver$iv$iv;
        Object object;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(str, "str");
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        ArrayList<Integer> args = new ArrayList<Integer>();
        Iterable iterable = StringsKt.split$default((CharSequence)str, new String[]{"\n"}, false, 0, 6, null);
        void var5_4 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            String p1 = (String)element$iv$iv2;
            object = p1;
            if (!(!StringsKt.isBlank((CharSequence)object))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10)), 16);
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Object element$iv$iv3 = element$iv$iv2.next();
            object = destination$iv$iv2;
            String it = (String)element$iv$iv3;
            Pair<String, String> pair = TuplesKt.to(StringsKt.substringBefore$default(it, "=", null, 2, null), StringsKt.substringAfter$default(it, "=", null, 2, null));
            object.put(pair.getFirst(), pair.getSecond());
        }
        Map properties2 = destination$iv$iv2;
        KFunction<T> kFunction = KClasses.getPrimaryConstructor(klass2);
        if (kFunction == null) {
            throw (Throwable)new IllegalStateException("" + JvmClassMappingKt.getJavaClass(klass2) + " does not have primary constructor");
        }
        KFunction<T> primaryConstructor2 = kFunction;
        Iterable $receiver$iv3 = primaryConstructor2.getParameters();
        $receiver$iv$iv = CollectionsKt.sortedWith($receiver$iv3, new Comparator<T>(){

            public final int compare(T a, T b) {
                KParameter it = (KParameter)a;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (KParameter)b;
                Comparable comparable2 = comparable;
                Integer n = it.getIndex();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        }).iterator();
        while ($receiver$iv$iv.hasNext()) {
            Object object2;
            Map $i$f$sortedBy = properties2;
            KParameter param = (KParameter)$receiver$iv$iv.next();
            Object object3 = param.getName();
            String argumentString = (String)$i$f$sortedBy.get(object3);
            if (argumentString == null) {
                if (param.getType().isMarkedNullable()) {
                    args.add(null);
                    continue;
                }
                return null;
            }
            object3 = param.getType().getClassifier();
            if (Intrinsics.areEqual(object3, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                object = argumentString;
                object2 = Integer.parseInt((String)object);
            } else if (Intrinsics.areEqual(object3, Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                object = argumentString;
                object2 = Boolean.parseBoolean((String)object);
            } else if (Intrinsics.areEqual(object3, Reflection.getOrCreateKotlinClass(String.class))) {
                object2 = argumentString;
            } else {
                throw (Throwable)new IllegalStateException("Unexpected property type: " + param.getType());
            }
            Integer argument = object2;
            args.add(argument);
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)args;
        Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (T)primaryConstructor2.call(Arrays.copyOf(objectArray, objectArray.length));
    }
}

