/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bax = "bamum";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n\u2019ko";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "ogam" },
            { "mwl", "mirandeesi" },
            { "Zsym", "symbolit" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egl", "emilia" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwalainen" },
            { "%%NJIVA", "sloveenin resian Gnivan/Njivan alamurre" },
            { "xmf", "mingreli" },
            { "egy", "muinaisegypti" },
            { "raj", "rad\u017eastani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension-saari" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "%%BARLA", "kapverdenkreolin barlaventolainen murreryhm\u00e4" },
            { "AD", "Andorra" },
            { "AE", "Arabiemiirikunnat" },
            { "nl_BE", "flaami" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiina" },
            { "Prti", "piirtokirjoitusparthialainen" },
            { "AS", "Amerikan Samoa" },
            { "AT", "It\u00e4valta" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "amerikanenglanti" },
            { "AX", "Ahvenanmaa" },
            { "mye", "myene" },
            { "AZ", "Azerbaid\u017ean" },
            { "%%AREVELA", "it\u00e4armenialainen" },
            { "BA", "Bosnia ja Hertsegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumykki" },
            { "BE", "Belgia" },
            { "gmh", "keskiyl\u00e4saksa" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "ers\u00e4" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibian Alankomaat" },
            { "BR", "Brasilia" },
            { "BS", "Bahama" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019nsaari" },
            { "BW", "Botswana" },
            { "BY", "Valko-Ven\u00e4j\u00e4" },
            { "BZ", "Belize" },
            { "Visp", "n\u00e4kyv\u00e4 puhe" },
            { "CA", "Kanada" },
            { "CC", "Kookossaaret (Keelingsaaret)" },
            { "mzn", "mazandarani" },
            { "CD", "Kongon demokraattinen tasavalta" },
            { "CF", "Keski-Afrikan tasavalta" },
            { "CG", "Kongon tasavalta" },
            { "CH", "Sveitsi" },
            { "CI", "Norsunluurannikko" },
            { "CK", "Cookinsaaret" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Kiina" },
            { "CO", "Kolumbia" },
            { "CP", "Clippertoninsaari" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Joulusaari" },
            { "CY", "Kypros" },
            { "CZ", "T\u0161ekki" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "zotuallai" },
            { "vls", "l\u00e4nsiflaami" },
            { "%%RIGIK", "klassinen volap\u00fck" },
            { "DE", "Saksa" },
            { "goh", "muinaisyl\u00e4saksa" },
            { "ace", "at\u0161eh" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "goankonkani" },
            { "DJ", "Djibouti" },
            { "DK", "Tanska" },
            { "ach", "at\u0161oli" },
            { "gon", "gondi" },
            { "Brai", "braille-pistekirjoitus" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "DO", "Dominikaaninen tasavalta" },
            { "gor", "gorontalo" },
            { "got", "gootti" },
            { "vmf", "maininfrankki" },
            { "Mtei", "meitei" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta ja Melilla" },
            { "chb", "t\u0161ibt\u0161a" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamentu" },
            { "ada", "adangme" },
            { "EE", "Viro" },
            { "tiv", "tiv" },
            { "EG", "Egypti" },
            { "EH", "L\u00e4nsi-Sahara" },
            { "chg", "t\u0161agatai" },
            { "pau", "palau" },
            { "chk", "chuuk" },
            { "chn", "chinook-jargon" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Espanja" },
            { "ET", "Etiopia" },
            { "EU", "Euroopan unioni" },
            { "elx", "elami" },
            { "chy", "cheyenne" },
            { "Inds", "induslainen" },
            { "ady", "adyge" },
            { "aeb", "tunisianarabia" },
            { "FI", "Suomi" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandinsaaret" },
            { "FM", "Mikronesian liittovaltio" },
            { "FO", "F\u00e4rsaaret" },
            { "Taml", "tamililainen" },
            { "FR", "Ranska" },
            { "Kpel", metaValue_kpe },
            { "pcd", "picardi" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "juuri" },
            { "%%DAJNKO", "sloveenin Dajnko-aakkosto" },
            { "rgn", "romagnoli" },
            { "grc", "muinaiskreikka" },
            { "GA", "Gabon" },
            { "tkr", "tsahuri" },
            { "vot", "vatja" },
            { "GB", "Iso-Britannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Ranskan Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tailelainen" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nlanti" },
            { "enm", "keskienglanti" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "P\u00e4iv\u00e4ntasaajan Guinea" },
            { "GR", "Kreikka" },
            { "GS", "Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "pennsylvaniansaksa" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "uusi tailuelainen" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "ei kielellist\u00e4 sis\u00e4lt\u00f6\u00e4" },
            { "Jurc", "d\u017eurt\u0161en" },
            { "tly", "tali\u0161i" },
            { "pdt", "plautdietsch" },
            { "de_AT", "it\u00e4vallansaksa" },
            { "HK", "Hongkong \u2013 Kiinan e.h.a." },
            { "Vaii", "vailainen" },
            { "HM", "Heard ja McDonaldinsaaret" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsinsaksa" },
            { "HT", "Haiti" },
            { "HU", "Unkari" },
            { "rif", "tarifit" },
            { "tmh", "tama\u0161ek" },
            { "IC", "Kanariansaaret" },
            { "nan", "min nan -kiina" },
            { "ID", "Indonesia" },
            { "peo", "muinaispersia" },
            { "IE", "Irlanti" },
            { "nap", "napoli" },
            { "%%NDYUKA", "ndyukan kreolimurre" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabatealainen" },
            { "IM", "Mansaari" },
            { "IN", "Intia" },
            { "IO", "Brittil\u00e4inen Intian valtameren alue" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanti" },
            { "IT", "Italia" },
            { "Zmth", "matemaattinen" },
            { "vro", "v\u00f5ro" },
            { "guc", "wayuu" },
            { "%%POSIX", "tietokonem\u00e4\u00e4rittely POSIX" },
            { "pfl", "pfaltsi" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "Beng", "bengalilainen" },
            { "%%EKAVSK", "serbian ekavialainen \u00e4\u00e4nt\u00e4mys" },
            { "JO", "Jordania" },
            { "gur", "frafra" },
            { "JP", "Japani" },
            { "%%1606NICT", "my\u00f6h\u00e4iskeskiranska" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "puolan kociewielainen murre" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "malawintonga" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham-tavukirjoitus" },
            { "de_CH", "sveitsinyl\u00e4saksa" },
            { "izh", "inkeroinen" },
            { "KE", "Kenia" },
            { "419", "Latinalainen Amerikka" },
            { "KG", "Kirgisia" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komorit" },
            { "KN", "Saint Kitts ja Nevis" },
            { "Knda", "kannadalainen" },
            { "Zinh", "peritty" },
            { "fr_CA", "kanadanranska" },
            { "KP", "Pohjois-Korea" },
            { "KR", "Etel\u00e4-Korea" },
            { "Plrd", "Pollardin foneettinen" },
            { "fr_CH", "sveitsinranska" },
            { "KW", "Kuwait" },
            { "tpi", "tok-pisin" },
            { "KY", "Caymansaaret" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "kyrillinen" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "phn", "foinikia" },
            { "Cyrs", "kyrillinen muinaiskirkkoslaavimuunnelma" },
            { "gwi", "gwit\u0161in" },
            { "%%LUNA1918", "ven\u00e4j\u00e4n ortografia 1918" },
            { "nds", "alasaksa" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadi" },
            { "cop", "kopti" },
            { "LR", "Liberia" },
            { "esu", "alaskanjupik" },
            { "LS", "Lesotho" },
            { "Phlv", "kirjapahlavilainen" },
            { "LT", "Liettua" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "Sora", "sorang sompeng" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "%%LAUKIKA", "klassinen sanskriitti" },
            { "lah", "lahnda" },
            { "Mahj", "mahajanilainen" },
            { "lag", "lango" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinsaaret" },
            { "ale", "aleutti" },
            { "Thai", "thailainen" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao \u2013 Kiinan e.h.a." },
            { "aln", "geg" },
            { "MP", "Pohjois-Mariaanit" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "MU", "Mauritius" },
            { "alt", "altai" },
            { "MV", "Malediivit" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "MZ", "Mosambik" },
            { "Phli", "piirtokirjoituspahlavilainen" },
            { "NA", "Namibia" },
            { "NC", "Uusi-Kaledonia" },
            { "%%WADEGILE", "kiinan Wade-Giles-latinaistus" },
            { "tru", "turojo" },
            { "%%UCRCOR", "kornin uusittu yhten\u00e4iskirjoitus" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsaari" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psalttaripahlavilainen" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Alankomaat" },
            { "NO", "Norja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakonia" },
            { "NU", "Niue" },
            { "Phnx", "foinikialainen" },
            { "rof", "rombo" },
            { "tsi", "tsim\u0161i" },
            { "NZ", "Uusi-Seelanti" },
            { "Merc", "meroiittinen kursiivikirjoitus" },
            { "rom", "romani" },
            { "Mero", "meroiittinen" },
            { "crh", "krimintataari" },
            { "ang", "muinaisenglanti" },
            { "OM", "Oman" },
            { "%%PETR1708", "ven\u00e4j\u00e4n Pietarin siviiliaakkosto 1708" },
            { "anp", "angika" },
            { "Xpeo", "muinaispersialainen" },
            { "PA", "Panama" },
            { "csb", "ka\u0161ubi" },
            { "en_GB", "britannianenglanti" },
            { "PE", "Peru" },
            { "ttt", "tati" },
            { "PF", "Ranskan Polynesia" },
            { "PG", "Papua-Uusi-Guinea" },
            { "PH", "Filippiinit" },
            { "PK", "Pakistan" },
            { "PL", "Puola" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiinalaisalueet" },
            { "Bali", "balilainen" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", "heprealainen" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotlanninenglanti" },
            { "jam", "jamaikankreolienglanti" },
            { "pms", "piemonte" },
            { "niu", "niue" },
            { "QO", "ulkomeri" },
            { "ext", "extremadura" },
            { "lez", "lezgi" },
            { "%%FONUPA", "uralilainen foneettinen aakkosto UPA" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "kapverdenkreolin sotaventolainen murreryhm\u00e4" },
            { "001", "maailma" },
            { "002", "Afrikka" },
            { "njo", "ao naga" },
            { "003", "Pohjois-Amerikka" },
            { "RE", "R\u00e9union" },
            { "005", "Etel\u00e4-Amerikka" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontoksenkreikka" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "%%SURSILV", "retoromaanin sursilvan-muoto" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "RU", "Ven\u00e4j\u00e4" },
            { "RW", "Ruanda" },
            { "%%METELKO", "sloveenin Metelko-aakkosto" },
            { "Mani", "manikealainen" },
            { "Ugar", "ugaritilainen" },
            { "Khar", "kharosthi" },
            { "SA", "Saudi-Arabia" },
            { "pon", "pohnpei" },
            { "Mand", "mandealainen" },
            { "SB", "Salomonsaaret" },
            { "twq", "tasawaq" },
            { "011", "L\u00e4nsi-Afrikka" },
            { "SC", "Seychellit" },
            { "SD", "Sudan" },
            { "013", "V\u00e4li-Amerikka" },
            { "SE", "Ruotsi" },
            { "014", "It\u00e4-Afrikka" },
            { "arc", "valtakunnanaramea" },
            { "Loma", "loma" },
            { "015", "Pohjois-Afrikka" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "017", "Keski-Afrikka" },
            { "SI", "Slovenia" },
            { "018", "etel\u00e4inen Afrikka" },
            { "SJ", "Huippuvuoret ja Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Amerikka" },
            { "SK", "Slovakia" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Etel\u00e4-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "arq", "algerianarabia" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syyria" },
            { "yao", "jao" },
            { "SZ", "Swazimaa" },
            { "arw", "arawak" },
            { "arz", "egyptinarabia" },
            { "ary", "marokonarabia" },
            { "yap", "japi" },
            { "rtm", "rotuma" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "pohjoinen Amerikka" },
            { "TC", "Turks- ja Caicossaaret" },
            { "yav", "yangben" },
            { "TD", "T\u0161ad" },
            { "TF", "Ranskan etel\u00e4iset alueet" },
            { "ase", "amerikkalainen viittomakieli" },
            { "TG", "Togo" },
            { "TH", "Thaimaa" },
            { "TJ", "Tad\u017eikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "TL", "It\u00e4-Timor" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "englannin boontling-murre" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "nykyvolap\u00fck" },
            { "TR", "Turkki" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturia" },
            { "rue", "ruteeni" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tansania" },
            { "nmg", "kwasio" },
            { "Zzzz", "tuntematon kirjoitusj\u00e4rjestelm\u00e4" },
            { "Sind", "khudabadi" },
            { "UA", "Ukraina" },
            { "lij", "liguuri" },
            { "rup", "aromania" },
            { "030", "It\u00e4-Aasia" },
            { "tyv", "tuva" },
            { "sw_CD", "kingwana" },
            { "034", "Etel\u00e4-Aasia" },
            { "hai", "haida" },
            { "035", "Kaakkois-Aasia" },
            { "UG", "Uganda" },
            { "hak", "hakka-kiina" },
            { "039", "Etel\u00e4-Eurooppa" },
            { "Sinh", "sinhalilainen" },
            { "UM", "Yhdysvaltain erillissaaret" },
            { "liv", "liivi" },
            { "US", "Yhdysvallat" },
            { "haw", "havaiji" },
            { "%%1959ACAD", "valkoven\u00e4j\u00e4n virallinen oikeinkirjoitus" },
            { "UY", "Uruguay" },
            { "prg", "muinaispreussi" },
            { "UZ", "Uzbekistan" },
            { "tzm", "keskiatlaksentamazight" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikaani" },
            { "pro", "muinaisprovensaali" },
            { "VC", "Saint Vincent ja Grenadiinit" },
            { "VE", "Venezuela" },
            { "VG", "Brittil\u00e4iset Neitsytsaaret" },
            { "VI", "Yhdysvaltain Neitsytsaaret" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "muinaisnorja" },
            { "053", "Australaasia" },
            { "%%AREVMDA", "l\u00e4nsiarmenialainen" },
            { "054", "Melanesia" },
            { "WF", "Wallis ja Futuna" },
            { "057", "Mikronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "%%HEPBURN", "japanin Hepburn-latinaistus" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa" },
            { "wal", "wolaitta" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "kornin standardikirjoitus" },
            { "XK", "Kosovo" },
            { "Gujr", "gud\u017earatilainen" },
            { "Zxxx", "kirjoittamaton" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batakilainen" },
            { "Blis", "bliss-symbolit" },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "lombardi" },
            { "fan", "fang" },
            { "%%BALANKA", "aniin balankalaismurre" },
            { "%%ROZAJ", "sloveenin resian murre" },
            { "%%SUTSILV", "retoromaanin sutsilvan-muoto" },
            { "fat", "fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "Etel\u00e4-Afrikka" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "kiinan pinyin-latinaistus" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tuntematon alue" },
            { "Runr", "riimukirjoitus" },
            { "lol", "mongo" },
            { "nso", "pohjoissotho" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba" },
            { "jmc", "machame" },
            { "hif", "fid\u017einhindi" },
            { "hil", "hiligaino" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "heetti" },
            { "dar", "dargi" },
            { "dav", "taita" },
            { "Maya", "maya-hieroglyfit" },
            { "lrc", "pohjoisluri" },
            { "Copt", "koptilainen" },
            { "nwc", "klassinen newari" },
            { "udm", "udmurtti" },
            { "Khmr", "khmeril\u00e4inen" },
            { "Limb", "limbulainen" },
            { "sad", "sandawe" },
            { "sah", "jakuutti" },
            { "ltg", "latgalli" },
            { "sam", "samarianaramea" },
            { "Aghb", "kaukasianalbanialainen" },
            { "%%SCOUSE", "englannin scouse-murre" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "juutalaispersia" },
            { "saz", "saura\u0161tri" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "alukun kreolimurre" },
            { "lua", "luluanluba" },
            { "%%BISCAYAN", "baskin biskajalaismurre" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lusai" },
            { "bal", "belut\u0161i" },
            { "den", "slevi" },
            { "ban", "bali" },
            { "uga", "ugarit" },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "baijeri" },
            { "bas", "basaa" },
            { "bax", metaValue_bax },
            { "jrb", "juutalaisarabia" },
            { "es_ES", "euroopanespanja" },
            { "nzi", "nzima" },
            { "sco", "skotti" },
            { "scn", "sisilia" },
            { "aa", "afar" },
            { "ab", "abhaasi" },
            { "bbc", "batak-toba" },
            { "ae", "avesta" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amhara" },
            { "an", "aragonia" },
            { "Arab", "arabialainen" },
            { "%%SOLBA", "sloveenin resian Stolvizzan/Solbican alamurre" },
            { "Jpan", "japanilainen" },
            { "ar", "arabia" },
            { "Hrkt", "hiragana tai katakana" },
            { "as", "assami" },
            { "sdc", "sassarinsardi" },
            { "Lina", "lineaari-A" },
            { "av", "avaari" },
            { "Linb", "lineaari-B" },
            { "sdh", "etel\u00e4kurdi" },
            { "ay", "aimara" },
            { "az", "azeri" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "sloveenin resian Oseaccon/Osojanen alamurre" },
            { "%%UNIFON", "englannin foneeminen unifon-aakkosto" },
            { "ba", "ba\u0161kiiri" },
            { "be", "valkoven\u00e4j\u00e4" },
            { "bg", "bulgaria" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tiibet" },
            { "dgr", "dogrib" },
            { "br", "bretoni" },
            { "bs", "bosnia" },
            { "see", "seneca" },
            { "Mymr", "burmalainen" },
            { "sei", "seri" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkuppi" },
            { "ca", "katalaani" },
            { "ses", "koyraboro senni" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "%%REVISED", "uudistettu oikeinkirjoitus" },
            { "co", "korsika" },
            { "Orya", "orijalainen" },
            { "cr", "cree" },
            { "cs", "t\u0161ekki" },
            { "cu", "kirkkoslaavi" },
            { "yrl", "\u00f1eengat\u00fa" },
            { "cv", "t\u0161uvassi" },
            { "cy", "kymri" },
            { "Yiii", "yil\u00e4inen" },
            { "da", "tanska" },
            { "pt_PT", "euroopanportugali" },
            { "de", "saksa" },
            { "bej", "bed\u017ea" },
            { "din", "dinka" },
            { "jut", "juutti" },
            { "Bugi", "bugilainen" },
            { "bem", "bemba" },
            { "sga", "muinaisiiri" },
            { "dv", "divehi" },
            { "es_419", "amerikanespanja" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "lzh", "klassinen kiina" },
            { "Lisu", "Fraserin aakkoset" },
            { "dje", "djerma" },
            { "sgs", "samogiitti" },
            { "ee", "ewe" },
            { "bfd", "fut" },
            { "ro_MD", "moldova" },
            { "el", "kreikka" },
            { "en", "englanti" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazi" },
            { "es", "espanja" },
            { "et", "viro" },
            { "eu", "baski" },
            { "Buhd", "buhidilainen" },
            { "Hang", "hangul" },
            { "Samr", "samarianaramealainen" },
            { "shi", "ta\u0161elhit" },
            { "hsb", "yl\u00e4sorbi" },
            { "Hani", "kiinalainen han" },
            { "%%ULSTER", "skotin ulster-murre" },
            { "shn", "shan" },
            { "Hano", "hanunoolainen" },
            { "fa", "farsi" },
            { "Hans", "yksinkertaistettu han" },
            { "Hant", "perinteinen han" },
            { "ff", "fulani" },
            { "shu", "t\u0161adinarabia" },
            { "hsn", "xiang-kiina" },
            { "fi", "suomi" },
            { "fj", "fid\u017ei" },
            { "fon", "fon" },
            { "bgn", "l\u00e4nsibelut\u0161i" },
            { "yue", "kantoninkiina" },
            { "fo", "f\u00e4\u00e4ri" },
            { "umb", "mbundu" },
            { "fr", "ranska" },
            { "sid", "sidamo" },
            { "fy", "l\u00e4nsifriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galicia" },
            { "gn", "guarani" },
            { "bho", "bhod\u017epuri" },
            { "und", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n kieli" },
            { "gu", "gud\u017earati" },
            { "gv", "manksi" },
            { "ha", "hausa" },
            { "he", "heprea" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri-motu" },
            { "hr", "kroatia" },
            { "ht", "haiti" },
            { "hu", "unkari" },
            { "hy", "armenia" },
            { "hz", "herero" },
            { "frc", "cajun" },
            { "%%FONIPA", "kansainv\u00e4linen foneettinen aakkosto IPA" },
            { "ia", "interlingua" },
            { "id", "indonesia" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuanin-yi" },
            { "frm", "keskiranska" },
            { "%%RUMGR", "retoromaanin rumantsch grischun -muoto" },
            { "ik", "inupiaq" },
            { "fro", "muinaisranska" },
            { "frp", "arpitaani" },
            { "io", "ido" },
            { "frs", "it\u00e4friisi" },
            { "bjn", "banjar" },
            { "frr", "pohjoisfriisi" },
            { "is", "islanti" },
            { "it", "italia" },
            { "iu", "inuktitut" },
            { "sli", "sleesiansaksa" },
            { "%%HOGNORSK", "norjan h\u00f6gnorsk" },
            { "ja", "japani" },
            { "Mlym", "malajalamilainen" },
            { "Sarb", "muinaisetel\u00e4arabialainen" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "bkm", "kom" },
            { "sma", "etel\u00e4saame" },
            { "jv", "jaava" },
            { "Shaw", "shaw\u2019lainen" },
            { "%%BAUDDHA", "sanskriitin buddhalainen sekamuoto" },
            { "mad", "madura" },
            { "smj", "luulajansaame" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inarinsaame" },
            { "ka", "georgia" },
            { "bla", "siksika" },
            { "mak", "makassar" },
            { "wuu", "wu-kiina" },
            { "sms", "koltansaame" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "goottilainen" },
            { "ki", "kikuju" },
            { "mas", "maasai" },
            { "kj", "kuanjama" },
            { "kk", "kazakki" },
            { "kl", "kalaallisut" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "korea" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepchalainen" },
            { "Avst", "avestalainen" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "snk", "soninke" },
            { "Mult", "multanilainen" },
            { "la", "latina" },
            { "Hatr", "hatralainen" },
            { "lb", "luxemburg" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburg" },
            { "Tibt", "tiibetil\u00e4inen" },
            { "ln", "lingala" },
            { "fur", "friuli" },
            { "lo", "lao" },
            { "lt", "liettua" },
            { "lu", "katanganluba" },
            { "lv", "latvia" },
            { "sog", "sogdi" },
            { "mg", "malagassi" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedonia" },
            { "ml", "malajalam" },
            { "mn", "mongoli" },
            { "mr", "marathi" },
            { "ms", "malaiji" },
            { "mt", "malta" },
            { "my", "burma" },
            { "Saur", "saurashtra" },
            { "Armn", "armenialainen" },
            { "mdf", "mok\u0161a" },
            { "mde", "maba" },
            { "dsb", "alasorbi" },
            { "Armi", "valtakunnanaramealainen" },
            { "na", "nauru" },
            { "nb", "norjan bokm\u00e5l" },
            { "nd", "pohjois-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "hollanti" },
            { "nn", "norjan nynorsk" },
            { "no", "norja" },
            { "nr", "etel\u00e4-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakki" },
            { "ny", "njand\u017ea" },
            { "kac", "kat\u0161in" },
            { "kab", "kabyyli" },
            { "%%POLYTON", "polytoninen kreikka" },
            { "oc", "oksitaani" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "varhaisnykyenglanti" },
            { "oj", "od\u017eibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kavi" },
            { "dtp", "dusun" },
            { "or", "orija" },
            { "Modi", "modi-aakkoset" },
            { "os", "osseetti" },
            { "%%ALALC97", "amerikkalainen kirjastolatinaistus 1997" },
            { "bpy", "bi\u0161nupria" },
            { "kbd", "kabardi" },
            { "mfe", "morisyen" },
            { "srn", "sranan" },
            { "pa", "pand\u017eabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "sloveenin resian Lipovazin/Lipovecin alamurre" },
            { "kbl", "kanembu" },
            { "pi", "paali" },
            { "bqi", "bahtiari" },
            { "pl", "puola" },
            { "dum", "keskihollanti" },
            { "%%VALLADER", "reoromaanin vallader-muoto" },
            { "ps", "pa\u0161tu" },
            { "pt", "portugali" },
            { "mga", "keski-iiri" },
            { "pt_BR", "brasilianportugali" },
            { "%%BOHORIC", "sloveenin Bohori\u010d-aakkosto" },
            { "kcg", "tyap" },
            { "mgh", "makua-meetto" },
            { "bra", "brad\u017e" },
            { "%%JAUER", "retoromaanin jauer-murre" },
            { "Laoo", "laolainen" },
            { "%%SURMIRAN", "retoromaanin surmiran-muoto" },
            { "mgo", "meta\u2019" },
            { "ssy", "saho" },
            { "brh", "brahui" },
            { "qu", "ket\u0161ua" },
            { "zap", "zapoteekki" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "sanskriitin veda-murre" },
            { "stq", "saterlandinfriisi" },
            { "Ethi", "etiopialainen" },
            { "%%JYUTPING", "kantoninkiinan jyutping-latinaistus" },
            { "rm", "retoromaani" },
            { "rn", "rundi" },
            { "ro", "romania" },
            { "%%SAAHO", "afarin saho-murre" },
            { "ru", "ven\u00e4j\u00e4" },
            { "bss", "koose" },
            { "rw", "ruanda" },
            { "zbl", "blisskieli" },
            { "kea", "kapverdenkreoli" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australianenglanti" },
            { "Dupl", "Duploy\u00e9n pikakirjoitus" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "kornin yhten\u00e4iskirjoitus" },
            { "sc", "sardi" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "pohjoissaame" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroaatti" },
            { "ken", "kenyang" },
            { "si", "sinhala" },
            { "sux", "sumeri" },
            { "sk", "slovakki" },
            { "sl", "sloveeni" },
            { "Gran", "grantha" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somali" },
            { "sq", "albania" },
            { "sr", "serbia" },
            { "ss", "swazi" },
            { "st", "etel\u00e4sotho" },
            { "Java", "jaavalainen" },
            { "su", "sunda" },
            { "%%NEDIS", "sloveenin natisonen murre" },
            { "sv", "ruotsi" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamili" },
            { "142", "Aasia" },
            { "bua", "burjaatti" },
            { "143", "Keski-Aasia" },
            { "te", "telugu" },
            { "145", "L\u00e4nsi-Aasia" },
            { "tg", "tad\u017eikki" },
            { "th", "thai" },
            { "ti", "tigrinja" },
            { "bug", "bugi" },
            { "kfo", "norsunluurannikonkoro" },
            { "en_CA", "kanadanenglanti" },
            { "tk", "turkmeeni" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "turkki" },
            { "ts", "tsonga" },
            { "swb", "komori" },
            { "Cakm", "chakmalainen" },
            { "tt", "tataari" },
            { "dyu", "djula" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "%%BISKE", "sloveenin resian San Giorgion/Bilan alamurre" },
            { "150", "Eurooppa" },
            { "151", "It\u00e4-Eurooppa" },
            { "154", "Pohjois-Eurooppa" },
            { "dzg", "dazaga" },
            { "155", "L\u00e4nsi-Eurooppa" },
            { "ug", "uiguuri" },
            { "Ital", "muinaisitalialainen" },
            { "Kore", "korealainen" },
            { "kgp", "kaingang" },
            { "Zyyy", "m\u00e4\u00e4ritt\u00e4m\u00e4t\u00f6n" },
            { "uk", "ukraina" },
            { "zea", "seelanti" },
            { "ur", "urdu" },
            { "%%1994", "sloveenin resian murteen yhdenmukaistettu oikeinkirjoitus" },
            { "xal", "kalmukki" },
            { "zen", "zenaga" },
            { "uz", "uzbekki" },
            { "kha", "khasi" },
            { "%%1996", "saksan uusi oikeinkirjoitus" },
            { "nds_NL", "alankomaidenalasaksa" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "vi", "vietnam" },
            { "kho", "khotani" },
            { "khq", "koyra chiini" },
            { "%%TARASK", "valkoven\u00e4j\u00e4n tara\u0161kevitsa-oikeinkirjoitus" },
            { "vo", "volap\u00fck" },
            { "khw", "khowar" },
            { "syc", "muinaissyyria" },
            { "Osma", "osmanjalainen" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "chimborazonyl\u00e4nk\u00f6ket\u0161ua" },
            { "gaa", "ga" },
            { "wa", "valloni" },
            { "gag", "gagauzi" },
            { "syr", "syyria" },
            { "Grek", "kreikkalainen" },
            { "gan", "gan-kiina" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lyydialainen" },
            { "Xsux", "sumerilais-akkadilainen nuolenp\u00e4\u00e4kirjoitus" },
            { "wo", "wolof" },
            { "zgh", "vakioitu tamazight" },
            { "ar_001", "yleisarabia" },
            { "Cans", "kanadalaisten alkuper\u00e4iskansojen yhten\u00e4istetty tavukirjoitus" },
            { "%%FONXSAMP", "foneettinen X-SAMPA-merkist\u00f6" },
            { "gay", "gajo" },
            { "Mong", "mongolilainen" },
            { "mnc", "mant\u0161u" },
            { "Latf", "latinalainen fraktuuramuunnelma" },
            { "szl", "sleesia" },
            { "Hluw", "anatolialaiset hieroglyfit" },
            { "gba", "gbaja" },
            { "mni", "manipuri" },
            { "Latn", "latinalainen" },
            { "Latg", "latinalainen gaelimuunnelma" },
            { "xh", "xhosa" },
            { "byn", "bilin" },
            { "%%PAMAKA", "pamakan kreolimurre" },
            { "Lyci", "lyykialainen" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zoroastrialaisdari" },
            { "Moon", "moon-kohokirjoitus" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "varhaisnykyranska" },
            { "yi", "jiddi\u0161" },
            { "mos", "mossi" },
            { "Syrc", "syyrialainen" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "es_MX", "meksikonespanja" },
            { "Syrj", "syyrialainen l\u00e4ntinen muunnelma" },
            { "ota", "osmani" },
            { "Syre", "syyrialainen estrangelo-muunnelma" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "Cari", "kaarialainen" },
            { "kln", "kalenjin" },
            { "zh", "kiina" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "muinaispermil\u00e4inen" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotoninen kreikka" },
            { "Geor", "georgialainen" },
            { "Shrd", "\u0161arada" },
            { "kmb", "kimbundu" },
            { "Cham", "t\u0161amilainen" },
            { "gez", "ge\u2019ez" },
            { "mrj", "vuorimari" },
            { "Syrn", "syyrialainen it\u00e4inen muunnelma" },
            { "Elba", "elbasanilainen" },
            { "Narb", "muinaispohjoisarabialainen" },
            { "Tglg", "tagalogilainen" },
            { "Egyd", "egyptil\u00e4inen demoottinen" },
            { "Egyh", "egyptil\u00e4inen hieraattinen" },
            { "%%ITIHASA", "sanskriitin eeppinen muoto" },
            { "Palm", "palmyralainen" },
            { "ebu", "embu" },
            { "Egyp", "egyptil\u00e4iset hieroglyfit" },
            { "Geok", "muinaisgeorgialainen" },
            { "zh_Hans", "yksinkertaistettu kiina" },
            { "koi", "komipermjakki" },
            { "Hung", "muinaisunkarilainen" },
            { "kok", "konkani" },
            { "%%1901", "saksan perinteinen oikeinkirjoitus" },
            { "kos", "kosrae" },
            { "vec", "venetsia" },
            { "zh_Hant", "perinteinen kiina" },
            { "Sund", "sundalainen" },
            { "vep", "veps\u00e4" },
            { "kpe", metaValue_kpe },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "katalaanin valencian murre" },
            { "Cprt", "muinaiskyproslainen" },
            { "%%BAKU1926", "yhten\u00e4istetty turkkilainen latinalainen aakkosto" },
            { "%%IJEKAVSK", "serbian ijekavialainen \u00e4\u00e4nt\u00e4miys" },
            { "mua", "mundang" },
            { "mul", "monia kieli\u00e4" },
            { "%%PUTER", "retoromaanin puter-muoto" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagoliittinen" },
            { "gil", "kiribati" },
            { "%%KKCOR", "kornin yleiskirjoitus" },
            { "Cher", "cherokeelainen" },
            { "car", "karibi" },
            { "cay", "cayuga" },
            { "krc", "karat\u0161ai-balkaari" },
            { "inh", "inguu\u0161i" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karjala" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", "telugulainen" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
