/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.J2SEAppController;
import bt747.j2se_view.J2SEAppModel;
import bt747.j2se_view.MyMap;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.j2se_view.model.GPSPositionWaypoint;
import bt747.j2se_view.model.MapWaypoint;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import gps.GpsEvent;
import gps.convert.Conv;
import gps.log.GPSRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import net.sf.bt747.j2se.app.map.BT747TrackRenderer;
import net.sf.bt747.j2se.app.map.MapFactoryInfos;
import net.sf.bt747.j2se.app.map.MapRendererFactoryMethod;
import net.sf.bt747.j2se.app.map.MyTileFactoryInfo;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

public final class WaypointMapKit
extends JPanel
implements ModelListener {
    private JXMapViewer mapViewer;
    private MyWaypointPainter<JXMapViewer> waypointPainter;
    private DefaultTileFactory tf = null;
    private BT747TrackRenderer trackRenderer;
    private J2SEAppController c;
    private J2SEAppModel m;
    private mouseListener ml;
    private final PropertyChangeListener wpChangeListener;
    private final PropertyChangeListener wpSelectedListener;
    private volatile GPSPositionWaypoint gpsPosition;
    private JXMapKit map;

    public WaypointMapKit() {
        new EventListenerList();
        this.wpChangeListener = new PropertyChangeListener(this){
            private /* synthetic */ WaypointMapKit this$0;
            {
                this.this$0 = waypointMapKit;
            }

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.this$0.map.repaint();
            }
        };
        this.wpSelectedListener = new PropertyChangeListener(this){
            private /* synthetic */ WaypointMapKit this$0;
            {
                this.this$0 = waypointMapKit;
            }

            public final void propertyChange(PropertyChangeEvent object) {
                try {
                    object = (MapWaypoint)((Object)((PropertyChangeEvent)object).getNewValue());
                    if (((MapWaypoint)((Object)object)).getGpsRecord().hasPosition()) {
                        this.this$0.map.setAddressLocation(((MapWaypoint)((Object)object)).getPosition());
                    }
                    this.this$0.map.repaint();
                    return;
                }
                catch (Exception exception) {
                    Generic.debug("Waypoint selection", exception);
                    return;
                }
            }
        };
        this.gpsPosition = null;
        WaypointMapKit waypointMapKit = this;
        this.map = new JXMapKit();
        GroupLayout groupLayout = new GroupLayout((Container)waypointMapKit);
        waypointMapKit.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)waypointMapKit.map, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)waypointMapKit.map, -1, -1, Short.MAX_VALUE));
    }

    public final void init(J2SEAppController modelListener) {
        this.c = modelListener;
        this.m = this.c.getAppModel();
        this.m.addListener(this);
        modelListener = this;
        ((WaypointMapKit)modelListener).map.setMiniMapVisible(true);
        ((WaypointMapKit)modelListener).mapViewer = ((WaypointMapKit)modelListener).map.getMainMap();
        ((WaypointMapKit)modelListener).waypointPainter = new MyWaypointPainter((WaypointMapKit)modelListener, 0);
        ((WaypointMapKit)modelListener).trackRenderer = BT747TrackRenderer.getInstance();
        ((WaypointMapKit)modelListener).waypointPainter.setTrackRenderer(((WaypointMapKit)modelListener).trackRenderer);
        ((WaypointMapKit)modelListener).waypointPainter.setRenderer(MapRendererFactoryMethod.getInstance());
        ((WaypointMapKit)modelListener).mapViewer.setRecenterOnClickEnabled(true);
        ((WaypointMapKit)modelListener).mapViewer.getOverlayPainter();
        CompoundPainter compoundPainter = new CompoundPainter();
        compoundPainter.setPainters(new Painter[]{((WaypointMapKit)modelListener).mapViewer.getOverlayPainter(), ((WaypointMapKit)modelListener).waypointPainter});
        ((WaypointMapKit)modelListener).mapViewer.setOverlayPainter((Painter)compoundPainter);
        ((WaypointMapKit)modelListener).ml = new mouseListener((WaypointMapKit)modelListener, 0);
        ((WaypointMapKit)modelListener).mapViewer.addMouseListener((MouseListener)((WaypointMapKit)modelListener).ml);
        ((WaypointMapKit)modelListener).mapViewer.addMouseMotionListener((MouseMotionListener)((WaypointMapKit)modelListener).ml);
        ((WaypointMapKit)modelListener).m.getPositionData().addPropertyChangeListener("wpdisplaychange", ((WaypointMapKit)modelListener).wpChangeListener);
        ((WaypointMapKit)modelListener).m.getPositionData().addPropertyChangeListener("selectedwaypoint", ((WaypointMapKit)modelListener).wpSelectedListener);
        this.updateMap();
        this.map.setZoom(this.tf.getInfo().getMaximumZoomLevel() - 4);
        this.map.setAddressLocation(new GeoPosition(51.5, 0.0));
        this.setMapTileCacheDirectory();
    }

    public final GeoPosition getCenterPosition() {
        return this.mapViewer.getCenterPosition();
    }

    public final void setZoom$13462e() {
        this.map.setZoom(5);
    }

    public final void setZoomSliderVisible$1385ff() {
        this.map.setZoomSliderVisible(false);
    }

    public final void setMiniMapVisible$1385ff() {
        this.map.setMiniMapVisible(false);
    }

    public final void modelEvent(ModelEvent object) {
        switch (((GpsEvent)object).getType()) {
            case 269: {
                try {
                    switch (Integer.valueOf((String)((GpsEvent)object).getArg())) {
                        case 25: {
                            this.setMapTileCacheDirectory(this.m.getStringOpt(25));
                            return;
                        }
                        case 27: {
                            this.updateMap();
                            return;
                        }
                        case 43: {
                            object = new Color(Conv.hex2Int(this.m.getStringOpt(43)));
                            this.trackRenderer.setColor((Color)object);
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    Generic.debug("MyMap modelevent", exception);
                    return;
                }
            }
            case 3: {
                object = (GPSRecord)((GpsEvent)object).getArg();
                if (!((GPSRecord)object).hasPosition() || !((GPSRecord)object).hasValid() || (((GPSRecord)object).valid & 1) != 0) break;
                if (this.gpsPosition == null) {
                    this.mapViewer.setCenterPosition(new GeoPosition(((GPSRecord)object).latitude, ((GPSRecord)object).longitude));
                    this.mapViewer.setZoom(4);
                    this.gpsPosition = new GPSPositionWaypoint((GPSRecord)object);
                } else {
                    this.gpsPosition.setGpsRec((GPSRecord)object);
                    if (this.m.getBooleanOpt(94)) {
                        this.mapViewer.setCenterPosition(new GeoPosition(((GPSRecord)object).latitude, ((GPSRecord)object).longitude));
                    }
                }
                this.mapViewer.repaint();
                return;
            }
            case 1001: {
                this.setZoom();
                return;
            }
            case 1000: 
            case 1002: {
                this.setZoom();
            }
        }
    }

    private void updateMap() {
        int n = this.m.getIntOpt(27);
        WaypointMapKit waypointMapKit = this;
        try {
            waypointMapKit.setMap$56c8592a(MyMap.MapType.values$52b4ea37()[n]);
            return;
        }
        catch (Exception exception) {
            waypointMapKit.setMap$56c8592a(MyMap.MapType.values$52b4ea37()[0]);
            return;
        }
    }

    private void setMapTileCacheDirectory() {
        if (this.m != null) {
            this.setMapTileCacheDirectory(this.m.getStringOpt(25));
        }
    }

    private void setMapTileCacheDirectory(String object) {
        if (((File)(object = new File((String)object))).exists() && ((File)object).isDirectory() && this.tf != null) {
            try {
                this.tf.getTileCache().setDiskCacheDir((File)object);
                return;
            }
            catch (Exception exception) {
                Generic.debug("Map tile directory setting", exception);
            }
        }
    }

    private boolean setZoom() {
        Object object;
        double d = 90.0;
        double d2 = 180.0;
        double d3 = -90.0;
        double d4 = -180.0;
        boolean bl = false;
        List<List<GPSRecord>> list = this.m.getPositionData().getTracks();
        if (list != null && list.size() != 0) {
            list = list.iterator();
            while (list.hasNext()) {
                for (GPSRecord gPSRecord : (List)((Object)list.next())) {
                    if (!gPSRecord.hasPosition()) continue;
                    if (gPSRecord.latitude < d) {
                        d = gPSRecord.latitude;
                    }
                    if (gPSRecord.latitude > d3) {
                        d3 = gPSRecord.latitude;
                    }
                    if (gPSRecord.longitude < d2) {
                        d2 = gPSRecord.longitude;
                    }
                    if (gPSRecord.longitude > d4) {
                        d4 = gPSRecord.longitude;
                    }
                    bl = true;
                }
            }
        }
        list = this.m.getPositionData().getBT747Waypoints().iterator();
        while (list.hasNext()) {
            object = list.next().getGpsRecord();
            if (!((GPSRecord)object).hasLatitude() || !((GPSRecord)object).hasLongitude()) continue;
            if (((GPSRecord)object).latitude < d) {
                d = ((GPSRecord)object).latitude;
            }
            if (((GPSRecord)object).latitude > d3) {
                d3 = ((GPSRecord)object).latitude;
            }
            if (((GPSRecord)object).longitude < d2) {
                d2 = ((GPSRecord)object).longitude;
            }
            if (((GPSRecord)object).longitude > d4) {
                d4 = ((GPSRecord)object).longitude;
            }
            bl = true;
        }
        list = this.m.getPositionData().getBT747UserWaypoints().iterator();
        while (list.hasNext()) {
            object = list.next().getGpsRecord();
            if (!((GPSRecord)object).hasLatitude() || !((GPSRecord)object).hasLongitude()) continue;
            if (((GPSRecord)object).latitude < d) {
                d = ((GPSRecord)object).latitude;
            }
            if (((GPSRecord)object).latitude > d3) {
                d3 = ((GPSRecord)object).latitude;
            }
            if (((GPSRecord)object).longitude < d2) {
                d2 = ((GPSRecord)object).longitude;
            }
            if (((GPSRecord)object).longitude > d4) {
                d4 = ((GPSRecord)object).longitude;
            }
            bl = true;
        }
        if (bl) {
            list = new HashSet<GeoPosition>();
            list.add((List<GPSRecord>)new GeoPosition(d, d2));
            list.add((List<GPSRecord>)new GeoPosition(d3, d4));
            this.mapViewer.calculateZoomFrom((Set)((Object)list));
        }
        return bl;
    }

    private void setMap$56c8592a(int n) {
        MyTileFactoryInfo myTileFactoryInfo;
        switch (n - 1) {
            case 1: {
                myTileFactoryInfo = MapFactoryInfos.tfiOSM_OSMARENDER;
                break;
            }
            case 2: {
                myTileFactoryInfo = MapFactoryInfos.tfiOSM_OSM_CYCLE_THUNDER;
                break;
            }
            case 7: {
                myTileFactoryInfo = MapFactoryInfos.tfiOSM_OSM_CYCLE_CLOUDMADE;
                break;
            }
            case 3: {
                myTileFactoryInfo = MapFactoryInfos.tfiOpnvStreetMap;
                break;
            }
            case 4: {
                myTileFactoryInfo = MapFactoryInfos.tfiOpenPisteMapContours;
                break;
            }
            case 8: {
                myTileFactoryInfo = MapFactoryInfos.tfiOpenPisteMapNoContours;
                break;
            }
            case 5: {
                myTileFactoryInfo = MapFactoryInfos.tfiDigitalGlobe;
                break;
            }
            default: {
                myTileFactoryInfo = MapFactoryInfos.tfiOpenStreetMap;
            }
        }
        Rectangle rectangle = this.map.getMainMap().getViewportBounds();
        HashSet<GeoPosition> hashSet = new HashSet<GeoPosition>();
        TileFactory tileFactory = this.map.getMainMap().getTileFactory();
        int n2 = this.map.getMainMap().getZoom();
        hashSet.add(tileFactory.pixelToGeo((Point2D)new Point2D.Double(rectangle.getX(), rectangle.getY()), n2));
        hashSet.add(tileFactory.pixelToGeo((Point2D)new Point2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight() - 1.0), n2));
        hashSet.add(tileFactory.pixelToGeo((Point2D)new Point2D.Double(rectangle.getX() + rectangle.getWidth() - 1.0, rectangle.getY()), n2));
        hashSet.add(tileFactory.pixelToGeo((Point2D)new Point2D.Double(rectangle.getX() + rectangle.getWidth() - 1.0, rectangle.getY() + rectangle.getHeight() - 1.0), n2));
        this.tf = new DefaultTileFactory((TileFactoryInfo)myTileFactoryInfo);
        this.setMapTileCacheDirectory();
        this.map.setTileFactory((TileFactory)this.tf);
        if (MyTileFactoryInfo.class.isInstance((Object)myTileFactoryInfo)) {
            this.map.getDataProviderLink().setAction((Action)((Object)new MyLinkAction(myTileFactoryInfo.description, myTileFactoryInfo.url)));
            this.map.getDataProviderLink().setText(myTileFactoryInfo.description);
            this.map.setDataProviderLinkShown(true);
        } else {
            this.map.setDataProviderLinkShown(false);
        }
        this.map.setAddressLocationShown(false);
        this.mapViewer.calculateZoomFrom(hashSet);
    }

    final class mouseListener
    implements MouseListener,
    MouseMotionListener {
        private MapWaypoint currentWaypoint = null;
        private int xOffset;
        private int yOffset;
        private long selectionTime = 0L;
        private /* synthetic */ WaypointMapKit this$0;

        private mouseListener(WaypointMapKit waypointMapKit) {
            this.this$0 = waypointMapKit;
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getButton()) {
                case 3: {
                    Object object = mouseEvent.getPoint();
                    object = (MapWaypoint)this.this$0.waypointPainter.getContains((Point)object);
                    if (object == null) break;
                    ((MapWaypoint)((Object)object)).toggleShowTag();
                    this.this$0.map.repaint();
                    mouseEvent.consume();
                }
            }
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }

        private void clearWaypointSelection() {
            if (this.currentWaypoint != null) {
                this.currentWaypoint.setSelected(false);
                this.currentWaypoint = null;
            }
        }

        public final void mousePressed(MouseEvent serializable) {
            this.selectionTime = 0L;
            switch (((MouseEvent)serializable).getButton()) {
                case 1: {
                    serializable = ((MouseEvent)serializable).getPoint();
                    try {
                        Object object = (MapWaypoint)this.this$0.waypointPainter.getContains((Point)serializable);
                        if (object == null) {
                            this.clearWaypointSelection();
                        } else {
                            if (object != this.currentWaypoint) {
                                this.clearWaypointSelection();
                            }
                            this.currentWaypoint = object;
                            ((MapWaypoint)((Object)object)).setSelected(true);
                            object = this.this$0.mapViewer.convertGeoPositionToPoint(((MapWaypoint)((Object)object)).getPosition());
                            this.xOffset = (int)(((Point)serializable).getX() - ((Point2D)object).getX());
                            this.yOffset = (int)(((Point)serializable).getY() - ((Point2D)object).getY());
                            this.this$0.mapViewer.setPanEnabled(false);
                            this.this$0.repaint();
                        }
                    }
                    catch (Exception exception) {
                        Generic.debug("Mouse pressed", exception);
                    }
                    this.selectionTime = System.currentTimeMillis();
                }
            }
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            switch (mouseEvent.getButton()) {
                case 1: {
                    if (this.currentWaypoint == null) break;
                    this.this$0.mapViewer.setPanEnabled(true);
                }
            }
        }

        public final void mouseDragged(MouseEvent serializable) {
            if (this.selectionTime != 0L && System.currentTimeMillis() - this.selectionTime < 150L) {
                this.this$0.mapViewer.setPanEnabled(true);
                this.selectionTime = 0L;
            }
            if (this.selectionTime != 0L && this.currentWaypoint != null) {
                ((InputEvent)serializable).consume();
                serializable = ((MouseEvent)serializable).getPoint();
                this.currentWaypoint.setPosition(this.this$0.mapViewer.convertPointToGeoPosition((Point2D)new Point2D.Double(((Point)serializable).getX() - (double)this.xOffset, ((Point)serializable).getY() - (double)this.yOffset)));
                this.this$0.mapViewer.repaint();
            }
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
        }

        /* synthetic */ mouseListener(WaypointMapKit waypointMapKit, byte by) {
            this(waypointMapKit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class wpIterable
    implements Iterable<Waypoint> {
        @Override
        public final Iterator<Waypoint> iterator() {
            return new I(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class I
        implements Iterator<Waypoint> {
            private Iterator<MapWaypoint> i = null;
            private int type$683c928c = 1;
            private /* synthetic */ wpIterable this$1;

            public I(wpIterable wpIterable2) {
                this.this$1 = wpIterable2;
            }

            @Override
            public final boolean hasNext() {
                if (this.i != null && this.i.hasNext()) {
                    return true;
                }
                switch (this.type$683c928c - 1) {
                    case 0: {
                        if (this.this$1.WaypointMapKit.this.gpsPosition != null) {
                            return true;
                        }
                        this.type$683c928c = 2;
                        this.i = this.this$1.WaypointMapKit.this.m.getPositionData().getBT747Waypoints().iterator();
                        if (this.i.hasNext()) {
                            return true;
                        }
                    }
                    case 1: {
                        this.type$683c928c = 3;
                        this.i = this.this$1.WaypointMapKit.this.m.getPositionData().getBT747UserWaypoints().iterator();
                        return this.i.hasNext();
                    }
                    case 2: {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public final void remove() {
                if (this.i != null) {
                    this.i.remove();
                    this.i = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MyWaypointPainter<T extends JXMapViewer>
    extends WaypointPainter<JXMapViewer> {
        private JXMapViewer map;
        private BT747TrackRenderer trackRenderer;
        private /* synthetic */ WaypointMapKit this$0;

        private MyWaypointPainter(WaypointMapKit waypointMapKit) {
            this.this$0 = waypointMapKit;
            this.map = this.this$0.mapViewer;
        }

        protected final void doPaint(Graphics2D graphics2D, JXMapViewer jXMapViewer, int n, int n2) {
            List<List<GPSRecord>> list = this.this$0.m.getPositionData().getTracks();
            if (list != null) {
                for (List list2 : list) {
                    this.trackRenderer.paintTrack(graphics2D, jXMapViewer, list2);
                }
            }
            super.doPaint(graphics2D, jXMapViewer, n, n2);
        }

        public final void setWaypoints(Iterable<Waypoint> iterable) {
            Generic.debug("Waypoints should not be set this way");
        }

        public final Iterable<Waypoint> getWaypoints() {
            WaypointMapKit waypointMapKit = this.this$0;
            return waypointMapKit.new wpIterable();
        }

        public final Waypoint getContains(Point point) {
            double d;
            Rectangle2D rectangle2D = this.map.getViewportBounds();
            int n = this.map.getZoom();
            Cloneable cloneable = this.map.getTileFactory().getMapSize(n);
            n = this.map.getTileFactory().getTileSize(n);
            Object object = new Dimension(cloneable.width * n, cloneable.height * n);
            for (d = rectangle2D.getX(); d < 0.0; d += ((Dimension)object).getWidth()) {
            }
            while (d > ((Dimension)object).getWidth()) {
                d -= ((Dimension)object).getWidth();
            }
            cloneable = new Rectangle2D.Double(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            rectangle2D = new Rectangle2D.Double(d - ((Dimension)object).getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            object = MapRendererFactoryMethod.getInstance();
            Waypoint waypoint = this.findContainingWaypoint(this.this$0.m.getPositionData().getBT747UserWaypoints(), point, (Rectangle2D)cloneable, rectangle2D, (MapRendererFactoryMethod)object);
            if (waypoint != null) {
                return waypoint;
            }
            return this.findContainingWaypoint(this.this$0.m.getPositionData().getBT747Waypoints(), point, (Rectangle2D)cloneable, rectangle2D, (MapRendererFactoryMethod)object);
        }

        private Waypoint findContainingWaypoint(List<MapWaypoint> object, Point point, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, MapRendererFactoryMethod object2) {
            object = object.iterator();
            while (object.hasNext()) {
                int n;
                int n2;
                object2 = (MapWaypoint)((Object)object.next());
                Point2D point2D = this.map.getTileFactory().geoToPixel(((MapWaypoint)((Object)object2)).getPosition(), this.map.getZoom());
                if (rectangle2D.contains(point2D)) {
                    n2 = (int)(point2D.getX() - rectangle2D.getX());
                    n = (int)(point2D.getY() - rectangle2D.getY());
                } else {
                    if (!rectangle2D2.contains(point2D)) continue;
                    n2 = (int)(point2D.getX() - rectangle2D2.getX());
                    n = (int)(point2D.getY() - rectangle2D2.getY());
                }
                point2D = new Point((int)(point.getX() - (double)n2), (int)(point.getY() - (double)n));
                Object object3 = object2;
                if (!MapRendererFactoryMethod.getRenderer((Waypoint)object3).contains((Point)point2D)) continue;
                return object2;
            }
            return null;
        }

        public final void setTrackRenderer(BT747TrackRenderer bT747TrackRenderer) {
            this.trackRenderer = bT747TrackRenderer;
        }

        /* synthetic */ MyWaypointPainter(WaypointMapKit waypointMapKit, byte by) {
            this(waypointMapKit);
        }
    }

    static final class MyLinkAction
    extends OpenBrowserAction {
        private String des;
        private String url;

        public MyLinkAction(String string, String string2) {
            this.des = string;
            this.url = string2;
        }

        public final String toString() {
            return this.des;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            TaggedFilePathFactory.openURL(this.url);
        }
    }
}

