/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Deprecated
public abstract class TransportSingleItemBulkWriteAction<Request extends ReplicatedWriteRequest<Request>, Response extends ReplicationResponse>
extends TransportWriteAction<Request, Request, Response> {
    private final TransportBulkAction bulkAction;
    private final TransportShardBulkAction shardBulkAction;

    protected TransportSingleItemBulkWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<Request> replicaRequest, String executor, TransportBulkAction bulkAction, TransportShardBulkAction shardBulkAction) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, request, replicaRequest, executor);
        this.bulkAction = bulkAction;
        this.shardBulkAction = shardBulkAction;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        this.bulkAction.execute(task, TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(request), TransportSingleItemBulkWriteAction.wrapBulkResponse(listener));
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<Request, Response> shardOperationOnPrimary(Request request, IndexShard primary) throws Exception {
        Object response;
        Exception failure;
        BulkItemRequest[] itemRequests = new BulkItemRequest[1];
        WriteRequest.RefreshPolicy refreshPolicy = ((ReplicatedWriteRequest)request).getRefreshPolicy();
        ((ReplicatedWriteRequest)request).setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        itemRequests[0] = new BulkItemRequest(0, (DocWriteRequest)request);
        BulkShardRequest bulkShardRequest = new BulkShardRequest(((ReplicationRequest)request).shardId(), refreshPolicy, itemRequests);
        TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> bulkResult = this.shardBulkAction.shardOperationOnPrimary(bulkShardRequest, primary);
        assert (((BulkShardResponse)bulkResult.finalResponseIfSuccessful).getResponses().length == 1) : "expected only one bulk shard response";
        BulkItemResponse itemResponse = ((BulkShardResponse)bulkResult.finalResponseIfSuccessful).getResponses()[0];
        if (itemResponse.isFailed()) {
            failure = itemResponse.getFailure().getCause();
            response = null;
        } else {
            response = itemResponse.getResponse();
            failure = null;
        }
        return new TransportWriteAction.WritePrimaryResult(request, response, bulkResult.location, failure, primary, this.logger);
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<Request> shardOperationOnReplica(Request replicaRequest, IndexShard replica) throws Exception {
        BulkItemRequest[] itemRequests = new BulkItemRequest[1];
        WriteRequest.RefreshPolicy refreshPolicy = ((ReplicatedWriteRequest)replicaRequest).getRefreshPolicy();
        itemRequests[0] = new BulkItemRequest(0, (DocWriteRequest)replicaRequest);
        BulkShardRequest bulkShardRequest = new BulkShardRequest(((ReplicationRequest)replicaRequest).shardId(), refreshPolicy, itemRequests);
        TransportWriteAction.WriteReplicaResult<BulkShardRequest> result = this.shardBulkAction.shardOperationOnReplica(bulkShardRequest, replica);
        return new TransportWriteAction.WriteReplicaResult<Request>(replicaRequest, result.location, null, replica, this.logger);
    }

    public static <Response extends ReplicationResponse> ActionListener<BulkResponse> wrapBulkResponse(ActionListener<Response> listener) {
        return ActionListener.wrap(bulkItemResponses -> {
            assert (bulkItemResponses.getItems().length == 1) : "expected only one item in bulk request";
            BulkItemResponse bulkItemResponse = bulkItemResponses.getItems()[0];
            if (!bulkItemResponse.isFailed()) {
                Object response = bulkItemResponse.getResponse();
                listener.onResponse(response);
            } else {
                listener.onFailure(bulkItemResponse.getFailure().getCause());
            }
        }, listener::onFailure);
    }

    public static BulkRequest toSingleItemBulkRequest(ReplicatedWriteRequest request) {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.add((DocWriteRequest)((Object)request));
        bulkRequest.setRefreshPolicy(request.getRefreshPolicy());
        bulkRequest.timeout(request.timeout());
        bulkRequest.waitForActiveShards(request.waitForActiveShards());
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        return bulkRequest;
    }
}

