/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangRef
extends OtpErlangObject {
    private static final long serialVersionUID = -7022666480768586521L;
    private final int tag;
    private final String node;
    private final int creation;
    private int[] ids = null;

    @Deprecated
    public OtpErlangRef(OtpLocalNode otpLocalNode) {
        OtpErlangRef otpErlangRef = otpLocalNode.createRef();
        this.tag = otpErlangRef.tag;
        this.ids = otpErlangRef.ids;
        this.creation = otpErlangRef.creation;
        this.node = otpErlangRef.node;
    }

    public OtpErlangRef(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangRef otpErlangRef = otpInputStream.read_ref();
        this.tag = otpErlangRef.tag;
        this.node = otpErlangRef.node();
        this.creation = otpErlangRef.creation();
        this.ids = otpErlangRef.ids();
    }

    public OtpErlangRef(String string, int n, int n2) {
        this.tag = 114;
        this.node = string;
        this.ids = new int[1];
        this.ids[0] = n & 0x3FFFF;
        this.creation = n2 & 3;
    }

    public OtpErlangRef(String string, int[] nArray, int n) {
        this(114, string, nArray, n);
    }

    public OtpErlangRef(int n, String string, int[] nArray, int n2) {
        this.tag = n;
        this.node = string;
        int n3 = nArray.length;
        this.ids = new int[3];
        this.ids[0] = 0;
        this.ids[1] = 0;
        this.ids[2] = 0;
        if (n3 > 3) {
            n3 = 3;
        }
        System.arraycopy(nArray, 0, this.ids, 0, n3);
        if (n == 114) {
            this.creation = n2 & 3;
            this.ids[0] = this.ids[0] & 0x3FFFF;
        } else {
            this.creation = n2;
        }
    }

    protected int tag() {
        return this.tag;
    }

    public int id() {
        return this.ids[0];
    }

    public int[] ids() {
        return this.ids;
    }

    public boolean isNewRef() {
        return this.ids.length > 1;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        String string = "#Ref<" + this.node;
        for (int i = 0; i < this.ids.length; ++i) {
            string = string + "." + this.ids[i];
        }
        string = string + ">";
        return string;
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_ref(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangRef)) {
            return false;
        }
        OtpErlangRef otpErlangRef = (OtpErlangRef)object;
        if (!this.node.equals(otpErlangRef.node()) || this.creation != otpErlangRef.creation()) {
            return false;
        }
        if (this.isNewRef() && otpErlangRef.isNewRef()) {
            return this.ids[0] == otpErlangRef.ids[0] && this.ids[1] == otpErlangRef.ids[1] && this.ids[2] == otpErlangRef.ids[2];
        }
        return this.ids[0] == otpErlangRef.ids[0];
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(7);
        hash.combine(this.creation, this.ids[0]);
        if (this.isNewRef()) {
            hash.combine(this.ids[1], this.ids[2]);
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangRef otpErlangRef = (OtpErlangRef)super.clone();
        otpErlangRef.ids = (int[])this.ids.clone();
        return otpErlangRef;
    }
}

