

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Include Only Points Inside Polygon (polygon){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Include Only Points Inside Polygon (polygon)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_bend.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_arc.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_polygon"></a>Include Only Points Inside Polygon (polygon)</h2></div></div></div><p> 
The polygon filter includes points if they are inside
of a polygon.  A polygon file looks like an 
<a class="link" href="filter_arc.html" title="Include Only Points Within Distance of Arc (arc)">arc</a> file, except
that the arc it describes must be a closed cycle.  That is,
for a simple polygon, the first and last points must be the
same.  Here's a square:
</p><pre class="screen">
# A square (not really) polygon
41.0000       -85.0000
41.0000       -86.0000
42.0000       -86.0000
42.0000       -85.0000
41.0000       -85.0000
</pre><p> 
Polygons may include islands and holes.  To include an
island or a hole, just append it to the main polygon.
</p><pre class="screen">
# A square polygon with a triangular hole
41.0000       -85.0000
41.0000       -86.0000
42.0000       -86.0000
42.0000       -85.0000
41.0000       -85.0000
# The hole begins here
41.5000       -85.5000
41.6000       -85.5000
41.6000       -85.6000
41.5000       -85.5000
</pre><p>
As with the arc filter, you define a polygon by
giving the name of the file that contains it, using
the <code class="option">file</code> option.  
</p><p> 
Note that this filter currently will not work properly
if your polygon contains one or both poles or if it spans the
line of 180 degrees east or west longitude.
</p><div class="example"><a id="example_polygon_filter"></a><p class="title"><strong>Example 4.1. Using the polygon filter</strong></p><div class="example-contents"><p> 
Suppose you have a polygon file that defines the border of your county, 
called mycounty.txt.  This command line will give you only the points 
in your county:
</p><p><strong class="userinput"><code>gpsbabel -i geo -f 1.loc -x polygon,file=mycounty.txt -o mapsend -F 2.wpt</code></strong></p></div></div><br class="example-break" /><div class="example"><a id="example_in_or_close_to"></a><p class="title"><strong>Example 4.2. Using the polygon and arc filters to find points in or nearly in a 
polygon</strong></p><div class="example-contents"><p>
Because the polygon and <a class="link" href="filter_arc.html" title="Include Only Points Within Distance of Arc (arc)">arc</a> filters use
the same file format, you can use them together to find all points that are
"in or nearly in" a polygon.  This can be useful if your waypoints or the 
boundaries of your polygon are not quite perfect, so you want to provide a 
buffer zone around it in case there are points nearby that should be in the 
polygon but aren't quite.
</p><p><strong class="userinput"><code>
gpsbabel -i gpx -f points.gpx -x stack,push -x polygon,file=mycounty.txt 
-x stack,swap -x arc,file=mycounty.txt,distance=1k -x stack,pop,append 
-x duplicate,shortname -o gpx -F nearmycounty.gpx
</code></strong></p><p>
This command makes a copy of the points, finds the ones that are in your
your county, swaps that result with the copy of the original set of points,
finds the ones from that set that are within 1 km of the border of the county, 
puts the two lists together, and then filters out any points that appear twice
(This step is necessary because points inside the county but near the county 
line will be kept by both the polygon and the arc filter.)
</p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_polygon_o_file"></a>file option</h3></div></div></div><p>
      File containing vertices of polygon.
    </p><p>
This option is required.
</p><p>
This option specifies the name of the file containing the polygon to use for
filtering.  The format of the file is as described above.
</p><p>
GPSBabel supports converting any route or track to a file usable by this
filter; simply read it in the normal way and write it using the 
<a class="link" href="fmt_arc.html" title="GPSBabel arc filter file (arc)">arc</a> file format.  Afterward, you will 
need to make sure that the first point and the last point in the 
file are the same, as the polygon filter depends on that.  You can do so
with any text editor.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_polygon_o_exclude"></a>exclude option</h3></div></div></div><p>
      Exclude points inside the polygon.
    </p><p>
When this option is specified, the usual sense of the polygon filter is 
reversed.   That is, points that are inside the polygon are discarded
while points that are further away are kept.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_bend.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_arc.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Add points before and after bends in routes (bend) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Include Only Points Within Distance of Arc (arc)</td></tr></table></div>
  
      {/literal}{/block}
  