/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.IntegerRange;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class AltitudeRange {
    private IntegerRange _range = new IntegerRange();
    private boolean _gotPreviousValue;
    private int _previousValue;
    private int _climb;
    private int _descent;
    private boolean _gotPreviousMinimum = false;
    private boolean _gotPreviousMaximum = false;
    private int _previousExtreme = 0;

    public AltitudeRange() {
        this.clear();
    }

    public void clear() {
        this._range.clear();
        this._descent = 0;
        this._climb = 0;
        this._gotPreviousValue = false;
        this._previousValue = 0;
        this._gotPreviousMaximum = false;
        this._gotPreviousMinimum = false;
        this._previousExtreme = 0;
    }

    public void addValue(Altitude altitude) {
        int n = Config.getConfigInt("prune.altitudetolerance") / 100;
        if (altitude != null && altitude.isValid()) {
            int n2 = (int)altitude.getMetricValue();
            this._range.addValue(n2);
            if (this._gotPreviousValue) {
                if (n2 != this._previousValue) {
                    boolean bl;
                    boolean bl2 = n2 > this._previousValue;
                    boolean bl3 = this._gotPreviousMinimum && this._previousValue > this._previousExtreme;
                    boolean bl4 = this._gotPreviousMaximum && this._previousValue < this._previousExtreme;
                    boolean bl5 = bl = Math.abs(n2 - this._previousValue) > n;
                    if (!this._gotPreviousMinimum && !this._gotPreviousMaximum) {
                        if (bl) {
                            if (bl2) {
                                this._gotPreviousMinimum = true;
                            } else {
                                this._gotPreviousMaximum = true;
                            }
                            this._previousExtreme = this._previousValue;
                            this._previousValue = n2;
                            this._gotPreviousValue = true;
                        }
                    } else if (bl3) {
                        if (bl2) {
                            this._previousValue = n2;
                        } else if (bl) {
                            this._climb += this._previousValue - this._previousExtreme;
                            this._previousExtreme = this._previousValue;
                            this._gotPreviousMinimum = false;
                            this._gotPreviousMaximum = true;
                            this._previousValue = n2;
                            this._gotPreviousValue = true;
                        }
                    } else if (bl4) {
                        if (bl2) {
                            if (bl) {
                                this._descent += this._previousExtreme - this._previousValue;
                                this._previousExtreme = this._previousValue;
                                this._gotPreviousMinimum = true;
                                this._gotPreviousMaximum = false;
                                this._previousValue = n2;
                                this._gotPreviousValue = true;
                            }
                        } else {
                            this._previousValue = n2;
                            this._gotPreviousValue = true;
                        }
                    }
                }
            } else {
                this._previousValue = n2;
                this._gotPreviousValue = true;
            }
        }
    }

    public void ignoreValue(Altitude altitude) {
        if (this._gotPreviousValue && this._gotPreviousMinimum && this._previousValue > this._previousExtreme) {
            this._climb += this._previousValue - this._previousExtreme;
        } else if (this._gotPreviousValue && this._gotPreviousMaximum && this._previousValue < this._previousExtreme) {
            this._descent += this._previousExtreme - this._previousValue;
        }
        this._gotPreviousMaximum = false;
        this._gotPreviousMinimum = false;
        this._gotPreviousValue = false;
        if (altitude != null && altitude.isValid()) {
            int n = (int)altitude.getMetricValue();
            this._range.addValue(n);
            this._previousValue = n;
            this._gotPreviousValue = true;
        }
    }

    public boolean hasRange() {
        return this._range.getMaximum() > this._range.getMinimum();
    }

    public int getMinimum(Unit unit) {
        if (this._range.getMinimum() <= 0) {
            return this._range.getMinimum();
        }
        return (int)((double)this._range.getMinimum() * unit.getMultFactorFromStd());
    }

    public int getMaximum(Unit unit) {
        if (this._range.getMaximum() <= 0) {
            return this._range.getMaximum();
        }
        return (int)((double)this._range.getMaximum() * unit.getMultFactorFromStd());
    }

    public int getClimb(Unit unit) {
        int n = 0;
        if (this._gotPreviousValue && this._gotPreviousMinimum && this._previousValue > this._previousExtreme) {
            n = this._previousValue - this._previousExtreme;
        }
        return (int)((double)(this._climb + n) * unit.getMultFactorFromStd());
    }

    public int getDescent(Unit unit) {
        int n = 0;
        if (this._gotPreviousValue && this._gotPreviousMaximum && this._previousValue < this._previousExtreme) {
            n = this._previousExtreme - this._previousValue;
        }
        return (int)((double)(this._descent + n) * unit.getMultFactorFromStd());
    }

    public double getMetricHeightDiff() {
        return this.getClimb(UnitSetLibrary.UNITS_METRES) - this.getDescent(UnitSetLibrary.UNITS_METRES);
    }
}

