/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.AnnotationElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        AnnotationElement annotationElement = new AnnotationElement();
        if (annotationElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createCompositeNode"));
        }
        return annotationElement;
    }

    @Override
    public PsiAnnotation createPsi(@NotNull PsiAnnotationStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createAnnotation(stub);
    }

    @Override
    public PsiAnnotation createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createPsi"));
        }
        return new PsiAnnotationImpl(node);
    }

    @Override
    public PsiAnnotationStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String text2 = LightTreeUtil.toFilteredString(tree, node, null);
        return new PsiAnnotationStubImpl(parentStub, text2);
    }

    @Override
    public void serialize(@NotNull PsiAnnotationStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "serialize"));
        }
        dataStream.writeUTFFast(stub.getText());
    }

    @Override
    @NotNull
    public PsiAnnotationStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "deserialize"));
        }
        PsiAnnotationStubImpl psiAnnotationStubImpl = new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
        if (psiAnnotationStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "deserialize"));
        }
        return psiAnnotationStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiAnnotationStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "indexStub"));
        }
        String shortName = JavaAnnotationElementType.getReferenceShortName(stub.getText());
        if (!StringUtil.isEmptyOrSpaces(shortName)) {
            sink.occurrence(JavaStubIndexKeys.ANNOTATIONS, shortName);
        }
    }

    private static String getReferenceShortName(String annotationText) {
        int index2 = annotationText.indexOf(40);
        if (index2 >= 0) {
            annotationText = annotationText.substring(0, index2);
        }
        return PsiNameHelper.getShortClassName(annotationText);
    }
}

