/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

public class AnnotationResolverImpl
extends AnnotationResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public AnnotationResolverImpl(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull StorageManager storageManager) {
        if (callResolver == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(0);
        }
        if (constantExpressionEvaluator == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(1);
        }
        if (storageManager == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(2);
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(3);
        }
        this.typeResolver = typeResolver;
    }

    @Override
    @NotNull
    public Annotations resolveAnnotationEntries(@NotNull LexicalScope scope, @NotNull List<KtAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(4);
        }
        if (annotationEntryElements == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(5);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(6);
        }
        if (annotationEntryElements.isEmpty()) {
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            if (annotations2 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(7);
            }
            return annotations2;
        }
        ArrayList<AnnotationWithTarget> result2 = new ArrayList<AnnotationWithTarget>(0);
        for (KtAnnotationEntry entryElement : annotationEntryElements) {
            KtAnnotationUseSiteTarget target;
            AnnotationDescriptor descriptor2 = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor2 == null) {
                descriptor2 = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope), entryElement);
            }
            if (shouldResolveArguments) {
                ForceResolveUtil.forceResolveAllContents(descriptor2);
            }
            if ((target = entryElement.getUseSiteTarget()) != null) {
                result2.add(new AnnotationWithTarget(descriptor2, target.getAnnotationUseSiteTarget()));
                continue;
            }
            result2.add(new AnnotationWithTarget(descriptor2, null));
        }
        AnnotationsImpl annotationsImpl = AnnotationsImpl.create(result2);
        if (annotationsImpl == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(8);
        }
        return annotationsImpl;
    }

    @Override
    @NotNull
    public KotlinType resolveAnnotationType(@NotNull LexicalScope scope, @NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace) {
        KtTypeReference typeReference;
        if (scope == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(9);
        }
        if (entryElement == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(11);
        }
        if ((typeReference = entryElement.getTypeReference()) == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
            if (simpleType2 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(12);
            }
            return simpleType2;
        }
        KotlinType type2 = this.typeResolver.resolveType(scope, typeReference, trace, true);
        if (!(type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            SimpleType simpleType3 = ErrorUtils.createErrorType("Not an annotation: " + type2);
            if (simpleType3 == null) {
                AnnotationResolverImpl.$$$reportNull$$$0(13);
            }
            return simpleType3;
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(14);
        }
        return kotlinType;
    }

    public static void checkAnnotationType(@NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (entryElement == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(15);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(16);
        }
        if (results == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(17);
        }
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor2 = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor2)) {
            if (descriptor2 instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
                ClassDescriptor classDescriptor = constructor.getConstructedClass();
                if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor2));
            }
        }
    }

    @Override
    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(@NotNull KtAnnotationEntry annotationEntry, @NotNull LexicalScope scope, @NotNull BindingTrace trace) {
        if (annotationEntry == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(19);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(20);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)annotationEntry, KtAnnotationEntry.class) != null) {
            trace.report(Errors.ANNOTATION_USED_AS_ANNOTATION_ARGUMENT.on(annotationEntry));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(trace, scope, CallMaker.makeCall(null, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfoFactory.EMPTY, true);
        if (overloadResolutionResults == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(21);
        }
        return overloadResolutionResults;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull KtTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        KtModifierList modifierList;
        if (jetTypeParameter == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(22);
        }
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(23);
        }
        if ((modifierList = jetTypeParameter.getModifierList()) == null) {
            return;
        }
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }

    @Override
    @Nullable
    public ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument resolvedArgument) {
        if (trace == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(24);
        }
        if (valueParameter == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(25);
        }
        if (resolvedArgument == null) {
            AnnotationResolverImpl.$$$reportNull$$$0(26);
        }
        return this.constantExpressionEvaluator.getAnnotationArgumentValue(trace, valueParameter, resolvedArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationEntryElements";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/AnnotationResolverImpl";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationEntry";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetTypeParameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/AnnotationResolverImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationEntries";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAnnotationCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTypeResolver";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationEntries";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationCall";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportUnsupportedAnnotationForTypeParameter";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationArgumentValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

