/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Incubating;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    VERSION_1_1(false),
    VERSION_1_2(false),
    VERSION_1_3(false),
    VERSION_1_4(false),
    VERSION_1_5(true),
    VERSION_1_6(true),
    VERSION_1_7(true),
    VERSION_1_8(true),
    VERSION_1_9(true),
    VERSION_1_10(true);

    private static JavaVersion currentJavaVersion;
    private final boolean hasMajorVersion;
    private final String versionName;
    private final String majorVersion;

    private JavaVersion(boolean hasMajorVersion) {
        this.hasMajorVersion = hasMajorVersion;
        this.versionName = this.name().substring("VERSION_".length()).replace('_', '.');
        this.majorVersion = this.name().substring(10);
    }

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        int versionIdx;
        int index;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        String name = value.toString();
        Matcher matcher = Pattern.compile("(\\d{1,2})(\\D.+)?").matcher(name);
        if (matcher.matches() && (index = Integer.parseInt(matcher.group(1)) - 1) > 0 && index < JavaVersion.values().length && JavaVersion.values()[index].hasMajorVersion) {
            return JavaVersion.values()[index];
        }
        matcher = Pattern.compile("1\\.(\\d{1,2})(\\D.+)?").matcher(name);
        if (matcher.matches() && (versionIdx = Integer.parseInt(matcher.group(1)) - 1) >= 0 && versionIdx < JavaVersion.values().length) {
            return JavaVersion.values()[versionIdx];
        }
        throw new IllegalArgumentException(String.format("Could not determine java version from '%s'.", name));
    }

    public static JavaVersion current() {
        if (currentJavaVersion == null) {
            currentJavaVersion = JavaVersion.toVersion(System.getProperty("java.version"));
        }
        return currentJavaVersion;
    }

    @VisibleForTesting
    static void resetCurrent() {
        currentJavaVersion = null;
    }

    public static JavaVersion forClassVersion(int classVersion) {
        int index = classVersion - 45;
        if (index >= 0 && index < JavaVersion.values().length) {
            return JavaVersion.values()[index];
        }
        throw new IllegalArgumentException(String.format("Could not determine java version from '%d'.", classVersion));
    }

    public static JavaVersion forClass(byte[] classData) {
        if (classData.length < 8) {
            throw new IllegalArgumentException("Invalid class format. Should contain at least 8 bytes");
        }
        return JavaVersion.forClassVersion(classData[7] & 0xFF);
    }

    public boolean isJava5() {
        return this == VERSION_1_5;
    }

    public boolean isJava6() {
        return this == VERSION_1_6;
    }

    public boolean isJava7() {
        return this == VERSION_1_7;
    }

    private boolean isJava8() {
        return this == VERSION_1_8;
    }

    private boolean isJava9() {
        return this == VERSION_1_9;
    }

    private boolean isJava10() {
        return this == VERSION_1_10;
    }

    public boolean isJava5Compatible() {
        return this.compareTo(VERSION_1_5) >= 0;
    }

    public boolean isJava6Compatible() {
        return this.compareTo(VERSION_1_6) >= 0;
    }

    public boolean isJava7Compatible() {
        return this.compareTo(VERSION_1_7) >= 0;
    }

    public boolean isJava8Compatible() {
        return this.compareTo(VERSION_1_8) >= 0;
    }

    public boolean isJava9Compatible() {
        return this.compareTo(VERSION_1_9) >= 0;
    }

    @Incubating
    public boolean isJava10Compatible() {
        return this.compareTo(VERSION_1_10) >= 0;
    }

    public String toString() {
        return this.getName();
    }

    private String getName() {
        return this.versionName;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }
}

