#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cipher-aes
version: 0.2.11
id: cipher-aes-0.2.11-2xHF7v9Ai3H7twINNj3iK3
key: cipher-aes-0.2.11-2xHF7v9Ai3H7twINNj3iK3
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-cipher-aes
synopsis: Fast AES cipher implementation with advanced mode of operations
description:
    Fast AES cipher implementation with advanced mode of operations.
    .
    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).
    .
    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.
    .
    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.
    .
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Cipher.AES
abi: 4712f6c6a2fb2d1e6e3d3c15a878d0c9
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/cipher-aes-0.2.11
library-dirs: /usr/lib/ghc-8.2.1/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/cipher-aes-0.2.11
hs-libraries: HScipher-aes-0.2.11-2xHF7v9Ai3H7twINNj3iK3
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    byteable-0.1.1-3VfNJqauCum9lD10cS8nmH
    securemem-0.1.9-GTQwympfF3w736qg9vbn32
    crypto-cipher-types-0.0.9-KApWOduGs2yID3TeJ4j5ee
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             byteable-0.1.1-3VfNJqauCum9lD10cS8nmH=1033f0009ffea40431f55947ee171f57
             securemem-0.1.9-GTQwympfF3w736qg9vbn32=e6fa16c2bf1cdd506a0e053e2ca11551
             crypto-cipher-types-0.0.9-KApWOduGs2yID3TeJ4j5ee=4b4bf6c8eb27905f73119f2bad31790c
haddock-interfaces: /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html: /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

