#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.5.3
id: esqueleto-2.5.3-KPb5DcZWPoW7Yd8rbPpYJ6
key: esqueleto-2.5.3-KPb5DcZWPoW7Yd8rbPpYJ6
license: BSD3
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
indefinite: False
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.PostgreSQL
hidden-modules: Database.Esqueleto.Internal.PersistentImport
abi: 0da340adb3d9477e5d26f5fcef4d5e14
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/esqueleto-2.5.3
library-dirs: /usr/lib/ghc-8.2.1/site-local/esqueleto-2.5.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/esqueleto-2.5.3
hs-libraries: HSesqueleto-2.5.3-KPb5DcZWPoW7Yd8rbPpYJ6
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    persistent-2.7.1-5rmtUTby7kSGSKF597S8Jy transformers-0.5.2.0
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG
    monad-logger-0.3.25.1-6UjEl6EQeds1mtR2hwOxFY
    conduit-1.2.12.1-675zH3bb85ZA0Qb4jnuu4h
    resourcet-1.1.9-L2AvjA6mP5RDwDqcbBVGV9
    blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             persistent-2.7.1-5rmtUTby7kSGSKF597S8Jy=fe6c408718ec6e6db31a4b9f50ef255e
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG=fee9dd37afd44fe7a6a3e8c00aaf438e
             monad-logger-0.3.25.1-6UjEl6EQeds1mtR2hwOxFY=3fa61b4da1f1e00f34e7b0e16c71c3a2
             conduit-1.2.12.1-675zH3bb85ZA0Qb4jnuu4h=bb78905b1378fcce46c05f1a905b300f
             resourcet-1.1.9-L2AvjA6mP5RDwDqcbBVGV9=2ffddbfcc20d0db652f15951a99e02a7
             blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh=4d7402d6bc242682528205229a7d9db9
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

